/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.shadow.com.github.technus.avrClone.compiler;

import com.github.technus.tectech.shadow.com.github.technus.avrClone.compiler.exceptions.CompilerException;

public class Line {
    public static final String NAME_FORMAT = "([a-zA-Z][0-9a-zA-Z_]*)";
    public static final String NAME_TERMINATOR = "[^0-9a-zA-Z_]";
    private static final String[] NO_EXPRESSIONS = new String[0];
    private static final String NO_EXPRESSION = "";
    private final String labelOrPointer;
    private final String includeName;
    private final String includePath;
    private final String line;
    private final String sanitizedLine;
    private final String mnemonic;
    private final String directive;
    private final int lineNumber;
    private boolean listing = false;
    private boolean enabled = true;
    private boolean processed;
    private String evaluatedArguments;
    private String arguments;

    public Line(String includePath, String includeName, int lineNumberInFile, String lineContent, boolean shouldList) throws CompilerException {
        this.line = lineContent;
        this.sanitizedLine = Line.sanitizeLine(lineContent);
        this.mnemonic = Line.getMnemonic(this.sanitizedLine);
        this.directive = Line.getDirectiveName(this.sanitizedLine);
        if (this.directive != null && this.mnemonic != null) {
            throw new CompilerException("Invalid line: " + includePath + " " + lineContent);
        }
        this.labelOrPointer = Line.getLabelOrPointerName(this.sanitizedLine);
        this.arguments = Line.getExpressionsString(this.sanitizedLine);
        this.lineNumber = lineNumberInFile;
        this.includePath = includePath;
        this.includeName = includeName;
        this.listing = shouldList;
    }

    public Line(Line toClone, boolean keepStatus) {
        this.includeName = toClone.includeName;
        this.includePath = toClone.includePath;
        this.line = toClone.line;
        this.labelOrPointer = toClone.labelOrPointer;
        this.sanitizedLine = toClone.sanitizedLine;
        this.lineNumber = toClone.lineNumber;
        this.mnemonic = toClone.mnemonic;
        this.directive = toClone.directive;
        this.arguments = toClone.arguments;
        if (keepStatus) {
            this.enabled = toClone.enabled;
            this.processed = toClone.processed;
            this.evaluatedArguments = toClone.evaluatedArguments;
            this.listing = toClone.listing;
        }
    }

    public void setListing(boolean listing) {
        this.listing = listing;
    }

    public boolean isListing() {
        return this.listing;
    }

    public String getLine() {
        return this.line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getIncludePath() {
        return this.includePath;
    }

    public String getIncludeName() {
        return this.includeName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public String getLabelOrPointerName() {
        return this.labelOrPointer;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getDirectiveName() {
        return this.directive;
    }

    public String getTextArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
        this.evaluatedArguments = null;
    }

    public String[] getTextArgumentArray() {
        return Line.splitExpressionsString(this.arguments);
    }

    public void setEvaluatedArguments(String evaluatedArguments) {
        this.evaluatedArguments = evaluatedArguments;
    }

    public String getEvaluatedArguments() {
        return this.evaluatedArguments;
    }

    public String[] getEvaluatedArgumentArray() {
        return Line.splitExpressionsString(this.evaluatedArguments);
    }

    public String getLatestArguments() {
        return this.evaluatedArguments == null ? this.arguments : this.evaluatedArguments;
    }

    public String[] getLatestArgumentArray() {
        return Line.splitExpressionsString(this.evaluatedArguments == null ? this.arguments : this.evaluatedArguments);
    }

    private static boolean containsLabelOrPointerName(String line) {
        return line.matches("^([a-zA-Z][0-9a-zA-Z_]*):.*$");
    }

    private static String getLabelOrPointerName(String line) {
        return Line.containsLabelOrPointerName(line) ? line.replaceFirst(":.*$", NO_EXPRESSION) : null;
    }

    private static boolean containsDirectiveName(String line) {
        return line.matches("^(?:([a-zA-Z][0-9a-zA-Z_]*):)?\\.([a-zA-Z][0-9a-zA-Z_]*)(?: .*)?$");
    }

    private static String getDirectiveName(String line) {
        return Line.containsDirectiveName(line) ? line.replaceFirst("^(?:([a-zA-Z][0-9a-zA-Z_]*):)?\\.", NO_EXPRESSION).replaceFirst(" .*$", NO_EXPRESSION) : null;
    }

    private static boolean containsMnemonic(String line) {
        return line.matches("^(?:([a-zA-Z][0-9a-zA-Z_]*):)?([a-zA-Z][0-9a-zA-Z_]*)(?: .*)?$");
    }

    private static String getMnemonic(String line) {
        return Line.containsMnemonic(line) ? line.replaceFirst("^(?:([a-zA-Z][0-9a-zA-Z_]*):)?", NO_EXPRESSION).replaceFirst(" .*$", NO_EXPRESSION) : null;
    }

    private static String getExpressionsString(String line) {
        if (Line.containsMnemonic(line) || Line.containsDirectiveName(line)) {
            return line.replaceFirst("^(?:([a-zA-Z][0-9a-zA-Z_]*):)?\\.?([a-zA-Z][0-9a-zA-Z_]*) ?", NO_EXPRESSION);
        }
        return NO_EXPRESSION;
    }

    private static String[] splitExpressionsString(String expressions) {
        if (expressions == null || expressions.length() == 0) {
            return NO_EXPRESSIONS;
        }
        if (expressions.contains("`")) {
            return expressions.split("`");
        }
        if (expressions.contains("(") || expressions.contains("[")) {
            return expressions.split("`");
        }
        return expressions.split(",");
    }

    public static String sanitizeLine(String line) {
        return line.replaceAll("[\\r\\n]", NO_EXPRESSION).replaceAll("[\\s]+", " ").replaceFirst(" *;.*$", NO_EXPRESSION).replaceFirst(" *\\\\\\\\.*$", NO_EXPRESSION).replaceFirst("^ ", NO_EXPRESSION).replaceFirst(" $", NO_EXPRESSION).replaceAll(" *: *", ":").replaceAll(" *\\. *", ".").replaceAll(" *, *", ",").replaceAll(" *` *", "`");
    }

    public String toString() {
        return this.lineNumber + ":" + this.getLine();
    }
}

