/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.core;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.battlegear2.api.core.InventorySlotType;
import mods.battlegear2.api.core.UnhandledInventoryItemEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;

public class InventoryPlayerBattle
extends InventoryPlayer {
    public boolean hasChanged = true;
    public static int ARMOR_OFFSET = 100;
    public static int OFFSET = 150;
    public static int WEAPON_SETS = 3;
    public static int EXTRA_ITEMS = WEAPON_SETS * 2;
    public static int EXTRA_INV_SIZE = EXTRA_ITEMS + 6 + 6;
    public ItemStack[] extraItems = new ItemStack[EXTRA_INV_SIZE];

    public InventoryPlayerBattle(EntityPlayer entityPlayer) {
        super(entityPlayer);
    }

    public boolean isBattlemode() {
        return this.field_70461_c >= OFFSET && this.field_70461_c < OFFSET + EXTRA_ITEMS;
    }

    public int requestNewSlot(InventorySlotType type) {
        switch (type) {
            case MAIN: {
                if (this.field_70462_a.length + 1 >= ARMOR_OFFSET) break;
                ItemStack[] temp = new ItemStack[this.field_70462_a.length + 1];
                System.arraycopy(this.field_70462_a, 0, temp, 0, this.field_70462_a.length);
                this.field_70462_a = temp;
                return this.field_70462_a.length - 1;
            }
            case ARMOR: {
                if (ARMOR_OFFSET + this.field_70460_b.length + 1 >= OFFSET) break;
                ItemStack[] temp = new ItemStack[this.field_70460_b.length + 1];
                System.arraycopy(this.field_70460_b, 0, temp, 0, this.field_70460_b.length);
                this.field_70460_b = temp;
                return ARMOR_OFFSET + this.field_70460_b.length - 1;
            }
            case BATTLE: {
                ItemStack[] temp = new ItemStack[this.extraItems.length + 1];
                System.arraycopy(this.extraItems, 0, temp, 0, this.extraItems.length);
                this.extraItems = temp;
                return OFFSET + this.extraItems.length - 1;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static boolean isValidSwitch(int id) {
        return id >= 0 && id < InventoryPlayerBattle.func_70451_h() || id >= OFFSET && id < OFFSET + EXTRA_ITEMS;
    }

    private int getInventorySlotContainItem(Item par1) {
        for (int j = 0; j < this.extraItems.length; ++j) {
            if (this.extraItems[j] == null || this.extraItems[j].func_77973_b() != par1) continue;
            return j;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    private int getInventorySlotContainItemAndDamage(Item par1, int par2) {
        for (int k = 0; k < this.extraItems.length; ++k) {
            if (this.extraItems[k] == null || this.extraItems[k].func_77973_b() != par1 || this.extraItems[k].func_77960_j() != par2) continue;
            return k;
        }
        return -1;
    }

    public ItemStack func_70448_g() {
        return this.isBattlemode() ? this.extraItems[this.field_70461_c - OFFSET] : super.func_70448_g();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_146030_a(Item targetItem, int targetDamage, boolean compareWithDamage, boolean forceInEmptySlots) {
        if (!this.isBattlemode()) {
            super.func_146030_a(targetItem, targetDamage, compareWithDamage, forceInEmptySlots);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70453_c(int direction) {
        if (this.isBattlemode()) {
            if (direction > 0) {
                direction = 1;
            } else if (direction != 0) {
                direction = -1;
            }
            this.field_70461_c -= direction;
            while (this.field_70461_c < OFFSET) {
                this.field_70461_c += WEAPON_SETS;
            }
            while (this.field_70461_c >= OFFSET + WEAPON_SETS) {
                this.field_70461_c -= WEAPON_SETS;
            }
        } else {
            super.func_70453_c(direction);
        }
    }

    public int func_146027_a(Item targetId, int targetDamage) {
        int stacks = 0;
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null || targetId != null && this.extraItems[i].func_77973_b() != targetId || targetDamage > -1 && this.extraItems[i].func_77960_j() != targetDamage) continue;
            stacks += this.extraItems[i].field_77994_a;
            this.extraItems[i] = null;
        }
        this.hasChanged = stacks > 0;
        return super.func_146027_a(targetId, targetDamage) + stacks;
    }

    public void func_70429_k() {
        super.func_70429_k();
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            this.extraItems[i].func_77945_a(this.field_70458_d.field_70170_p, (Entity)this.field_70458_d, i + OFFSET, this.field_70461_c == i + OFFSET);
        }
    }

    public boolean func_146026_a(Item par1) {
        int j = this.getInventorySlotContainItem(par1);
        if (j < 0) {
            return super.func_146026_a(par1);
        }
        this.hasChanged = true;
        if (--this.extraItems[j].field_77994_a <= 0) {
            this.extraItems[j] = null;
        }
        return true;
    }

    public boolean func_146028_b(Item par1) {
        if (super.func_146028_b(par1)) {
            return true;
        }
        int j = this.getInventorySlotContainItem(par1);
        return j >= 0;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot >= OFFSET) {
            ItemStack targetStack = this.extraItems[slot - OFFSET];
            if (targetStack != null) {
                this.hasChanged = true;
                if (targetStack.field_77994_a <= amount) {
                    this.extraItems[slot - InventoryPlayerBattle.OFFSET] = null;
                    return targetStack;
                }
                targetStack = this.extraItems[slot - OFFSET].func_77979_a(amount);
                if (this.extraItems[slot - InventoryPlayerBattle.OFFSET].field_77994_a == 0) {
                    this.extraItems[slot - InventoryPlayerBattle.OFFSET] = null;
                }
                return targetStack;
            }
            return null;
        }
        return super.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        if (slot >= OFFSET) {
            return this.extraItems[slot - OFFSET];
        }
        return super.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.setInventorySlotContents(slot, itemStack, true);
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack, boolean changed) {
        if (slot >= OFFSET) {
            this.hasChanged = changed;
            this.extraItems[slot - InventoryPlayerBattle.OFFSET] = itemStack;
        } else {
            super.func_70299_a(slot, itemStack);
        }
    }

    public float func_146023_a(Block block) {
        if (this.isBattlemode()) {
            ItemStack currentItemStack = this.func_70448_g();
            return currentItemStack != null ? currentItemStack.func_150997_a(block) : 1.0f;
        }
        return super.func_146023_a(block);
    }

    public NBTTagList func_70442_a(NBTTagList par1nbtTagList) {
        NBTTagList nbtList = super.func_70442_a(par1nbtTagList);
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)(i + OFFSET));
            this.extraItems[i].func_77955_b(nbttagcompound);
            nbtList.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbtList;
    }

    public void func_70443_b(NBTTagList nbtTagList) {
        int j;
        NBTTagCompound nbttagcompound;
        int i;
        int highestMain = this.field_70462_a.length;
        int highestArmor = this.field_70460_b.length;
        int highestExtra = this.extraItems.length;
        for (i = 0; i < nbtTagList.func_74745_c(); ++i) {
            nbttagcompound = nbtTagList.func_150305_b(i);
            j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= 0 && j < ARMOR_OFFSET) {
                if (j < highestMain) continue;
                highestMain = j + 1;
                continue;
            }
            if (j >= ARMOR_OFFSET && j < OFFSET) {
                if (j - ARMOR_OFFSET < highestArmor) continue;
                highestArmor = j + 1 - ARMOR_OFFSET;
                continue;
            }
            if (j < OFFSET || j >= 255 || j - OFFSET < highestExtra) continue;
            highestExtra = j + 1 - OFFSET;
        }
        this.field_70462_a = new ItemStack[highestMain];
        this.field_70460_b = new ItemStack[highestArmor];
        this.extraItems = new ItemStack[highestExtra];
        for (i = 0; i < nbtTagList.func_74745_c(); ++i) {
            nbttagcompound = nbtTagList.func_150305_b(i);
            j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            if (itemstack == null) continue;
            if (j >= 0 && j < this.field_70462_a.length) {
                this.field_70462_a[j] = itemstack;
                continue;
            }
            if (j >= ARMOR_OFFSET && j - ARMOR_OFFSET < this.field_70460_b.length) {
                this.field_70460_b[j - InventoryPlayerBattle.ARMOR_OFFSET] = itemstack;
                continue;
            }
            if (j >= OFFSET && j - OFFSET < this.extraItems.length) {
                this.extraItems[j - InventoryPlayerBattle.OFFSET] = itemstack;
                continue;
            }
            MinecraftForge.EVENT_BUS.post((Event)new UnhandledInventoryItemEvent(this.field_70458_d, j, itemstack));
        }
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= OFFSET) {
            return this.extraItems[slot - OFFSET];
        }
        return super.func_70301_a(slot);
    }

    public int func_70302_i_() {
        return this.field_70462_a.length + this.field_70460_b.length;
    }

    public void func_70436_m() {
        this.hasChanged = true;
        super.func_70436_m();
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            this.field_70458_d.func_146097_a(this.extraItems[i], true, false);
            this.extraItems[i] = null;
        }
    }

    public void func_70455_b(InventoryPlayer par1InventoryPlayer) {
        this.field_70462_a = new ItemStack[par1InventoryPlayer.field_70462_a.length];
        this.field_70460_b = new ItemStack[par1InventoryPlayer.field_70460_b.length];
        super.func_70455_b(par1InventoryPlayer);
        if (par1InventoryPlayer instanceof InventoryPlayerBattle) {
            this.extraItems = new ItemStack[((InventoryPlayerBattle)par1InventoryPlayer).extraItems.length];
            for (int i = 0; i < this.extraItems.length; ++i) {
                this.extraItems[i] = ItemStack.func_77944_b((ItemStack)par1InventoryPlayer.func_70301_a(i + OFFSET));
            }
        }
    }

    public ItemStack getCurrentOffhandWeapon() {
        if (this.isBattlemode()) {
            return this.func_70301_a(this.field_70461_c + WEAPON_SETS);
        }
        return null;
    }
}

