/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IFlowerRoot;
import binnie.botany.api.IFlowerType;
import binnie.botany.core.BotanyCore;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.FlowerMutation;
import binnie.botany.genetics.FlowerTemplates;
import binnie.core.util.I18N;
import binnie.genetics.genetics.AlleleHelper;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.alleles.EnumAllele;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum FlowerSpecies implements IAlleleFlowerSpecies
{
    DANDELION("dandelion", "taraxacum", "officinale", EnumFlowerType.DANDELION, EnumFlowerColor.YELLOW),
    POPPY("poppy", "papaver", "rhoeas", EnumFlowerType.POPPY, EnumFlowerColor.RED),
    ORCHID("orchid", "vanda", "coerulea", EnumFlowerType.ORCHID, EnumFlowerColor.DEEP_SKY_BLUE),
    ALLIUM("allium", "allium", "giganteum", EnumFlowerType.ALLIUM, EnumFlowerColor.MEDIUM_PURPLE),
    BLUET("bluet", "houstonia", "caerulea", EnumFlowerType.BLUET, EnumFlowerColor.LAVENDER, EnumFlowerColor.KHAKI),
    TULIP("tulip", "tulipa", "agenensis", EnumFlowerType.TULIP, EnumFlowerColor.VIOLET),
    DAISY("daisy", "leucanthemum", "vulgare", EnumFlowerType.DAISY, EnumFlowerColor.WHITE, EnumFlowerColor.YELLOW),
    CORNFLOWER("cornflower", "centaurea", "cyanus", EnumFlowerType.CORNFLOWER, EnumFlowerColor.SKY_BLUE),
    PANSY("pansy", "viola", "tricolor", EnumFlowerType.PANSY, EnumFlowerColor.PINK, EnumFlowerColor.PURPLE),
    IRIS("iris", "iris", "germanica", EnumFlowerType.IRIS, EnumFlowerColor.LIGHT_GRAY, EnumFlowerColor.PURPLE),
    LAVENDER("lavender", "Lavandula", "angustifolia", EnumFlowerType.LAVENDER, EnumFlowerColor.MEDIUM_ORCHID),
    VIOLA("viola", "viola", "odorata", EnumFlowerType.VIOLA, EnumFlowerColor.MEDIUM_PURPLE, EnumFlowerColor.SLATE_BLUE),
    DAFFODIL("daffodil", "narcissus", "pseudonarcissus", EnumFlowerType.DAFFODIL, EnumFlowerColor.YELLOW, EnumFlowerColor.GOLD),
    DAHLIA("dahlia", "dahlia", "variabilis", EnumFlowerType.DAHLIA, EnumFlowerColor.HOT_PINK, EnumFlowerColor.DEEP_PINK),
    PEONY("peony", "paeonia", "suffruticosa", EnumFlowerType.PEONY, EnumFlowerColor.THISTLE),
    ROSE("rose", "rosa", "rubiginosa", EnumFlowerType.ROSE, EnumFlowerColor.RED),
    LILAC("lilac", "syringa", "vulgaris", EnumFlowerType.LILAC, EnumFlowerColor.PLUM),
    HYDRANGEA("hydrangea", "hydrangea", "macrophylla", EnumFlowerType.HYDRANGEA, EnumFlowerColor.DEEP_SKY_BLUE),
    FOXGLOVE("foxglove", "digitalis", "purpurea", EnumFlowerType.FOXGLOVE, EnumFlowerColor.HOT_PINK),
    ZINNIA("zinnia", "zinnia", "elegans", EnumFlowerType.ZINNIA, EnumFlowerColor.MEDIUM_VIOLET_RED, EnumFlowerColor.YELLOW),
    CHRYSANTHEMUM("chrysanthemum", "chrysanthemum", "\u00ef?? grandiflorum", EnumFlowerType.MUMS, EnumFlowerColor.VIOLET),
    MARIGOLD("marigold", "calendula", "officinalis", EnumFlowerType.MARIGOLD, EnumFlowerColor.GOLD, EnumFlowerColor.DARK_ORANGE),
    GERANIUM("geranium", "geranium", "maderense", EnumFlowerType.GERANIUM, EnumFlowerColor.DEEP_PINK),
    AZALEA("azalea", "rhododendrons", "aurigeranum", EnumFlowerType.AZALEA, EnumFlowerColor.HOT_PINK),
    PRIMROSE("primrose", "primula", "vulgaris", EnumFlowerType.PRIMROSE, EnumFlowerColor.RED, EnumFlowerColor.GOLD),
    ASTER("aster", "aster", "amellus", EnumFlowerType.ASTER, EnumFlowerColor.MEDIUM_PURPLE, EnumFlowerColor.GOLDENROD),
    CARNATION("carnation", "dianthus", "caryophyllus", EnumFlowerType.CARNATION, EnumFlowerColor.CRIMSON, EnumFlowerColor.WHITE),
    LILY("lily", "lilium", "auratum", EnumFlowerType.LILY, EnumFlowerColor.PINK, EnumFlowerColor.GOLD),
    YARROW("yarrow", "achillea", "millefolium", EnumFlowerType.YARROW, EnumFlowerColor.YELLOW),
    PETUNIA("petunia", "petunia", "\u00ef?? atkinsiana", EnumFlowerType.PETUNIA, EnumFlowerColor.MEDIUM_VIOLET_RED, EnumFlowerColor.THISTLE),
    AGAPANTHUS("agapanthus", "agapanthus", "praecox", EnumFlowerType.AGAPANTHUS, EnumFlowerColor.DEEP_SKY_BLUE),
    FUCHSIA("fuchsia", "fuchsia", "magellanica", EnumFlowerType.FUCHSIA, EnumFlowerColor.DEEP_PINK, EnumFlowerColor.MEDIUM_ORCHID),
    DIANTHUS("dianthus", "dianthus", "barbatus", EnumFlowerType.DIANTHUS, EnumFlowerColor.CRIMSON, EnumFlowerColor.HOT_PINK),
    FORGET("forget-me-nots", "myosotis", "arvensis", EnumFlowerType.FORGET, EnumFlowerColor.LIGHT_STEEL_BLUE),
    ANEMONE("anemone", "anemone", "coronaria", EnumFlowerType.ANEMONE, EnumFlowerColor.RED, EnumFlowerColor.MISTY_ROSE),
    AQUILEGIA("aquilegia", "aquilegia", "vulgaris", EnumFlowerType.AQUILEGIA, EnumFlowerColor.SLATE_BLUE, EnumFlowerColor.THISTLE),
    EDELWEISS("edelweiss", "leontopodium", "alpinum", EnumFlowerType.EDELWEISS, EnumFlowerColor.WHITE, EnumFlowerColor.KHAKI),
    SCABIOUS("scabious", "scabiosa", "columbaria", EnumFlowerType.SCABIOUS, EnumFlowerColor.ROYAL_BLUE),
    CONEFLOWER("coneflower", "echinacea", "purpurea", EnumFlowerType.CONEFLOWER, EnumFlowerColor.VIOLET, EnumFlowerColor.DARK_ORANGE),
    GAILLARDIA("gaillardia", "gaillardia", "aristata", EnumFlowerType.GAILLARDIA, EnumFlowerColor.DARK_ORANGE, EnumFlowerColor.YELLOW),
    AURICULA("auricula", "primula", "auricula", EnumFlowerType.AURICULA, EnumFlowerColor.RED, EnumFlowerColor.YELLOW),
    CAMELLIA("camellia", "camellia", "japonica", EnumFlowerType.CAMELLIA, EnumFlowerColor.CRIMSON),
    GOLDENROD("goldenrod", "solidago", "canadensis", EnumFlowerType.GOLDENROD, EnumFlowerColor.GOLD),
    ALTHEA("althea", "althaea", "officinalis", EnumFlowerType.ALTHEA, EnumFlowerColor.THISTLE, EnumFlowerColor.MEDIUM_ORCHID),
    PENSTEMON("penstemon", "penstemon", "digitalis", EnumFlowerType.PENSTEMON, EnumFlowerColor.MEDIUM_ORCHID, EnumFlowerColor.THISTLE),
    DELPHINIUM("delphinium", "delphinium", "staphisagria", EnumFlowerType.DELPHINIUM, EnumFlowerColor.DARK_SLATE_BLUE),
    HOLLYHOCK("hollyhock", "Alcea", "rosea", EnumFlowerType.HOLLYHOCK, EnumFlowerColor.BLACK, EnumFlowerColor.GOLD);

    protected EnumFlowerColor stemColor;
    protected EnumAllele.Fertility fert;
    protected EnumAllele.Lifespan life;
    protected EnumAllele.Sappiness sap;
    protected IFlowerType type;
    protected String name;
    protected String binomial;
    protected String branchName;
    protected EnumFlowerColor primaryColor;
    protected EnumFlowerColor secondaryColor;
    protected EnumTemperature temperature;
    protected EnumAcidity pH;
    protected EnumMoisture moisture;
    protected EnumTolerance tempTolerance;
    protected EnumTolerance pHTolerance;
    protected EnumTolerance moistureTolerance;
    protected List<IAllele[]> variantTemplates;
    protected IClassification branch;

    private FlowerSpecies(String name, String branch, String binomial, IFlowerType type, EnumFlowerColor colour) {
        this(name, branch, binomial, type, colour, colour);
    }

    private FlowerSpecies(String name, String branch, String binomial, IFlowerType type, EnumFlowerColor primaryColor, EnumFlowerColor secondaryColor) {
        this.name = name;
        this.binomial = binomial;
        this.type = type;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.stemColor = EnumFlowerColor.GREEN;
        this.temperature = EnumTemperature.NORMAL;
        this.pH = EnumAcidity.NEUTRAL;
        this.moisture = EnumMoisture.NORMAL;
        this.tempTolerance = EnumTolerance.BOTH_1;
        this.pHTolerance = EnumTolerance.NONE;
        this.moistureTolerance = EnumTolerance.NONE;
        this.variantTemplates = new ArrayList<IAllele[]>();
        this.branchName = branch;
    }

    public static void setupVariants() {
        DANDELION.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.SHORTENED, EnumAllele.Sappiness.LOWER).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.GREEN);
        POPPY.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.SHORTER, EnumAllele.Sappiness.AVERAGE).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.GREEN);
        ORCHID.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.LOW).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setMoisture(EnumMoisture.NORMAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.GREEN);
        ALLIUM.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOW).setPH(EnumAcidity.ALKALINE, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1);
        BLUET.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOWER).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.DAMP, EnumTolerance.NONE).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        TULIP.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.AVERAGE).setMoisture(EnumMoisture.NORMAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        DAISY.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOW).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        CORNFLOWER.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.SHORTER, EnumAllele.Sappiness.LOW).setMutation(DANDELION, TULIP, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        PANSY.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORTENED, EnumAllele.Sappiness.AVERAGE).setMutation(TULIP, VIOLA, 5).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setTemperature(EnumTemperature.WARM, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.SEA_GREEN);
        IRIS.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.AVERAGE).setMutation(ORCHID, VIOLA, 10).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setTemperature(EnumTemperature.WARM, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.SEA_GREEN);
        LAVENDER.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOW).setMutation(ALLIUM, VIOLA, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.UP_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.WARM, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.GREEN);
        VIOLA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORTENED, EnumAllele.Sappiness.AVERAGE).setMutation(ORCHID, POPPY, 15).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        DAFFODIL.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.ELONGATED, EnumAllele.Sappiness.AVERAGE).setMutation(DANDELION, POPPY, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.GREEN);
        ASTER.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.HIGHER).setMutation(DAISY, TULIP, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.GREEN);
        LILAC.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONGER, EnumAllele.Sappiness.AVERAGE).setPH(EnumAcidity.ALKALINE, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        ROSE.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONGER, EnumAllele.Sappiness.HIGH).setPH(EnumAcidity.ACID, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.GREEN);
        PEONY.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.AVERAGE).setPH(EnumAcidity.ALKALINE, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.DARK_GREEN);
        MARIGOLD.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.SHORTER, EnumAllele.Sappiness.AVERAGE).setMutation(DAISY, DANDELION, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.GREEN);
        HYDRANGEA.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONGER, EnumAllele.Sappiness.HIGH).setMutation(PEONY, BLUET, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.DAMP, EnumTolerance.NONE).setStemColor(EnumFlowerColor.DARK_GREEN);
        FOXGLOVE.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.SHORTENED, EnumAllele.Sappiness.LOW).setMutation(LILAC, ZINNIA, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.DARK_GREEN);
        DAHLIA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.AVERAGE).setMutation(DAISY, ALLIUM, 15).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        CHRYSANTHEMUM.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.HIGH).setMutation(GERANIUM, ROSE, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.MEDIUM_SEA_GREEN);
        CARNATION.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.HIGH).setMutation(DIANTHUS, ROSE, 5).setPH(EnumAcidity.ALKALINE, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.SEA_GREEN);
        ZINNIA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORTER, EnumAllele.Sappiness.AVERAGE).setMutation(DAHLIA, MARIGOLD, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.MEDIUM_SEA_GREEN);
        PRIMROSE.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.AVERAGE).setMutation(CHRYSANTHEMUM, AURICULA, 5).setPH(EnumAcidity.ACID, EnumTolerance.UP_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.GREEN);
        AZALEA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.AVERAGE).setMutation(ORCHID, GERANIUM, 5).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setStemColor(EnumFlowerColor.GREEN);
        GERANIUM.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.LOW).setMutation(TULIP, ORCHID, 15).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.MEDIUM_SEA_GREEN);
        LILY.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.LOW).setMutation(TULIP, CHRYSANTHEMUM, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.GREEN);
        YARROW.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOW).setMutation(DANDELION, ORCHID, 10).setPH(EnumAcidity.ACID, EnumTolerance.UP_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        PETUNIA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORTER, EnumAllele.Sappiness.AVERAGE).setMutation(TULIP, DAHLIA, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setTemperature(EnumTemperature.WARM, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.GREEN);
        AGAPANTHUS.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOW).setMutation(ALLIUM, GERANIUM, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        FUCHSIA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORTENED, EnumAllele.Sappiness.AVERAGE).setMutation(FOXGLOVE, DAHLIA, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.SEA_GREEN);
        DIANTHUS.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORT, EnumAllele.Sappiness.HIGH).setMutation(TULIP, POPPY, 15).setPH(EnumAcidity.ALKALINE, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        FORGET.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORT, EnumAllele.Sappiness.LOWER).setMutation(ORCHID, BLUET, 10).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.GREEN);
        ANEMONE.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOW).setMutation(AQUILEGIA, ROSE, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        AQUILEGIA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.AVERAGE).setMutation(IRIS, POPPY, 5).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.MEDIUM_SEA_GREEN);
        EDELWEISS.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.LOWEST).setMutation(PEONY, BLUET, 5).setPH(EnumAcidity.ALKALINE, EnumTolerance.DOWN_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        SCABIOUS.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.SHORTENED, EnumAllele.Sappiness.LOW).setMutation(ALLIUM, CORNFLOWER, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.UP_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        CONEFLOWER.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.HIGHER).setMutation(TULIP, CORNFLOWER, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        GAILLARDIA.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.HIGHER).setMutation(DANDELION, MARIGOLD, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setMoisture(EnumMoisture.DAMP, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.BOTH_2).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        AURICULA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.ELONGATED, EnumAllele.Sappiness.HIGH).setMutation(POPPY, GERANIUM, 10).setPH(EnumAcidity.ACID, EnumTolerance.UP_1).setMoisture(EnumMoisture.NORMAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        CAMELLIA.setTraits(EnumAllele.Fertility.NORMAL, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.HIGH).setMutation(HYDRANGEA, ROSE, 5).setPH(EnumAcidity.ACID, EnumTolerance.NONE).setMoisture(EnumMoisture.DAMP, EnumTolerance.NONE).setTemperature(EnumTemperature.WARM, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.DARK_OLIVE_GREEN);
        GOLDENROD.setTraits(EnumAllele.Fertility.HIGH, EnumAllele.Lifespan.NORMAL, EnumAllele.Sappiness.HIGHER).setMutation(LILAC, MARIGOLD, 10).setPH(EnumAcidity.NEUTRAL, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.MEDIUM_SEA_GREEN);
        ALTHEA.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.ELONGATED, EnumAllele.Sappiness.HIGH).setMutation(HYDRANGEA, IRIS, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.WARM, EnumTolerance.BOTH_1).setStemColor(EnumFlowerColor.DARK_GREEN);
        PENSTEMON.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.LOW).setMutation(PEONY, LILAC, 5).setMoisture(EnumMoisture.DRY, EnumTolerance.UP_1).setTemperature(EnumTemperature.WARM, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.OLIVE_DRAB);
        DELPHINIUM.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONGER, EnumAllele.Sappiness.LOW).setMutation(LILAC, BLUET, 5).setMoisture(EnumMoisture.DAMP, EnumTolerance.DOWN_1).setTemperature(EnumTemperature.NORMAL, EnumTolerance.DOWN_1).setStemColor(EnumFlowerColor.DARK_SEA_GREEN);
        HOLLYHOCK.setTraits(EnumAllele.Fertility.LOW, EnumAllele.Lifespan.LONG, EnumAllele.Sappiness.HIGH).setMutation(DELPHINIUM, LAVENDER, 5).setPH(EnumAcidity.NEUTRAL, EnumTolerance.UP_1).setStemColor(EnumFlowerColor.GREEN);
        IFlowerRoot flowerRoot = BotanyCore.getFlowerRoot();
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150327_N, 1, 0), DANDELION.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 0), POPPY.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 1), ORCHID.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 2), ALLIUM.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 3), BLUET.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 7), TULIP.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 8), DAISY.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150398_cm, 1, 1), LILAC.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), ROSE.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150398_cm, 1, 5), PEONY.getTemplate());
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 6), TULIP.addVariant(EnumFlowerColor.WHITE));
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 4), TULIP.addVariant(EnumFlowerColor.CRIMSON));
        flowerRoot.addConversion(new ItemStack((Block)Blocks.field_150328_O, 1, 5), TULIP.addVariant(EnumFlowerColor.DARK_ORANGE));
        for (FlowerSpecies species : FlowerSpecies.values()) {
            String scientific = species.branchName.substring(0, 1).toUpperCase() + species.branchName.substring(1).toLowerCase();
            String uid = "flowers." + species.branchName.toLowerCase();
            IClassification branch = AlleleManager.alleleRegistry.getClassification("genus." + uid);
            if (branch == null) {
                branch = AlleleManager.alleleRegistry.createAndRegisterClassification(IClassification.EnumClassLevel.GENUS, uid, scientific);
            }
            species.branch = branch;
            branch.addMemberSpecies((IAlleleSpecies)species);
        }
    }

    private FlowerSpecies setStemColor(EnumFlowerColor green) {
        this.stemColor = green;
        return this;
    }

    private FlowerSpecies setTraits(EnumAllele.Fertility fertility, EnumAllele.Lifespan shortened, EnumAllele.Sappiness lower) {
        this.fert = fertility;
        this.life = shortened;
        this.sap = lower;
        return this;
    }

    private FlowerSpecies setMutation(FlowerSpecies dandelion2, FlowerSpecies tulip2, int chance) {
        BotanyCore.getFlowerRoot().registerMutation(new FlowerMutation(dandelion2, tulip2, this.getTemplate(), chance));
        return this;
    }

    private IAllele[] addVariant(EnumFlowerColor a, EnumFlowerColor b) {
        IAllele[] template = this.getTemplate();
        template[EnumFlowerChromosome.PRIMARY.ordinal()] = a.getAllele();
        template[EnumFlowerChromosome.SECONDARY.ordinal()] = b.getAllele();
        this.variantTemplates.add(template);
        return template;
    }

    private FlowerSpecies setTemperature(EnumTemperature temperature, EnumTolerance tolerance) {
        this.temperature = temperature;
        this.tempTolerance = tolerance;
        return this;
    }

    private FlowerSpecies setPH(EnumAcidity temperature, EnumTolerance tolerance) {
        this.pH = temperature;
        this.pHTolerance = tolerance;
        return this;
    }

    private FlowerSpecies setMoisture(EnumMoisture temperature, EnumTolerance tolerance) {
        this.moisture = temperature;
        this.moistureTolerance = tolerance;
        return this;
    }

    private IAllele[] addVariant(EnumFlowerColor a) {
        return this.addVariant(a, a);
    }

    public List<IAllele[]> getVariants() {
        return this.variantTemplates;
    }

    public String getName() {
        return I18N.localise("botany.flower." + this.name);
    }

    public String getDescription() {
        return "";
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.values()[this.getMoisture().ordinal()];
    }

    @Override
    public EnumAcidity getPH() {
        return this.pH;
    }

    @Override
    public EnumMoisture getMoisture() {
        return this.moisture;
    }

    public boolean hasEffect() {
        return false;
    }

    public boolean isSecret() {
        return false;
    }

    public boolean isCounted() {
        return true;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public void setBranch(IClassification branch) {
        this.branch = branch;
    }

    public String getUID() {
        return "botany.flowers.species." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return false;
    }

    public IAllele[] getTemplate() {
        forestry.core.genetics.alleles.AlleleHelper alleleHelper = forestry.core.genetics.alleles.AlleleHelper.instance;
        IAllele[] template = FlowerTemplates.getDefaultTemplate();
        template[0] = this;
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.PRIMARY, AlleleHelper.getAllele(this.primaryColor));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.SECONDARY, AlleleHelper.getAllele(this.secondaryColor));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.TEMPERATURE_TOLERANCE, AlleleHelper.getAllele(this.tempTolerance));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.PH_TOLERANCE, AlleleHelper.getAllele(this.pHTolerance));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.HUMIDITY_TOLERANCE, AlleleHelper.getAllele(this.moistureTolerance));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.FERTILITY, AlleleHelper.getAllele(this.fert));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.LIFESPAN, AlleleHelper.getAllele(this.life));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.SAPPINESS, AlleleHelper.getAllele(this.sap));
        alleleHelper.set(template, (Enum)EnumFlowerChromosome.STEM, AlleleHelper.getAllele(this.stemColor));
        return template;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return null;
    }

    public ISpeciesRoot getRoot() {
        return BotanyCore.getFlowerRoot();
    }

    public int getIconColour(int renderPass) {
        return 0;
    }

    public int getComplexity() {
        return 0;
    }

    public float getResearchSuitability(ItemStack itemstack) {
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        return null;
    }

    @Override
    public IFlowerType getType() {
        return this.type;
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }
}

