/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.listbox.ControlList;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.core.craftgui.database.ControlMutationItem;
import binnie.core.craftgui.database.WindowAbstractDatabase;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.genetics.BreedingSystem;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import java.util.List;

class ControlMutationBox
extends ControlListBox<IMutation> {
    private Type type;
    private IAlleleSpecies species = null;

    @Override
    public IWidget createOption(IMutation value, int y) {
        return new ControlMutationItem((ControlList)this.getContent(), value, this.species, y);
    }

    public ControlMutationBox(IWidget parent, int x, int y, int width, int height, Type type) {
        super(parent, x, y, width, height, 12.0f);
        this.type = type;
    }

    public void setSpecies(IAlleleSpecies species) {
        if (species == this.species) {
            return;
        }
        this.species = species;
        this.movePercentage(-100.0f);
        BreedingSystem system = ((WindowAbstractDatabase)this.getSuperParent()).getBreedingSystem();
        List<IMutation> discovered = system.getDiscoveredMutations(((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
        if (species == null) {
            return;
        }
        if (this.type == Type.RESULTANT) {
            this.setOptions(system.getResultantMutations(species));
            return;
        }
        List<IMutation> mutations = system.getFurtherMutations(species);
        int i = 0;
        while (i < mutations.size()) {
            IMutation mutation = mutations.get(i);
            if (!discovered.contains(mutations) && !((IAlleleSpecies)mutation.getTemplate()[0]).isCounted()) {
                mutations.remove(i);
                continue;
            }
            ++i;
        }
        this.setOptions(mutations);
    }

    static enum Type {
        RESULTANT,
        FURTHER;

    }
}

