/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.BinnieCore;
import binnie.core.block.BlockMetadata;
import binnie.core.block.IMultipassBlock;
import binnie.core.block.MultipassBlockRenderer;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.IToolHammer;
import binnie.extratrees.carpentry.DesignBlock;
import binnie.extratrees.carpentry.DesignerManager;
import binnie.extratrees.carpentry.ModuleCarpentry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public abstract class BlockDesign
extends BlockMetadata
implements IMultipassBlock {
    public static ForgeDirection[] RENDER_DIRECTIONS = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};
    protected IDesignSystem designSystem;

    public BlockDesign(IDesignSystem system, Material material) {
        super(material);
        this.designSystem = system;
    }

    public static int getMetadata(int plank1, int plank2, int design) {
        return plank1 + (plank2 << 9) + (design << 18);
    }

    @SubscribeEvent
    public void onClick(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        World world = event.entityPlayer.field_70170_p;
        EntityPlayer player = event.entityPlayer;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (!(world.func_147439_a(x, y, z) instanceof BlockDesign)) {
            return;
        }
        BlockDesign blockC = (BlockDesign)world.func_147439_a(x, y, z);
        ItemStack item = player.func_70694_bm();
        if (item == null || !(item.func_77973_b() instanceof IToolHammer) || !((IToolHammer)item.func_77973_b()).isActive(item)) {
            return;
        }
        DesignBlock block = blockC.getCarpentryBlock((IBlockAccess)world, x, y, z);
        TileEntityMetadata tile = (TileEntityMetadata)world.func_147438_o(x, y, z);
        block.rotate(event.face, item, player, world, x, y, z);
        int meta = block.getBlockMetadata(blockC.getDesignSystem());
        tile.setTileMetadata(meta, true);
    }

    public abstract ItemStack getCreativeStack(IDesign var1);

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (IDesign design : CarpentryManager.carpentryInterface.getSortedDesigns()) {
            list.add(this.getCreativeStack(design));
        }
    }

    public IDesignSystem getDesignSystem() {
        return this.designSystem;
    }

    public int func_149645_b() {
        return BinnieCore.multipassRenderID;
    }

    @Override
    public String getBlockName(ItemStack stack) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), TileEntityMetadata.getItemDamage(stack));
        return this.getBlockName(block);
    }

    public abstract String getBlockName(DesignBlock var1);

    public DesignBlock getCarpentryBlock(IBlockAccess world, int x, int y, int z) {
        return ModuleCarpentry.getDesignBlock(this.getDesignSystem(), TileEntityMetadata.getTileMetadata(world, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        DesignBlock block = this.getCarpentryBlock(world, x, y, z);
        return MultipassBlockRenderer.getLayer() > 0 ? block.getSecondaryColour() : block.getPrimaryColour();
    }

    @Override
    public int colorMultiplier(int meta) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), meta);
        return MultipassBlockRenderer.getLayer() > 0 ? block.getSecondaryColour() : block.getPrimaryColour();
    }

    public IIcon func_149691_a(int side, int damage) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), damage);
        if (MultipassBlockRenderer.getLayer() > 0) {
            return block.getSecondaryIcon(this.getDesignSystem(), RENDER_DIRECTIONS[side]);
        }
        return block.getPrimaryIcon(this.getDesignSystem(), RENDER_DIRECTIONS[side]);
    }

    @Override
    public void addBlockTooltip(ItemStack stack, List tooltip) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), TileEntityMetadata.getItemDamage(stack));
        if (block.getPrimaryMaterial() != block.getSecondaryMaterial()) {
            tooltip.add(I18N.localise("extratrees.block.tooltip.twoMaterials", block.getPrimaryMaterial().getName(), block.getSecondaryMaterial().getName()));
        } else {
            tooltip.add(block.getPrimaryMaterial().getName());
        }
    }

    public ItemStack getItemStack(int plank1, int plank2, int design) {
        return TileEntityMetadata.getItemStack((Block)this, BlockDesign.getMetadata(plank1, plank2, design));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (IDesignSystem system : DesignerManager.instance.getDesignSystems()) {
            system.registerIcons(register);
        }
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), tileMeta);
        return block.getItemMetadata(this.getDesignSystem());
    }

    @Override
    public int getNumberOfPasses() {
        return 2;
    }
}

