/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.network.INetwork;
import binnie.extrabees.ExtraBees;
import binnie.extratrees.ExtraTrees;
import binnie.genetics.Genetics;
import buildcraft.api.tools.IToolWrench;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ComponentGUIHolder
extends MachineComponent
implements INetwork.TilePacketSync,
IInteraction.RightClick {
    private ItemStack stack;

    public ComponentGUIHolder(IMachine machine) {
        super(machine);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound == null) {
            return;
        }
        this.stack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("Item"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.stack != null) {
            this.stack.func_77955_b(nbt);
        }
        nbttagcompound.func_74782_a("Item", (NBTBase)nbt);
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void onDestruction() {
        super.onDestruction();
        if (this.stack == null) {
            return;
        }
        IMachine machine = this.getMachine();
        TileEntity tile = machine.getTileEntity();
        World world = machine.getWorld();
        Random rand = world.field_73012_v;
        float xOffset = rand.nextFloat() * 0.8f + 0.1f;
        float yOffset = rand.nextFloat() * 0.8f + 0.1f;
        float zOffset = rand.nextFloat() * 0.8f + 0.1f;
        if (this.stack.field_77994_a == 0) {
            this.stack.field_77994_a = 1;
        }
        EntityItem entityitem = new EntityItem(world, (double)((float)tile.field_145851_c + xOffset), (double)((float)tile.field_145848_d + yOffset), (double)((float)tile.field_145849_e + zOffset), this.stack.func_77946_l());
        float accel = 0.05f;
        entityitem.field_70159_w = (float)rand.nextGaussian() * accel;
        entityitem.field_70181_x = (float)rand.nextGaussian() * accel + 0.2f;
        entityitem.field_70179_y = (float)rand.nextGaussian() * accel;
        world.func_72838_d((Entity)entityitem);
    }

    @Override
    public void onRightClick(World world, EntityPlayer player, int x, int y, int z) {
        if (BinnieCore.proxy.isSimulating(world) && player.func_70694_bm() != null) {
            if (this.stack != null && player.func_70694_bm().func_77973_b() instanceof IToolWrench) {
                Random rand = world.field_73012_v;
                float f = 0.7f;
                double fOffset = (double)(1.0f - f) * 0.5;
                double xOffset = (double)(rand.nextFloat() * f) + fOffset;
                double yOffset = (double)(rand.nextFloat() * f) + fOffset;
                double zOffset = (double)(rand.nextFloat() * f) + fOffset;
                EntityItem entityitem = new EntityItem(world, (double)x + xOffset, (double)y + yOffset, (double)z + zOffset, this.stack);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
                this.stack = null;
                ((IToolWrench)player.func_70694_bm().func_77973_b()).wrenchUsed(player, x, y, z);
                this.getUtil().refreshBlock();
                return;
            }
            ArrayList<Item> validSelections = new ArrayList<Item>();
            if (BinnieCore.isBotanyActive()) {
                validSelections.add(Botany.database);
            }
            if (BinnieCore.isExtraBeesActive()) {
                validSelections.add(ExtraBees.dictionary);
            }
            if (BinnieCore.isExtraTreesActive()) {
                validSelections.add(ExtraTrees.itemDictionary);
            }
            if (BinnieCore.isLepidopteryActive()) {
                validSelections.add(ExtraTrees.itemDictionaryLepi);
            }
            validSelections.add(Genetics.database);
            validSelections.add(Genetics.analyst);
            validSelections.add(Genetics.registry);
            validSelections.add(Genetics.masterRegistry);
            validSelections.add(BinnieCore.genesis);
            if (this.stack == null && validSelections.contains(player.func_70694_bm().func_77973_b())) {
                this.stack = player.func_70694_bm().func_77946_l();
                ItemStack heldItem = player.func_70694_bm();
                --heldItem.field_77994_a;
                world.func_147471_g(x, y, z);
                return;
            }
            if (this.stack != null && player.func_70694_bm().func_77973_b() instanceof IToolWrench) {
                this.stack.func_77973_b().func_77659_a(this.stack, world, player);
            }
        }
        if (this.stack != null) {
            this.stack.func_77973_b().func_77659_a(this.stack, world, player);
        }
    }
}

