/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.endercollector;

import com.rwtema.extrautils.EventHandlerEntityItemStealer;
import com.rwtema.extrautils.tileentity.endercollector.TileEnderCollector;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class CollectorHandler {
    public static final WeakHashMap<World, WeakHashMap<TileEnderCollector, Object>> map = new WeakHashMap();
    public static CollectorHandler INSTANCE = new CollectorHandler();
    public static boolean dontCollect;
    private static final ArrayList<TileEnderCollector> collectors;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (dontCollect) {
            return;
        }
        if (map.isEmpty()) {
            return;
        }
        WeakHashMap<TileEnderCollector, Object> map = CollectorHandler.map.get(event.entity.field_70170_p);
        if (map == null || map.isEmpty()) {
            return;
        }
        Entity entity = event.entity;
        if (!EventHandlerEntityItemStealer.isEntityItem(entity.getClass())) {
            return;
        }
        ItemStack stack = entity.func_70096_w().func_82710_f(10);
        if (stack == null) {
            return;
        }
        collectors.clear();
        for (TileEnderCollector tileEnderCollector : map.keySet()) {
            if (!tileEnderCollector.inRange(entity)) continue;
            collectors.add(tileEnderCollector);
        }
        if (collectors.isEmpty()) {
            return;
        }
        if (collectors.size() == 1) {
            collectors.get(0).grabEntity((EntityItem)entity);
        } else {
            Collections.shuffle(collectors);
            EntityItem entityItem = (EntityItem)entity;
            for (TileEnderCollector collector : collectors) {
                collector.grabEntity(entityItem);
                if (!entity.field_70128_L) continue;
                break;
            }
        }
        collectors.clear();
        if (entity.field_70128_L) {
            event.setCanceled(true);
        }
    }

    public static void register(TileEnderCollector tile) {
        World worldObj = tile.func_145831_w();
        if (worldObj == null || worldObj.field_72995_K) {
            return;
        }
        CollectorHandler.getWorldMap(tile).put(tile, null);
    }

    public static void unregister(TileEnderCollector tile) {
        World worldObj = tile.func_145831_w();
        if (worldObj == null || worldObj.field_72995_K) {
            return;
        }
        CollectorHandler.getWorldMap(tile).remove((Object)tile);
    }

    public static WeakHashMap<TileEnderCollector, Object> getWorldMap(TileEnderCollector tile) {
        WeakHashMap<TileEnderCollector, Object> worldMap = map.get(tile.func_145831_w());
        if (worldMap == null) {
            worldMap = new WeakHashMap();
            map.put(tile.func_145831_w(), worldMap);
        }
        return worldMap;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        collectors = new ArrayList(1);
    }
}

