/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.MathHelper;

public class GT_ClientPollutionMap {
    private static final byte RADIUS = 24;
    private static final byte DISTANCE_RELOAD_MAP = 5;
    private static final byte SIZE = 49;
    private int x0;
    private int z0;
    private int dim;
    private boolean initialized = false;
    private static short[][] chunkMatrix;

    public void reset() {
        this.initialized = false;
    }

    private void initialize(int playerChunkX, int playerChunkZ, int dimension) {
        this.initialized = true;
        chunkMatrix = new short[49][49];
        this.x0 = playerChunkX;
        this.z0 = playerChunkZ;
        this.dim = dimension;
    }

    public void addChunkPollution(int chunkX, int chunkZ, int pollution) {
        int relX;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player.field_70170_p == null) {
            return;
        }
        int playerXChunk = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
        int playerZChunk = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
        if (!this.initialized) {
            this.initialize(playerXChunk, playerZChunk, player.field_71093_bK);
        }
        if (this.dim != player.field_71093_bK) {
            this.initialize(playerXChunk, playerZChunk, player.field_71093_bK);
        }
        if (Math.abs(this.x0 - playerXChunk) > 5 || Math.abs(this.z0 - playerZChunk) > 5) {
            this.shiftCenter(playerXChunk, playerZChunk);
        }
        if ((relX = chunkX - this.x0 + 24) >= 49 || relX < 0) {
            return;
        }
        int relZ = chunkZ - this.z0 + 24;
        if (relZ >= 49 || relZ < 0) {
            return;
        }
        GT_ClientPollutionMap.chunkMatrix[relX][relZ] = (pollution /= 225) > Short.MAX_VALUE ? Short.MAX_VALUE : (pollution < 0 ? 0 : (int)pollution);
    }

    public int getPollution(double fx, double fz) {
        if (!this.initialized) {
            return 0;
        }
        int x = MathHelper.func_76128_c((double)fx);
        int z = MathHelper.func_76128_c((double)fz);
        int xDiff = (x - 8 >> 4) - this.x0;
        int zDiff = (z - 8 >> 4) - this.z0;
        if (xDiff < -24 || zDiff < -24 || xDiff >= 24 || zDiff >= 24) {
            return 0;
        }
        x = (x - 8) % 16;
        z = (z - 8) % 16;
        if (x < 0) {
            x = 16 + x;
        }
        if (z < 0) {
            z = 16 + z;
        }
        int xi = 15 - x;
        int zi = 15 - z;
        int offsetX = 24 + xDiff;
        int offsetZ = 24 + zDiff;
        short c00 = chunkMatrix[offsetX][offsetZ];
        short c10 = chunkMatrix[offsetX + 1][offsetZ];
        short c01 = chunkMatrix[offsetX][offsetZ + 1];
        short c11 = chunkMatrix[offsetX + 1][offsetZ + 1];
        return c00 * xi * zi + c10 * x * zi + c01 * xi * z + c11 * x * z;
    }

    private void shiftCenter(int chunkX, int chunkZ) {
        int z;
        int xOff;
        int x;
        int xDiff = chunkX - this.x0;
        int zDiff = chunkZ - this.z0;
        boolean[] allEmpty = new boolean[49];
        if (xDiff > 0) {
            for (x = 0; x < 49; x = (int)((byte)(x + 1))) {
                xOff = x + xDiff;
                if (xOff < 49) {
                    GT_ClientPollutionMap.chunkMatrix[x] = (short[])chunkMatrix[xOff].clone();
                    continue;
                }
                GT_ClientPollutionMap.chunkMatrix[x] = new short[49];
                allEmpty[x] = true;
            }
        } else if (xDiff < 0) {
            for (x = 48; x >= 0; x = (int)((byte)(x - 1))) {
                xOff = x + xDiff;
                if (xOff > 0) {
                    GT_ClientPollutionMap.chunkMatrix[x] = (short[])chunkMatrix[xOff].clone();
                    continue;
                }
                GT_ClientPollutionMap.chunkMatrix[x] = new short[49];
                allEmpty[x] = true;
            }
        }
        if (zDiff > 0) {
            for (x = 0; x < 49; x = (int)((byte)(x + 1))) {
                if (allEmpty[x]) continue;
                for (z = 0; z < 49; ++z) {
                    int zOff = z + zDiff;
                    GT_ClientPollutionMap.chunkMatrix[x][z] = zOff < 49 ? chunkMatrix[x][zOff] : (short)0;
                }
            }
        } else if (zDiff < 0) {
            for (x = 0; x < 49; x = (int)((byte)(x + 1))) {
                if (allEmpty[x]) continue;
                for (z = 48; z >= 0; --z) {
                    int zOff = z + zDiff;
                    GT_ClientPollutionMap.chunkMatrix[x][z] = zOff > 0 ? chunkMatrix[x][zOff] : (short)0;
                }
            }
        }
        this.x0 = chunkX;
        this.z0 = chunkZ;
    }
}

