/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Block_Casings8;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_PCBFactory
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<GT_MetaTileEntity_PCBFactory>
implements ISurvivalConstructable {
    private static final String tier1 = "tier1";
    private static final String tier2 = "tier2";
    private static final String tier3 = "tier3";
    private static final String bioUpgrade = "bioUpgrade";
    private static final String ocTier1Upgrade = "ocTier1Upgrade";
    private static final String ocTier2Upgrade = "ocTier2Upgrade";
    private float mRoughnessMultiplier = 1.0f;
    private int mTier = 1;
    private int mSetTier = 1;
    private int mUpgradesInstalled = 0;
    private int mCurrentParallel = 0;
    private int mMaxParallel = 0;
    private boolean mBioUpgrade = false;
    private boolean mBioRotate = false;
    private boolean mOCTier1 = false;
    private boolean mOCTier2 = false;
    private final int[] mBioOffsets = new int[]{-5, -1};
    private final int[] mOCTier1Offsets = new int[]{2, -11};
    private final int[] mOCTier2Offsets = new int[]{2, -11};
    private GT_MetaTileEntity_Hatch_Input mCoolantInputHatch;
    private static final int mBioRotateBitMap = 64;
    private static final int mOCTier2BitMap = 32;
    private static final int mOCTier1BitMap = 16;
    private static final int mBioBitMap = 8;
    private static final int mTier3BitMap = 4;
    private static final int mTier2BitMap = 2;
    private static final int mTier1BitMap = 1;
    private static final int COOLANT_CONSUMED_PER_SEC = 10;
    private static final IStructureDefinition<GT_MetaTileEntity_PCBFactory> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("tier1", StructureUtility.transpose((String[][])new String[][]{{"       ", "E     E", "E     E", "EEEEEEE", "E     E", "E     E", "       "}, {"EEEEEEE", "CAAAAAC", "CAAAAAC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "E     E"}, {"EAAAAAE", "C-----C", "C-----C", "C-----C", "C-----C", "C-----C", "ECCCCCE"}, {"EAAAAAE", "C-----C", "B-----B", "B-----B", "B-----B", "C-----C", "ECCCCCE"}, {"EAAAAAE", "C-----C", "B-FFF-B", "B-FFF-B", "B-FFF-B", "C-----C", "EPPPPPE"}, {"ECC~CCE", "CDDDDDC", "CDDDDDC", "CDDDDDC", "CDDDDDC", "CDDDDDC", "EPPPPPE"}})).addShape("tier2", StructureUtility.transpose((String[][])new String[][]{{"    ", "    ", "    ", "HGGH", "HGGH", "HGGH", "HGGH", "HGGH", "    ", "    ", "    "}, {"    ", "    ", "HGGH", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "HGGH", "    ", "    "}, {"    ", "HGGH", "GGGG", "G  G", "G  G", "G  G", "G  G", "G  G", "GGGG", "HGGH", "    "}, {"    ", "HGGH", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "HGGH", "    "}, {"HGGH", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "HGGH"}, {"HGGH", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "G  G", "HGGH"}, {"HGGH", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "GGGG", "HGGH"}})).addShape("tier3", StructureUtility.transpose((String[][])new String[][]{{"       ", "       ", "       ", "       ", "   I   ", "   I   ", "       ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   I   ", "   I   ", "   I   ", "   I   ", "       ", "       ", "       "}, {"       ", "       ", "  KKK  ", "  KIK  ", "  K K  ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", "  K K  ", "   I   ", "       ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", "  K K  ", "  KIK  ", "       ", "       ", "       "}, {"       ", "  I I  ", " I K I ", " I   I ", " I   I ", "  K K  ", "  KIK  ", "       ", "       ", "       "}, {"       ", "  I I  ", " I K I ", " I   I ", " I   I ", "  K K  ", "  K K  ", "  KKK  ", "       ", "       "}, {"       ", "  I I  ", " I K I ", " I   I ", " I   I ", "  K K  ", "  K K  ", "  KKK  ", "       ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", "  K K  ", "  K K  ", "  K K  ", "  K K  ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "       ", "  KKK  ", "  K K  ", "  K K  ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {"       ", "  III  ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", " I   I ", "  III  ", "       "}, {" II~II ", "IIJJJII", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IJJJJJI", "IIJJJII", " IIIII "}})).addShape("bioUpgrade", StructureUtility.transpose((String[][])new String[][]{{"            ", "            ", "   LLLLLL   ", "            ", "            "}, {"            ", "            ", "  L      L  ", "            ", "            "}, {"E   E  E   E", " LLL    LLL ", " LLL    LLL ", " LLL    LLL ", "E   E  E   E"}, {"EAAAE  EAAAE", "A   A  A   A", "A   A  A   A", "A   A  A   A", "EAAAE  EAAAE"}, {"EAAAE  EAAAE", "A   A  A   A", "A   A  A   A", "A   A  A   A", "EAAAE  EAAAE"}, {"EAAAE  EAAAE", "A   A  A   A", "A   A  A   A", "A   A  A   A", "EAAAE  EAAAE"}, {"ELLLE  ELLLE", "LLLLL  LLLLL", "LLLLL  LLLLL", "LLLLL  LLLLL", "ELLLE  ELLLE"}})).addShape("ocTier1Upgrade", StructureUtility.transpose((String[][])new String[][]{{"EKKKE", "K   K", "K   K", "K   K", "EKKKE"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"E   E", " NNN ", " N N ", " NNN ", "E   E"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"EOOOE", "OKKKO", "OK KO", "OKKKO", "EOOOE"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"E   E", " KKK ", " K K ", " KKK ", "E   E"}, {"ENNNE", "NKKKN", "NK KN", "NKKKN", "ENNNE"}, {"EGGGE", "GGGGG", "GGMGG", "GGGGG", "EGGGE"}})).addShape("ocTier2Upgrade", StructureUtility.transpose((String[][])new String[][]{{"RGGGR", "G   G", "G   G", "G   G", "RGGGR"}, {"R   R", " GGG ", " GTG ", " GGG ", "R   R"}, {"R   R", " NNN ", " NTN ", " NNN ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"R   R", " QQQ ", " QTQ ", " QQQ ", "R   R"}, {"RNNNR", "NQQQN", "NQTQN", "NQQQN", "RNNNR"}, {"RGGGR", "GGGGG", "GGSGG", "GGGGG", "RGGGR"}})).addElement('E', GT_StructureUtility.ofFrame(Materials.DamascusSteel)).addElement('C', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)11)).addElement('D', StructureUtility.ofBlock((Block)GregTech_API.sBlockReinforced, (int)2)).addElement('A', Glasses.chainAllGlasses()).addElement('B', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings3, (int)10)).addElement('F', GT_StructureUtility.ofFrame(Materials.VibrantAlloy)).addElement('P', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_PCBFactory.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.InputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or(GT_HatchElement.ExoticEnergy)).dot(1).casingIndex(((GT_Block_Casings8)GregTech_API.sBlockCasings8).getTextureIndex(11)).buildAndChain(GregTech_API.sBlockCasings8, 11)).addElement('H', GT_StructureUtility.ofFrame(Materials.Duranium)).addElement('G', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)12)).addElement('I', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)13)).addElement('K', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)10)).addElement('J', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_PCBFactory.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.InputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or(GT_HatchElement.ExoticEnergy)).dot(1).casingIndex(((GT_Block_Casings8)GregTech_API.sBlockCasings8).getTextureIndex(13)).buildAndChain(GregTech_API.sBlockCasings8, 13)).addElement('L', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)).addElement('M', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_PCBFactory.class).hatchClass(GT_MetaTileEntity_Hatch_Input.class).adder(GT_MetaTileEntity_PCBFactory::addCoolantInputToMachineList).casingIndex(GT_Utility.getCasingTextureIndex(GregTech_API.sBlockCasings8, 12)).dot(2).buildAndChain(GregTech_API.sBlockCasings8, 12)).addElement('N', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)15)).addElement('O', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)4)).addElement('S', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_PCBFactory.class).hatchClass(GT_MetaTileEntity_Hatch_Input.class).adder(GT_MetaTileEntity_PCBFactory::addCoolantInputToMachineList).casingIndex(GT_Utility.getCasingTextureIndex(GregTech_API.sBlockCasings8, 12)).dot(2).buildAndChain(GregTech_API.sBlockCasings8, 12)).addElement('R', GT_StructureUtility.ofFrame(Materials.Americium)).addElement('Q', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)14)).addElement('T', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)15)).build();
    private int ticker = 0;

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        if (this.mSetTier < 3) {
            this.buildPiece(tier1, stackSize, hintsOnly, 3, 5, 0);
            if (this.mSetTier == 2) {
                this.buildPiece(tier2, stackSize, hintsOnly, 7, 6, 2);
            }
        } else {
            this.buildPiece(tier3, stackSize, hintsOnly, 3, 21, 0);
        }
        if (this.mBioUpgrade) {
            if (this.mBioRotate) {
                IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
                this.getStructureDefinition().buildOrHints((Object)this, stackSize, bioUpgrade, tTile.getWorld(), this.transformFacing(this.getExtendedFacing()), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.mBioOffsets[1], 6, this.mBioOffsets[0], hintsOnly);
            } else {
                this.buildPiece(bioUpgrade, stackSize, hintsOnly, this.mBioOffsets[0], 6, this.mBioOffsets[1]);
            }
        }
        if (this.mOCTier1 && !this.mOCTier2) {
            this.buildPiece(ocTier1Upgrade, stackSize, hintsOnly, this.mOCTier1Offsets[0], 9, this.mOCTier1Offsets[1]);
        }
        if (!this.mOCTier1 && this.mOCTier2) {
            this.buildPiece(ocTier2Upgrade, stackSize, hintsOnly, this.mOCTier2Offsets[0], 9, this.mOCTier2Offsets[1]);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = 0;
        if (this.mSetTier < 3) {
            built += this.survivialBuildPiece(tier1, stackSize, 3, 5, 0, elementBudget, env, false, true);
            if (this.mSetTier == 2) {
                built += this.survivialBuildPiece(tier2, stackSize, 7, 6, 2, elementBudget, env, false, true);
            }
        } else {
            built += this.survivialBuildPiece(tier3, stackSize, 3, 21, 0, elementBudget, env, false, true);
        }
        if (this.mBioUpgrade) {
            if (this.mBioRotate) {
                IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
                this.getStructureDefinition().survivalBuild((Object)this, stackSize, bioUpgrade, tTile.getWorld(), this.transformFacing(this.getExtendedFacing()), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.mBioOffsets[1], 6, this.mBioOffsets[0], elementBudget, env, false);
            } else {
                built += this.survivialBuildPiece(bioUpgrade, stackSize, this.mBioOffsets[0], 6, this.mBioOffsets[1], elementBudget, env, false, true);
            }
        }
        if (this.mOCTier1 && !this.mOCTier2) {
            built += this.survivialBuildPiece(ocTier1Upgrade, stackSize, this.mOCTier1Offsets[0], 9, this.mOCTier1Offsets[1], elementBudget, env, false, true);
        }
        if (!this.mOCTier1 && this.mOCTier2) {
            built += this.survivialBuildPiece(ocTier2Upgrade, stackSize, this.mOCTier2Offsets[0], 9, this.mOCTier2Offsets[1], elementBudget, env, false, true);
        }
        return built;
    }

    public GT_MetaTileEntity_PCBFactory(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_PCBFactory(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PCBFactory(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getTier() < 3 ? GT_Utility.getCasingTextureIndex(GregTech_API.sBlockCasings8, 11) : GT_Utility.getCasingTextureIndex(GregTech_API.sBlockCasings8, 13)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getTier() < 3 ? GT_Utility.getCasingTextureIndex(GregTech_API.sBlockCasings8, 11) : GT_Utility.getCasingTextureIndex(GregTech_API.sBlockCasings8, 13)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.mSetTier < 3 ? ((GT_Block_Casings8)GregTech_API.sBlockCasings8).getTextureIndex(11) : ((GT_Block_Casings8)GregTech_API.sBlockCasings8).getTextureIndex(13))};
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_PCBFactory> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mTier = 0;
        this.mUpgradesInstalled = 0;
        this.mCoolantInputHatch = null;
        if (this.mSetTier < 3) {
            if (!this.checkPiece(tier1, 3, 5, 0)) {
                return false;
            }
            if (this.mSetTier == 2) {
                if (!this.checkPiece(tier2, 7, 6, 2)) {
                    return false;
                }
                this.mTier = 2;
            } else {
                this.mTier = 1;
            }
        } else {
            if (!this.checkPiece(tier3, 3, 21, 0)) {
                return false;
            }
            this.mTier = 3;
        }
        if (this.mBioUpgrade) {
            if (this.mBioRotate) {
                IGregTechTileEntity tTile = this.getBaseMetaTileEntity();
                if (!this.getStructureDefinition().check((Object)this, bioUpgrade, tTile.getWorld(), this.transformFacing(this.getExtendedFacing()), tTile.getXCoord(), (int)tTile.getYCoord(), tTile.getZCoord(), this.mBioOffsets[1], 6, this.mBioOffsets[0], !this.mMachine)) {
                    return false;
                }
            } else if (!this.checkPiece(bioUpgrade, this.mBioOffsets[0], 6, this.mBioOffsets[1])) {
                return false;
            }
            ++this.mUpgradesInstalled;
        }
        if (this.mOCTier1 && !this.mOCTier2) {
            if (!this.checkPiece(ocTier1Upgrade, this.mOCTier1Offsets[0], 9, this.mOCTier1Offsets[1])) {
                return false;
            }
            if (this.mCoolantInputHatch == null) {
                return false;
            }
            ++this.mUpgradesInstalled;
        }
        if (this.mOCTier2 && !this.mOCTier1) {
            if (!this.checkPiece(ocTier2Upgrade, this.mOCTier2Offsets[0], 9, this.mOCTier2Offsets[1])) {
                return false;
            }
            if (this.mCoolantInputHatch == null) {
                return false;
            }
            ++this.mUpgradesInstalled;
        }
        this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
        if (this.mMaintenanceHatches.size() != 1 || this.mOutputBusses.isEmpty() || this.mInputBusses.isEmpty() || this.mInputHatches.isEmpty()) {
            return false;
        }
        if (!this.checkExoticAndNormalEnergyHatches()) {
            return false;
        }
        return this.mTier > 0;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sPCBFactory;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                int numberOfNanites = 0;
                ItemStack aNanite = recipe.getRepresentativeInput(1);
                ItemData naniteData = GT_OreDictUnificator.getAssociation(aNanite);
                if (naniteData != null && naniteData.mPrefix != null && naniteData.mPrefix.equals((Object)OrePrefixes.nanite)) {
                    for (ItemStack aItem : this.inputItems) {
                        if (aItem == null || !aItem.func_77969_a(aNanite)) continue;
                        numberOfNanites += aItem.field_77994_a;
                    }
                }
                this.maxParallel = (int)Math.max(Math.ceil(Math.log(numberOfNanites) / Math.log(2.0) + 1.0E-5), 1.0);
                GT_MetaTileEntity_PCBFactory.this.mMaxParallel = this.maxParallel;
                int recipeBitMap = recipe.mSpecialValue;
                if ((recipeBitMap & 8) == 8 && !GT_MetaTileEntity_PCBFactory.this.mBioUpgrade) {
                    return SimpleCheckRecipeResult.ofFailure("bio_upgrade_missing");
                }
                int requiredPCBTier = 0;
                if ((recipeBitMap & 4) == 4) {
                    requiredPCBTier = 3;
                }
                if ((recipeBitMap & 2) == 2) {
                    requiredPCBTier = 2;
                }
                if ((recipeBitMap & 1) == 1) {
                    requiredPCBTier = 1;
                }
                if (requiredPCBTier > GT_MetaTileEntity_PCBFactory.this.mTier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(requiredPCBTier);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                if (GT_MetaTileEntity_PCBFactory.this.isNoOC()) {
                    return GT_OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount((float)Math.sqrt(GT_MetaTileEntity_PCBFactory.this.mUpgradesInstalled == 0 ? 1.0 : (double)GT_MetaTileEntity_PCBFactory.this.mUpgradesInstalled)).setSpeedBoost(GT_MetaTileEntity_PCBFactory.this.getDurationMultiplierFromRoughness());
                }
                GT_OverclockCalculator calculator = super.createOverclockCalculator(recipe).setEUtDiscount((float)Math.sqrt(GT_MetaTileEntity_PCBFactory.this.mUpgradesInstalled == 0 ? 1.0 : (double)GT_MetaTileEntity_PCBFactory.this.mUpgradesInstalled)).setSpeedBoost(GT_MetaTileEntity_PCBFactory.this.getDurationMultiplierFromRoughness()).setDurationDecreasePerOC(GT_MetaTileEntity_PCBFactory.this.mOCTier2 ? 2 : 1);
                return calculator;
            }

            @Override
            @Nonnull
            protected GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
                return super.createParallelHelper(recipe).setEUtModifier((float)Math.sqrt(GT_MetaTileEntity_PCBFactory.this.mUpgradesInstalled == 0 ? 1.0 : (double)GT_MetaTileEntity_PCBFactory.this.mUpgradesInstalled)).setCustomItemOutputCalculation(currentParallel -> {
                    ArrayList<ItemStack> chancedOutputs = new ArrayList<ItemStack>();
                    for (int i = 0; i < currentParallel; ++i) {
                        for (ItemStack item : recipe.mOutputs) {
                            int remainingEfficiency = GT_MetaTileEntity_PCBFactory.this.getMaxEfficiency(GT_MetaTileEntity_PCBFactory.this.getControllerSlot());
                            while (remainingEfficiency > 0) {
                                if (GT_MetaTileEntity_PCBFactory.this.getBaseMetaTileEntity().getRandomNumber(10000) >= remainingEfficiency) {
                                    remainingEfficiency -= 10000;
                                    continue;
                                }
                                chancedOutputs.add(item);
                                remainingEfficiency -= 10000;
                            }
                        }
                    }
                    return chancedOutputs.toArray(new ItemStack[0]);
                });
            }
        };
    }

    private boolean isNoOC() {
        return !this.mOCTier1 && !this.mOCTier2;
    }

    private float getDurationMultiplierFromRoughness() {
        return (float)Math.pow(this.mRoughnessMultiplier, 2.0);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (!super.onRunningTick(aStack)) {
            this.criticalStopMachine();
            return false;
        }
        if (this.ticker % 20 == 0) {
            if (this.mOCTier1) {
                if (this.mCoolantInputHatch == null) {
                    this.criticalStopMachine();
                    return false;
                }
                FluidStack tFluid = GT_ModHandler.getDistilledWater(10L);
                FluidStack tLiquid = this.mCoolantInputHatch.drain(tFluid.amount, true);
                if (tLiquid == null || tLiquid.amount < tFluid.amount || !tLiquid.equals((Object)tFluid)) {
                    this.criticalStopMachine();
                    return false;
                }
            }
            if (this.mOCTier2) {
                if (this.mCoolantInputHatch == null) {
                    this.criticalStopMachine();
                    return false;
                }
                Fluid superCoolant = FluidRegistry.getFluid((String)"supercoolant");
                FluidStack tFluid = new FluidStack(superCoolant, 10);
                FluidStack tLiquid = this.mCoolantInputHatch.drain(tFluid.amount, true);
                if (tLiquid == null || tLiquid.amount < tFluid.amount || !tLiquid.equals((Object)tFluid)) {
                    this.criticalStopMachine();
                    return false;
                }
            }
            this.ticker = 0;
        }
        ++this.ticker;
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return (int)(10000.0f * this.mRoughnessMultiplier);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    private int getTier() {
        return this.mSetTier;
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
        if (aEventID == 1) {
            if ((aValue & 1) == 1) {
                this.mSetTier = 1;
            }
            if ((aValue & 2) == 2) {
                this.mSetTier = 2;
            }
            if ((aValue & 4) == 4) {
                this.mSetTier = 3;
            }
            if ((aValue & 8) == 8) {
                this.mBioUpgrade = true;
            }
            if ((aValue & 0x40) == 64) {
                this.mBioRotate = true;
            }
            if ((aValue & 0x10) == 16) {
                this.mOCTier1 = true;
            }
            if ((aValue & 0x20) == 32) {
                this.mOCTier2 = true;
            }
        }
    }

    private ExtendedFacing transformFacing(ExtendedFacing facing) {
        ForgeDirection curDirection = facing.getDirection();
        Rotation curRotation = facing.getRotation();
        Flip curFlip = facing.getFlip();
        ForgeDirection newDirection = curDirection;
        Rotation newRotation = curRotation;
        Flip newFlip = curFlip;
        if (curDirection == ForgeDirection.UP || curDirection == ForgeDirection.DOWN) {
            switch (curRotation) {
                case CLOCKWISE: 
                case COUNTER_CLOCKWISE: {
                    newFlip = curFlip == Flip.NONE ? Flip.HORIZONTAL : Flip.NONE;
                    newDirection = curDirection == ForgeDirection.UP ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
                    break;
                }
                case NORMAL: {
                    newRotation = curDirection == ForgeDirection.UP ? Rotation.CLOCKWISE : Rotation.COUNTER_CLOCKWISE;
                    newDirection = curDirection == ForgeDirection.UP ? ForgeDirection.EAST : ForgeDirection.WEST;
                    newFlip = Flip.NONE;
                    break;
                }
                case UPSIDE_DOWN: {
                    newRotation = curDirection == ForgeDirection.UP ? Rotation.COUNTER_CLOCKWISE : Rotation.CLOCKWISE;
                    newDirection = curDirection == ForgeDirection.UP ? ForgeDirection.EAST : ForgeDirection.WEST;
                    newFlip = Flip.NONE;
                }
            }
        } else if (curRotation == Rotation.CLOCKWISE || curRotation == Rotation.COUNTER_CLOCKWISE) {
            newFlip = curRotation == Rotation.CLOCKWISE ? (curFlip == Flip.NONE ? Flip.NONE : Flip.HORIZONTAL) : (curFlip != Flip.NONE ? Flip.NONE : Flip.HORIZONTAL);
            newDirection = curRotation == Rotation.CLOCKWISE ? ForgeDirection.UP : ForgeDirection.DOWN;
        } else {
            switch (curDirection) {
                case EAST: {
                    ForgeDirection forgeDirection = ForgeDirection.SOUTH;
                    break;
                }
                case NORTH: {
                    ForgeDirection forgeDirection = ForgeDirection.EAST;
                    break;
                }
                case WEST: {
                    ForgeDirection forgeDirection = ForgeDirection.NORTH;
                    break;
                }
                case SOUTH: {
                    ForgeDirection forgeDirection = ForgeDirection.WEST;
                    break;
                }
                default: {
                    ForgeDirection forgeDirection = newDirection = curDirection;
                }
            }
        }
        if (curRotation == Rotation.UPSIDE_DOWN && curDirection != ForgeDirection.UP && curDirection != ForgeDirection.DOWN) {
            newFlip = curFlip == Flip.NONE ? Flip.HORIZONTAL : Flip.NONE;
        }
        return ExtendedFacing.of((ForgeDirection)newDirection, (Rotation)newRotation, (Flip)newFlip);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean addCoolantInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
            this.mCoolantInputHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    protected long getActualEnergyUsage() {
        return -this.lEUt * 10000L / (long)Math.min(Math.max(1000, this.mEfficiency), 10000);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.inputSeparation = !this.inputSeparation;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_PCBFactory.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.getExoticAndNormalEnergyHatchList()) {
            if (!GT_MetaTileEntity_PCBFactory.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        long voltage = this.getAverageInputVoltage();
        long amps = this.getMaxInputAmps();
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(voltage) + EnumChatFormatting.RESET + " EU/t(*" + amps + " A)" + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(voltage)] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.GREEN + this.mMaxParallel, StatCollector.func_74838_a((String)"GT5U.multiblock.curparallelism") + ": " + EnumChatFormatting.GREEN + this.mCurrentParallel};
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Circuit Board Fabricator").addInfo("Controller for the PCB Factory").addInfo(EnumChatFormatting.GOLD.toString() + EnumChatFormatting.BOLD + "IMPORTANT! Check the configuration menu before building.").addInfo("Tier of the machine determines the available recipes.").addInfo("Machine tier (1-3) is set in the controller GUI.").addInfo("The configuration menu can be used to add upgrades.").addInfo("Each tier and upgrade requires additional structures.").addInfo("Power consumption is multiplied by Sqrt(structures).").addInfo("Tier 2 and 3 allow parallel by using extra nanites.").addInfo("Every doubling of nanites adds one parallel.").addInfo("1x->1, 2x->2, 4x->3, 8x->4 with no limit.").addInfo("Recipes require a cooling upgrade to be overclocked.").addInfo("Liquid Cooling uses 10 L/s of distilled water and enables default overclocks.").addInfo("Thermosink uses 10 L/s of Super Coolant and enables perfect overclocks.").addInfo("Trace size can be changed to modify the material usage and machine speed.").addInfo(GT_Values.AuthorBlueWeabo).beginStructureBlock(30, 38, 13, false).addSeparator().addMaintenanceHatch(EnumChatFormatting.GOLD + "1", 1).addEnergyHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "-" + EnumChatFormatting.GOLD + "2" + EnumChatFormatting.GRAY + " or " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " TT energy hatch.", 1).addInputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addOutputBus(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addInputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+", 1).addStructureInfo("Coolant Hatch (Input Hatch): " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "Center of the Liquid Cooling/Thermosink").addStructureInfo(EnumChatFormatting.BLUE + "Base Multi (Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Damascus Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "9" + EnumChatFormatting.GRAY + " Vibrant Alloy Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "25" + EnumChatFormatting.GRAY + " Reinforced Glass").addStructureInfo(EnumChatFormatting.GOLD + "77" + EnumChatFormatting.GRAY + " Basic Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.GOLD + "12" + EnumChatFormatting.GRAY + " Grate Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "25" + EnumChatFormatting.GRAY + " Plascrete Block").addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 2 + EnumChatFormatting.BLUE + " (Adds to Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "34" + EnumChatFormatting.GRAY + " Duranium Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "158" + EnumChatFormatting.GRAY + " Reinforced Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 3 + EnumChatFormatting.BLUE + ":").addStructureInfo(EnumChatFormatting.GOLD + "292" + EnumChatFormatting.GRAY + " Radiation Proof Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.GOLD + "76" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.BLUE + "Biochamber Upgrade").addStructureInfo(EnumChatFormatting.GOLD + "68" + EnumChatFormatting.GRAY + " Clean Stainless Steel Machine Casing").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Damascus Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "72" + EnumChatFormatting.GRAY + " Reinforced Glass").addStructureInfo(EnumChatFormatting.BLUE + "Liquid Cooling Tower (Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Damascus Steel Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "68" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.GOLD + "12" + EnumChatFormatting.GRAY + " Extreme Engine Intake Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Tungstensteel Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "21" + EnumChatFormatting.GRAY + " Reinforced Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.BLUE + "Thermosink Radiator(Tier " + EnumChatFormatting.DARK_PURPLE + 2 + EnumChatFormatting.BLUE + "):").addStructureInfo(EnumChatFormatting.GOLD + "40" + EnumChatFormatting.GRAY + " Americium Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "41" + EnumChatFormatting.GRAY + " Reinforced Photolithography Framework Casing").addStructureInfo(EnumChatFormatting.GOLD + "8" + EnumChatFormatting.GRAY + " Superconducting Coil Block").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Tungstensteel Pipe Casing").addStructureInfo(EnumChatFormatting.GOLD + "48" + EnumChatFormatting.GRAY + " Infinity Cooled Casing").toolTipFinisher("GregTech");
        return tt;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mBioUpgrade", this.mBioUpgrade);
        aNBT.func_74757_a("mBioRotate", this.mBioRotate);
        aNBT.func_74768_a("mBioOffsetX", this.mBioOffsets[0]);
        aNBT.func_74768_a("mBioOffsetZ", this.mBioOffsets[1]);
        aNBT.func_74757_a("mOCTier1Upgrade", this.mOCTier1);
        aNBT.func_74768_a("mOCTier1OffsetX", this.mOCTier1Offsets[0]);
        aNBT.func_74768_a("mOCTier1OffsetZ", this.mOCTier1Offsets[1]);
        aNBT.func_74757_a("mOCTier2Upgrade", this.mOCTier2);
        aNBT.func_74768_a("mOCTier2OffsetX", this.mOCTier2Offsets[0]);
        aNBT.func_74768_a("mOCTier2OffsetZ", this.mOCTier2Offsets[1]);
        aNBT.func_74776_a("mRoughnessMultiplier", this.mRoughnessMultiplier);
        aNBT.func_74768_a("mSetTier", this.mSetTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("mSeparate")) {
            this.inputSeparation = aNBT.func_74767_n("mSeparate");
        }
        this.mBioUpgrade = aNBT.func_74767_n("mBioUpgrade");
        this.mBioRotate = aNBT.func_74767_n("mBioRotate");
        this.mBioOffsets[0] = aNBT.func_74762_e("mBioOffsetX");
        this.mBioOffsets[1] = aNBT.func_74762_e("mBioOffsetZ");
        this.mOCTier1 = aNBT.func_74767_n("mOCTier1Upgrade");
        this.mOCTier1Offsets[0] = aNBT.func_74762_e("mOCTier1OffsetX");
        this.mOCTier1Offsets[1] = aNBT.func_74762_e("mOCTier1OffsetZ");
        this.mOCTier2 = aNBT.func_74767_n("mOCTier2Upgrade");
        this.mOCTier2Offsets[0] = aNBT.func_74762_e("mOCTier2OffsetX");
        this.mOCTier2Offsets[1] = aNBT.func_74762_e("mOCTier2OffsetZ");
        this.mRoughnessMultiplier = aNBT.func_74760_g("mRoughnessMultiplier");
        this.mSetTier = aNBT.func_74762_e("mSetTier");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_MAGNETIZER_LOOP;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public byte getUpdateData() {
        byte data = 0;
        data = this.mSetTier == 1 ? (byte)((byte)(data + 1)) : (this.mSetTier == 2 ? (byte)((byte)(data + 2)) : (byte)((byte)(data + 4)));
        if (this.mBioUpgrade) {
            data = (byte)(data + 8);
        }
        if (this.mBioRotate) {
            data = (byte)(data + 64);
        }
        if (this.mOCTier1) {
            data = (byte)(data + 16);
        }
        if (this.mOCTier2) {
            data = (byte)(data + 32);
        }
        return data;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(10, this::createConfigurationWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            ret.add(GT_UITextures.BUTTON_STANDARD);
            ret.add(GT_UITextures.OVERLAY_BUTTON_CYCLIC);
            return ret.toArray(new IDrawable[0]);
        }).addTooltip("Configuration Menu").setPos(174, 130))).widget(new TextWidget(new Text("Tier")).setTextAlignment(Alignment.Center).setScale(0.91f).setSize(20, 16).setPos(173, 98))).widget(new TextFieldWidget().setGetterInt(() -> this.mSetTier).setSetterInt(val -> {
            this.mSetTier = val;
        }).setNumbers(1, 3).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("PCB Factory Tier").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(18, 18).setPos(173, 110));
    }

    protected ModularWindow createConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)160);
        builder.setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CYCLIC).setPos(5, 5).setSize(16, 16))).widget(new TextWidget("Configuration Menu").setPos(25, 9))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(185, 3))).widget(((Column)((Column)((Column)((Column)((Column)((Column)((Column)new DynamicPositionedColumn().setSynced(false).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mBioUpgrade, val -> {
            this.mBioUpgrade = val;
            if (!this.mBioUpgrade) {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("339.1", "Biochamber Upgrade Disabled"));
            } else {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("339", "Biochamber Upgrade Enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip("Enables nanites to construct organic circuitry. Required for Bioware and Wetware boards.")).addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget("Biochamber").setTextAlignment(Alignment.Center).setPos(23, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mBioRotate, val -> {
            this.mBioRotate = val;
            if (!this.mBioRotate) {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("340.1", "Rotated biochamber disabled"));
            } else {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("340", "Rotated biochamber enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip("Rotates the biochamber by 90 degrees.")).addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget("Bio Rotation").setTextAlignment(Alignment.Center).setPos(23, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mOCTier1, val -> {
            this.mOCTier1 = val;
            if (!this.mOCTier1) {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("341.1", "Tier 1 cooling disabled"));
            } else {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("341", "Tier 1 cooling enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip("Allows for overclocking. Requires 10 L/s of distilled water. Cooling upgrades are mutually exclusive.")).addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget("Liquid Cooling").setTextAlignment(Alignment.Center).setPos(20, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new MultiChildWidget().addChild(new CycleButtonWidget().setToggle(() -> this.mOCTier2, val -> {
            this.mOCTier2 = val;
            if (!this.mOCTier2) {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("342.1", "Tier 2 cooling disabled"));
            } else {
                GT_Utility.sendChatToPlayer(player, GT_Utility.trans("342", "Tier 2 cooling enabled"));
            }
        }).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setSize(90, 18).addTooltip("Enables perfect overclocking by allowing nanites to work with extreme speed and efficiency. Uses 10 L/s of Super Coolant.")).addChild(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CYCLIC).setSize(18, 18)).addChild(new TextWidget("Thermosink").setTextAlignment(Alignment.Center).setPos(20, 5)).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new TextWidget(new Text("Trace Size")).setSize(90, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(0, 4))).widget(new TextFieldWidget().setGetterInt(() -> (int)(1.0f / this.mRoughnessMultiplier * 100.0f)).setSetterInt(val -> {
            this.mRoughnessMultiplier = 100.0f / (float)val.intValue();
        }).setNumbers(50, 200).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("Set the trace size. Smaller traces allow material savings but take longer to fabricate. Larger traces waste material but are fast. 50-200 \u03bcm.").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(90, 16))).widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.OVERLAY_BUTTON_CROSS).setSize(18, 18).addTooltip(new Text("Can't change configuration when running !").color(Color.RED.dark(3))).setEnabled(widget -> this.getBaseMetaTileEntity().isActive()))).setPos(10, 25))).widget(((Column)((Column)((Column)((Column)((Column)((Column)new DynamicPositionedColumn().setSynced(false).widget(new TextWidget(new Text("Bio Upgrade Offsets")).setSize(72, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget(new TextFieldWidget().setGetterInt(() -> this.mBioOffsets[0]).setSetterInt(val -> {
            this.mBioOffsets[0] = val;
        }).setNumbers(-16, 16).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("X Offset").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).widget(new TextFieldWidget().setGetterInt(() -> this.mBioOffsets[1]).setSetterInt(val -> {
            this.mBioOffsets[1] = val;
        }).setNumbers(-16, 16).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("Z Offset").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new TextWidget(new Text("Cooler Tier 1 Offsets")).setSize(72, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget(new TextFieldWidget().setGetterInt(() -> this.mOCTier1Offsets[0]).setSetterInt(val -> {
            this.mOCTier1Offsets[0] = val;
        }).setNumbers(-16, 16).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("X Offset").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).widget(new TextFieldWidget().setGetterInt(() -> this.mOCTier1Offsets[1]).setSetterInt(val -> {
            this.mOCTier1Offsets[1] = val;
        }).setNumbers(-16, 16).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("Z Offset").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(new TextWidget(new Text("Cooler Tier 2 Offsets")).setSize(72, 18).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).widget(((Row)((Row)new DynamicPositionedRow().setSynced(false).widget(new TextFieldWidget().setGetterInt(() -> this.mOCTier2Offsets[0]).setSetterInt(val -> {
            this.mOCTier2Offsets[0] = val;
        }).setNumbers(-16, 16).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("X Offset").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).widget(new TextFieldWidget().setGetterInt(() -> this.mOCTier2Offsets[1]).setSetterInt(val -> {
            this.mOCTier2Offsets[1] = val;
        }).setNumbers(-16, 16).setTextColor(Color.WHITE.normal).setTextAlignment(Alignment.Center).addTooltip("Z Offset").setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setSize(36, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()))).setPos(110, 25));
        return builder.build();
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }
}

