/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ProcessingCrop
implements IOreRecipeRegistrator {
    public ProcessingCrop() {
        OrePrefixes.crop.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(8L, aStack)).itemOutputs(ItemList.IC2_PlantballCompressed.get(1L, new Object[0])).noFluidInputs().noFluidOutputs().duration(300).eut(2).addTo(GT_Recipe.GT_Recipe_Map.sCompressorRecipes);
        Fluid[] waterArray = Mods.IndustrialCraft2.isModLoaded() ? new Fluid[]{FluidRegistry.WATER, GT_ModHandler.getDistilledWater(1L).getFluid()} : new Fluid[]{FluidRegistry.WATER};
        switch (aOreDictName) {
            case "cropTea": {
                for (Fluid tFluid : waterArray) {
                    GT_Values.RA.stdBuilder().itemInputs(aStack).noItemOutputs().fluidInputs(new FluidStack(tFluid, 750)).fluidOutputs(new FluidStack(FluidRegistry.getFluid((String)"potion.tea"), 750)).duration(128).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBrewingRecipes);
                }
                break;
            }
            case "cropGrape": {
                for (Fluid tFluid : waterArray) {
                    GT_Values.RA.stdBuilder().itemInputs(aStack).noItemOutputs().fluidInputs(new FluidStack(tFluid, 750)).fluidOutputs(new FluidStack(FluidRegistry.getFluid((String)"potion.grapejuice"), 750)).duration(128).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBrewingRecipes);
                }
                break;
            }
            case "cropChilipepper": {
                GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Chili, 1L)).noFluidInputs().noFluidOutputs().duration(400).eut(2).addTo(GT_Recipe.GT_Recipe_Map.sMaceratorRecipes);
                break;
            }
            case "cropCoffee": {
                GT_Values.RA.stdBuilder().itemInputs(aStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Coffee, 1L)).noFluidInputs().noFluidOutputs().duration(400).eut(2).addTo(GT_Recipe.GT_Recipe_Map.sMaceratorRecipes);
                break;
            }
            case "cropPotato": {
                GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])).itemOutputs(ItemList.Food_Raw_PotatoChips.get(1L, new Object[0])).noFluidInputs().noFluidOutputs().duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
                GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Shape_Slicer_Stripes.get(0L, new Object[0])).itemOutputs(ItemList.Food_Raw_Fries.get(1L, new Object[0])).noFluidInputs().noFluidOutputs().duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
                for (Fluid tFluid : waterArray) {
                    GT_Values.RA.stdBuilder().itemInputs(aStack).noItemOutputs().fluidInputs(new FluidStack(tFluid, 750)).fluidOutputs(new FluidStack(FluidRegistry.getFluid((String)"potion.potatojuice"), 750)).duration(128).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBrewingRecipes);
                }
                break;
            }
            case "cropLemon": {
                GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])).itemOutputs(ItemList.Food_Sliced_Lemon.get(4L, new Object[0])).noFluidInputs().noFluidOutputs().duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
                for (Fluid tFluid : waterArray) {
                    GT_Values.RA.stdBuilder().itemInputs(aStack).noItemOutputs().fluidInputs(new FluidStack(tFluid, 750)).fluidOutputs(new FluidStack(FluidRegistry.getFluid((String)"potion.lemonjuice"), 750)).duration(128).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBrewingRecipes);
                }
                GT_Values.RA.stdBuilder().itemInputs(aStack).noItemOutputs().fluidInputs(new FluidStack(FluidRegistry.getFluid((String)"potion.vodka"), 750)).fluidOutputs(new FluidStack(FluidRegistry.getFluid((String)"potion.leninade"), 750)).duration(128).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sBrewingRecipes);
                break;
            }
            case "cropTomato": {
                GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])).itemOutputs(ItemList.Food_Sliced_Tomato.get(4L, new Object[0])).noFluidInputs().noFluidOutputs().duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
                break;
            }
            case "cropCucumber": {
                GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])).itemOutputs(ItemList.Food_Sliced_Cucumber.get(4L, new Object[0])).noFluidInputs().noFluidOutputs().duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
                break;
            }
            case "cropOnion": {
                GT_Values.RA.stdBuilder().itemInputs(aStack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])).itemOutputs(ItemList.Food_Sliced_Onion.get(4L, new Object[0])).noFluidInputs().noFluidOutputs().duration(64).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sSlicerRecipes);
            }
        }
    }
}

