/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemDrawable
implements IDrawable {
    @NotNull
    private Supplier<ItemStack> item;

    public ItemDrawable() {
        this((ItemStack)null);
    }

    public ItemDrawable(ItemStack item) {
        this.item = () -> item;
    }

    public ItemDrawable(@NotNull Supplier<ItemStack> itemGetter) {
        this.item = itemGetter;
    }

    @Override
    public void applyThemeColor(int color) {
    }

    @Override
    public void draw(float x, float y, float width, float height, float partialTicks) {
        ItemStack item = this.item.get();
        if (item == null || item.func_77973_b() == null) {
            return;
        }
        GlStateManager.pushMatrix();
        RenderHelper.func_74520_c();
        GlStateManager.enableDepth();
        GlStateManager.scale(width / 16.0f, height / 16.0f, 1.0f);
        ModularGui.getItemRenderer().func_82406_b(GuiHelper.getFontRenderer(item), Minecraft.func_71410_x().func_110434_K(), item, (int)x, (int)y);
        GuiHelper.afterRenderItemAndEffectIntoGUI(item);
        GlStateManager.disableDepth();
        RenderHelper.func_74519_b();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
    }

    @Override
    public DrawableWidget asWidget() {
        return (DrawableWidget)IDrawable.super.asWidget().setSize(16, 16);
    }

    public DrawableWidget asWidgetWithTooltip() {
        DrawableWidget widget = this.asWidget();
        return (DrawableWidget)widget.setUpdateTooltipEveryTick(true).dynamicTooltip(() -> {
            if (this.item.get() == null) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(GuiHelper.getItemTooltip(this.item.get()));
        });
    }

    public ItemStack getItem() {
        return this.item.get();
    }

    public ItemDrawable setItem(ItemStack item) {
        this.item = () -> item;
        return this;
    }

    public ItemDrawable setItem(@NotNull Supplier<ItemStack> itemGetter) {
        this.item = itemGetter;
        return this;
    }
}

