/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.widget;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;

public interface ISyncedWidget {
    @SideOnly(value=Side.CLIENT)
    public void readOnClient(int var1, PacketBuffer var2) throws IOException;

    public void readOnServer(int var1, PacketBuffer var2) throws IOException;

    default public void detectAndSendChanges(boolean init) {
    }

    public void markForUpdate();

    public void unMarkForUpdate();

    public boolean isMarkedForUpdate();

    @SideOnly(value=Side.CLIENT)
    default public void syncToServer(int id, Consumer<PacketBuffer> bufBuilder) {
        if (!(this instanceof Widget)) {
            throw new IllegalStateException("Tried syncing a non Widget ISyncedWidget");
        }
        if (id == -1) {
            throw new IllegalArgumentException("Id -1 is already reserved for syncing!");
        }
        this.getWindow().getContext().sendClientPacket(id, this, this.getWindow(), bufBuilder);
    }

    default public void syncToClient(int id, Consumer<PacketBuffer> bufBuilder) {
        if (!(this instanceof Widget)) {
            throw new IllegalStateException("Tried syncing a non Widget ISyncedWidget");
        }
        if (id == -1) {
            throw new IllegalArgumentException("Id -1 is already reserved for syncing!");
        }
        this.getWindow().getContext().sendServerPacket(id, this, this.getWindow(), bufBuilder);
    }

    public ModularWindow getWindow();
}

