/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.internal.wrapper;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiList<T>
extends AbstractList<T> {
    private final List<List<T>> lists = new ArrayList<List<T>>();
    private final List<T> defaultList = new ArrayList<T>();

    public MultiList() {
        this.lists.add(this.defaultList);
    }

    public void addList(List<T> list) {
        this.lists.add(list);
    }

    public void addElements(T ... ts) {
        this.addList(Arrays.asList(ts));
    }

    public void clearLists() {
        this.lists.clear();
        this.defaultList.clear();
        this.lists.add(this.defaultList);
    }

    @Override
    public void clear() {
        for (List<T> list : this.lists) {
            list.clear();
        }
    }

    @Override
    public boolean add(T element) {
        this.defaultList.add(element);
        return true;
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        for (List<T> list : this.lists) {
            if (index >= list.size()) {
                index -= list.size();
                continue;
            }
            return list.get(index);
        }
        throw new IndexOutOfBoundsException("Index out of bounds: " + index);
    }

    @Override
    public int size() {
        return this.lists.stream().mapToInt(List::size).sum();
    }

    @Override
    public Iterator<T> iterator() {
        return new MultiListIterator();
    }

    private class MultiListIterator
    implements Iterator<T> {
        private int listCursor = 0;
        private int cursor = 0;
        private List<T> currentLists;

        private MultiListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.listCursor < MultiList.this.lists.size() || this.cursor < this.currentLists.size();
        }

        @Override
        public T next() {
            try {
                while (this.currentLists == null || this.cursor == this.currentLists.size()) {
                    this.currentLists = (List)MultiList.this.lists.get(this.listCursor++);
                    this.cursor = 0;
                }
                return this.currentLists.get(this.cursor++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

