/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.function.Consumer;

public class SortedRegistry<V>
implements Iterable<V> {
    private final NavigableMap<String, V> store = new TreeMap<String, V>();
    private List<V> baked = Collections.emptyList();

    public void register(String key, V val) {
        if (key == null || val == null) {
            throw new NullPointerException();
        }
        V old = this.store.putIfAbsent(key, val);
        if (old != null) {
            throw new IllegalArgumentException("Duplicate key: " + key);
        }
        this.baked = new ArrayList(this.store.values());
    }

    public int size() {
        return this.store.size();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.store.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.store.containsValue(value);
    }

    public V get(String key) {
        return this.store.get(key);
    }

    @Override
    public Iterator<V> iterator() {
        return this.baked.iterator();
    }

    @Override
    public void forEach(Consumer<? super V> action) {
        this.baked.forEach(action);
    }

    @Override
    public Spliterator<V> spliterator() {
        return this.baked.spliterator();
    }
}

