/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.integration.journeymap.JourneyMapState;
import com.sinthoras.visualprospecting.integration.model.MapState;
import com.sinthoras.visualprospecting.integration.model.buttons.ButtonManager;
import com.sinthoras.visualprospecting.integration.model.layers.LayerManager;
import com.sinthoras.visualprospecting.integration.model.layers.OreVeinLayerManager;
import com.sinthoras.visualprospecting.integration.model.layers.UndergroundFluidLayerManager;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.XaeroWorldMapState;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.buttons.LayerButton;
import com.sinthoras.visualprospecting.integration.xaeroworldmap.renderers.LayerRenderer;
import com.sinthoras.visualprospecting.network.ProspectingNotification;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class VisualProspecting_API {

    public static class LogicalServer {
        public static OreVeinPosition getOreVein(int dimensionId, int blockX, int blockZ) {
            return ServerCache.instance.getOreVein(dimensionId, Utils.mapToCenterOreChunkCoord(blockX), Utils.mapToCenterOreChunkCoord(blockZ));
        }

        public static UndergroundFluidPosition getUndergroundFluid(World world, int blockX, int blockZ) {
            return LogicalServer.prospectUndergroundFluidsWithingRadius(world, blockX, blockZ, 0).get(0);
        }

        public static void notifyOreGeneration(int dimensionId, int blockX, int blockZ, String oreVeinName) {
            ServerCache.instance.notifyOreVeinGeneration(dimensionId, blockX, blockZ, oreVeinName);
        }

        public static void sendProspectionResultsToClient(EntityPlayerMP player, List<OreVeinPosition> oreVeins, List<UndergroundFluidPosition> undergroundFluids) {
            if (Utils.isLogicalClient()) {
                ClientCache.instance.putOreVeins(oreVeins);
                ClientCache.instance.putUndergroundFluids(undergroundFluids);
            } else {
                VP.network.sendTo((IMessage)new ProspectingNotification(oreVeins, undergroundFluids), player);
            }
        }

        public static List<OreVeinPosition> prospectOreVeinsWithinRadius(int dimensionId, int blockX, int blockZ, int blockRadius) {
            return ServerCache.instance.prospectOreBlockRadius(dimensionId, blockX, blockZ, blockRadius);
        }

        public static List<UndergroundFluidPosition> prospectUndergroundFluidsWithingRadius(World world, int blockX, int blockZ, int blockRadius) {
            return ServerCache.instance.prospectUndergroundFluidBlockRadius(world, blockX, blockZ, blockRadius);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LogicalClient {
        public static void registerCustomButtonManager(ButtonManager customManager) {
            MapState.instance.buttons.add(customManager);
        }

        public static void registerCustomLayer(LayerManager customLayer) {
            MapState.instance.layers.add(customLayer);
        }

        public static void registerJourneyMapButton(com.sinthoras.visualprospecting.integration.journeymap.buttons.LayerButton customButton) {
            if (Utils.isJourneyMapInstalled()) {
                JourneyMapState.instance.buttons.add(customButton);
            }
        }

        public static void registerXaeroMapButton(LayerButton customButton) {
            if (Utils.isXaerosWorldMapInstalled()) {
                XaeroWorldMapState.instance.buttons.add(customButton);
            }
        }

        public static void registerJourneyMapRenderer(com.sinthoras.visualprospecting.integration.journeymap.render.LayerRenderer customRenderer) {
            if (Utils.isJourneyMapInstalled()) {
                JourneyMapState.instance.renderers.add(customRenderer);
            }
        }

        public static void registerXaeroMapRenderer(LayerRenderer customRenderer) {
            if (Utils.isXaerosWorldMapInstalled()) {
                XaeroWorldMapState.instance.renderers.add(customRenderer);
            }
        }

        public static void openJourneyForOreVeinsMapAt(int blockX, int blockZ) {
            if (Utils.isJourneyMapInstalled()) {
                OreVeinLayerManager.instance.activateLayer();
                JourneyMapState.instance.openJourneyMapAt(blockX, blockZ);
            }
        }

        public static void openJourneyForOreVeinsMapAt(int blockX, int blockZ, int zoom) {
            if (Utils.isJourneyMapInstalled()) {
                OreVeinLayerManager.instance.activateLayer();
                JourneyMapState.instance.openJourneyMapAt(blockX, blockZ, zoom);
            }
        }

        public static void openJourneyMapForUndergroundFluidsAt(int blockX, int blockZ) {
            if (Utils.isJourneyMapInstalled()) {
                UndergroundFluidLayerManager.instance.activateLayer();
                JourneyMapState.instance.openJourneyMapAt(blockX, blockZ);
            }
        }

        public static void openJourneyMapForUndergroundFluidsAt(int blockX, int blockZ, int zoom) {
            if (Utils.isJourneyMapInstalled()) {
                UndergroundFluidLayerManager.instance.activateLayer();
                JourneyMapState.instance.openJourneyMapAt(blockX, blockZ, zoom);
            }
        }

        public static void triggerProspectingForOreBlock(EntityPlayer player, World world, int blockX, int blockY, int blockZ) {
            ClientCache.instance.onOreInteracted(world, blockX, blockY, blockZ, player);
        }

        public static OreVeinPosition getOreVein(int dimensionId, int blockX, int blockZ) {
            return ClientCache.instance.getOreVein(dimensionId, Utils.coordBlockToChunk(blockX), Utils.coordBlockToChunk(blockZ));
        }

        public static UndergroundFluidPosition getUndergroundFluid(int dimensionId, int blockX, int blockZ) {
            return ClientCache.instance.getUndergroundFluid(dimensionId, Utils.coordBlockToChunk(blockX), Utils.coordBlockToChunk(blockZ));
        }

        public static void setOreVeinDepleted(int dimensionId, int blockX, int blockZ) {
            OreVeinPosition oreVeinPosition = ClientCache.instance.getOreVein(dimensionId, Utils.coordBlockToChunk(blockX), Utils.coordBlockToChunk(blockZ));
            if (!oreVeinPosition.isDepleted()) {
                oreVeinPosition.toggleDepleted();
            }
            ClientCache.instance.putOreVeins(Collections.singletonList(oreVeinPosition));
        }

        public static void toggleOreVeinDepleted(OreVeinPosition oreVeinPosition) {
            oreVeinPosition = ClientCache.instance.getOreVein(oreVeinPosition.dimensionId, oreVeinPosition.chunkX, oreVeinPosition.chunkZ);
            oreVeinPosition.toggleDepleted();
            ClientCache.instance.putOreVeins(Collections.singletonList(oreVeinPosition));
        }

        public static void putProspectionResults(List<OreVeinPosition> oreVeins, List<UndergroundFluidPosition> undergroundFluids) {
            ClientCache.instance.putOreVeins(oreVeins);
            ClientCache.instance.putUndergroundFluids(undergroundFluids);
        }
    }
}

