/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.veintypes;

import com.sinthoras.visualprospecting.database.veintypes.IOreMaterialProvider;
import gregtech.api.GregTech_API;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.EnumChatFormatting;

public class VeinType {
    public static final int veinHeight = 9;
    public final String name;
    public short veinId;
    public final IOreMaterialProvider oreMaterialProvider;
    public final int blockSize;
    public final short primaryOreMeta;
    public final short secondaryOreMeta;
    public final short inBetweenOreMeta;
    public final short sporadicOreMeta;
    public final int minBlockY;
    public final int maxBlockY;
    public final Set<Short> oresAsSet;
    private boolean isHighlighted = true;
    public static final VeinType NO_VEIN = new VeinType("ore.mix.none", null, 0, -1, -1, -1, -1, 0, 0);

    public VeinType(String name, IOreMaterialProvider oreMaterialProvider, int blockSize, short primaryOreMeta, short secondaryOreMeta, short inBetweenOreMeta, short sporadicOreMeta, int minBlockY, int maxBlockY) {
        this.name = name;
        this.oreMaterialProvider = oreMaterialProvider;
        this.blockSize = blockSize;
        this.primaryOreMeta = primaryOreMeta;
        this.secondaryOreMeta = secondaryOreMeta;
        this.inBetweenOreMeta = inBetweenOreMeta;
        this.sporadicOreMeta = sporadicOreMeta;
        this.minBlockY = minBlockY;
        this.maxBlockY = maxBlockY;
        this.oresAsSet = new HashSet<Short>();
        this.oresAsSet.add(primaryOreMeta);
        this.oresAsSet.add(secondaryOreMeta);
        this.oresAsSet.add(inBetweenOreMeta);
        this.oresAsSet.add(sporadicOreMeta);
    }

    public boolean matches(Set<Short> foundOres) {
        return foundOres.containsAll(this.oresAsSet);
    }

    public boolean matchesWithSpecificPrimaryOrSecondary(Set<Short> foundOres, short specificMeta) {
        return (this.primaryOreMeta == specificMeta || this.secondaryOreMeta == specificMeta) && foundOres.containsAll(this.oresAsSet);
    }

    public boolean canOverlapIntoNeighborOreChunk() {
        return this.blockSize > 24;
    }

    public boolean canOverlapIntoNeighborOreChunkAtCoordinateAxis() {
        return this.blockSize > 16;
    }

    public boolean containsOre(short oreMetaData) {
        return this.primaryOreMeta == oreMetaData || this.secondaryOreMeta == oreMetaData || this.inBetweenOreMeta == oreMetaData || this.sporadicOreMeta == oreMetaData;
    }

    public List<String> getOreMaterialNames() {
        return this.oresAsSet.stream().map(metaData -> GregTech_API.sGeneratedMaterials[metaData]).filter(Objects::nonNull).map(material -> EnumChatFormatting.GRAY + material.mLocalizedName).collect(Collectors.toList());
    }

    public Set<Short> getOresAtLayer(int layerBlockY) {
        HashSet<Short> result = new HashSet<Short>();
        switch (layerBlockY) {
            case 0: 
            case 1: 
            case 2: {
                result.add(this.secondaryOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 3: {
                result.add(this.secondaryOreMeta);
                result.add(this.inBetweenOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 4: {
                result.add(this.inBetweenOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 5: 
            case 6: {
                result.add(this.primaryOreMeta);
                result.add(this.inBetweenOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
            case 7: 
            case 8: {
                result.add(this.primaryOreMeta);
                result.add(this.sporadicOreMeta);
                return result;
            }
        }
        return result;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setNEISearchHeighlight(boolean isHighlighted) {
        this.isHighlighted = isHighlighted;
    }
}

