/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.journeymap.render;

import com.sinthoras.visualprospecting.integration.journeymap.drawsteps.ClickableDrawStep;
import com.sinthoras.visualprospecting.integration.journeymap.render.LayerRenderer;
import com.sinthoras.visualprospecting.integration.model.layers.WaypointProviderManager;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public abstract class WaypointProviderLayerRenderer
extends LayerRenderer {
    private final WaypointProviderManager manager;
    private List<ClickableDrawStep> drawSteps = new ArrayList<ClickableDrawStep>();
    private List<ClickableDrawStep> drawStepsReversed = new ArrayList<ClickableDrawStep>();
    private ClickableDrawStep hoveredDrawStep = null;

    public WaypointProviderLayerRenderer(WaypointProviderManager manager) {
        super(manager);
        this.manager = manager;
    }

    public List<ClickableDrawStep> getDrawStepsCachedForInteraction() {
        return this.drawSteps;
    }

    public List<ClickableDrawStep> getDrawStepsCachedForRendering() {
        return this.drawStepsReversed;
    }

    @Override
    public void updateVisibleElements(List<? extends ILocationProvider> visibleElements) {
        this.drawSteps = this.mapLocationProviderToDrawStep(visibleElements);
        this.drawStepsReversed = new ArrayList<ClickableDrawStep>(this.drawSteps);
        Collections.reverse(this.drawStepsReversed);
    }

    protected abstract List<? extends ClickableDrawStep> mapLocationProviderToDrawStep(List<? extends ILocationProvider> var1);

    public void onMouseMove(int mouseX, int mouseY) {
        this.hoveredDrawStep = null;
        for (ClickableDrawStep drawStep : this.getDrawStepsCachedForInteraction()) {
            if (!drawStep.isMouseOver(mouseX, mouseY)) continue;
            this.hoveredDrawStep = drawStep;
            return;
        }
    }

    public boolean onMouseAction(boolean isDoubleClick) {
        if (this.hoveredDrawStep != null) {
            if (isDoubleClick) {
                if (this.hoveredDrawStep.getLocationProvider().isActiveAsWaypoint()) {
                    this.manager.clearActiveWaypoint();
                } else {
                    this.manager.setActiveWaypoint(this.hoveredDrawStep.getLocationProvider().toWaypoint());
                }
            }
            return true;
        }
        return false;
    }

    public List<String> getTextTooltip() {
        if (this.hoveredDrawStep != null) {
            return this.hoveredDrawStep.getTooltip();
        }
        return null;
    }

    public void drawCustomTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
        if (this.hoveredDrawStep != null) {
            this.hoveredDrawStep.drawTooltip(fontRenderer, mouseX, mouseY, displayWidth, displayHeight);
        }
    }

    public void onActionKeyPressed() {
        if (this.manager.isLayerActive() && this.hoveredDrawStep != null) {
            this.hoveredDrawStep.onActionKeyPressed();
            this.manager.forceRefresh();
        }
    }

    @Override
    public boolean isLayerActive() {
        return this.manager.isLayerActive();
    }
}

