/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.xaerominimap.waypoints;

import com.sinthoras.visualprospecting.integration.model.SupportedMods;
import com.sinthoras.visualprospecting.integration.model.layers.WaypointProviderManager;
import com.sinthoras.visualprospecting.integration.xaerominimap.waypoints.WaypointType;
import com.sinthoras.visualprospecting.integration.xaerominimap.waypoints.WaypointWithDimension;
import java.util.Hashtable;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsManager;

public class WaypointManager
extends com.sinthoras.visualprospecting.integration.model.waypoints.WaypointManager {
    private static final Hashtable<Integer, Waypoint> xWaypointTable = WaypointsManager.getCustomWaypoints((String)"visualprospecting");
    private WaypointWithDimension xWaypoint;
    private final WaypointType waypointType;

    public WaypointManager(WaypointProviderManager layerManager, WaypointType waypointType) {
        super(layerManager, SupportedMods.XaeroMiniMap);
        this.waypointType = waypointType;
    }

    @Override
    public void clearActiveWaypoint() {
        this.xWaypoint = null;
        xWaypointTable.remove(this.waypointType.ordinal());
    }

    public boolean hasWaypoint() {
        return this.xWaypoint != null;
    }

    public WaypointWithDimension getXWaypoint() {
        return this.xWaypoint;
    }

    @Override
    public void updateActiveWaypoint(com.sinthoras.visualprospecting.integration.model.waypoints.Waypoint waypoint) {
        if (!this.hasWaypoint() || waypoint.blockX != this.xWaypoint.getX() || waypoint.blockY != this.xWaypoint.getY() || waypoint.blockZ != this.xWaypoint.getZ() || waypoint.dimensionId != this.xWaypoint.getDimID()) {
            this.xWaypoint = new WaypointWithDimension(waypoint.blockX, waypoint.blockY, waypoint.blockZ, waypoint.label, this.getSymbol(waypoint), 15, waypoint.dimensionId);
            xWaypointTable.put(this.waypointType.ordinal(), this.xWaypoint);
        }
    }

    protected String getSymbol(com.sinthoras.visualprospecting.integration.model.waypoints.Waypoint waypoint) {
        return waypoint.label.substring(0, 1);
    }
}

