/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.compat;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.common.block.BlockArchitecture;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.EnumWorldBlockLayer;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.MetaBlockState;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCompatUtils {
    public static String getNameForBlock(Block block) {
        if (block != null) {
            return Block.field_149771_c.func_148750_c((Object)block);
        }
        return "";
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int meta = 0;
        if (stack.func_77973_b().func_77614_k()) {
            meta = stack.func_77973_b().func_77647_b(stack.func_77960_j());
        }
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static int getMetaFromBlockState(IBlockState state) {
        if (state instanceof MetaBlockState) {
            return ((MetaBlockState)state).meta;
        }
        return ((BlockArchitecture)state.getBlock()).getMetaFromState(state);
    }

    public static IBlockState getWorldBlockState(IBlockAccess world, BlockPos pos) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        int meta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static boolean setWorldBlockState(World world, BlockPos pos, IBlockState state, int flags) {
        Block block = state.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return world.func_147465_d(pos.x, pos.y, pos.z, block, meta, flags);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess world, BlockPos pos) {
        return world.func_147438_o(pos.x, pos.y, pos.z);
    }

    public static World getTileEntityWorld(TileEntity te) {
        return te.func_145831_w();
    }

    public static BlockPos getTileEntityPos(TileEntity te) {
        return new BlockPos(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static boolean blockCanRenderInLayer(Block block, EnumWorldBlockLayer layer) {
        boolean bl;
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).canRenderInLayer(layer);
        }
        switch (layer) {
            case SOLID: {
                bl = block.canRenderInPass(0);
                break;
            }
            case TRANSLUCENT: {
                bl = block.canRenderInPass(1);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static IBlockState getDefaultBlockState(Block block) {
        if (block instanceof BlockArchitecture) {
            return ((BlockArchitecture)block).getDefaultState();
        }
        return new MetaBlockState(block, 0);
    }

    public static void playWorldAuxSFX(World world, int fxId, BlockPos pos, IBlockState state) {
        Block block = state.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        int stateId = meta << 12 | Block.func_149682_b((Block)block);
        world.func_72926_e(fxId, pos.getX(), pos.getY(), pos.getZ(), stateId);
    }

    public static float getBlockHardness(Block block, World world, BlockPos pos) {
        return block.func_149712_f(world, pos.x, pos.y, pos.z);
    }

    public static String getBlockHarvestTool(IBlockState state) {
        Block block = state.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return block.getHarvestTool(meta);
    }

    public static int getBlockHarvestLevel(IBlockState state) {
        Block block = state.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return block.getHarvestLevel(meta);
    }

    public static float getPlayerBreakSpeed(EntityPlayer player, IBlockState state, BlockPos pos) {
        Block block = state.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return player.getBreakSpeed(block, false, meta, pos.x, pos.y, pos.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getSpriteForBlockState(IBlockState state) {
        if (state != null) {
            Block block = state.getBlock();
            int meta = BlockCompatUtils.getMetaFromBlockState(state);
            return block.func_149691_a(2, meta);
        }
        return null;
    }

    public static void spawnBlockStackAsEntity(World world, BlockPos pos, ItemStack stack) {
        float var6 = 0.7f;
        double var7 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
        double var9 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
        double var11 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
        EntityItem var13 = new EntityItem(world, (double)pos.x + var7, (double)pos.y + var9, (double)pos.z + var11, stack);
        var13.field_145804_b = 10;
        world.func_72838_d((Entity)var13);
    }

    public static ItemStack blockStackWithState(IBlockState state, int size) {
        Block block = state.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState(state);
        return new ItemStack(block, size, meta);
    }
}

