/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.element;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.TabTracker;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.Rectangle4i;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class TabBase
extends ElementBase {
    public static int tabExpandSpeed = 8;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    protected int offsetX = 0;
    protected int offsetY = 0;
    public boolean open;
    public boolean fullyOpen;
    public int side = 1;
    public int headerColor = 14797103;
    public int subheaderColor = 11186104;
    public int textColor = 0;
    public int backgroundColor = 0xFFFFFF;
    protected int currentShiftX = 0;
    protected int currentShiftY = 0;
    public int minWidth = 22;
    public int maxWidth = 124;
    public int currentWidth = this.minWidth;
    public int minHeight = 22;
    public int maxHeight = 22;
    public int currentHeight = this.minHeight;
    protected ArrayList<ElementBase> elements = new ArrayList();
    public static final ResourceLocation DEFAULT_TEXTURE_LEFT = new ResourceLocation("cofh:textures/gui/elements/Tab_Left.png");
    public static final ResourceLocation DEFAULT_TEXTURE_RIGHT = new ResourceLocation("cofh:textures/gui/elements/Tab_Right.png");

    public TabBase(GuiBase guiBase) {
        super(guiBase, 0, 0);
        this.texture = DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase(GuiBase guiBase, int n) {
        super(guiBase, 0, 0);
        this.side = n;
        this.texture = n == 0 ? DEFAULT_TEXTURE_LEFT : DEFAULT_TEXTURE_RIGHT;
    }

    public TabBase setOffsets(int n, int n2) {
        this.posX -= this.offsetX;
        this.posY -= this.offsetY;
        this.offsetX = n;
        this.offsetY = n2;
        this.posX += this.offsetX;
        this.posY += this.offsetY;
        return this;
    }

    @Override
    public TabBase setPosition(int n, int n2) {
        this.posX = n + this.offsetX;
        this.posY = n2 + this.offsetY;
        return this;
    }

    protected void drawForeground() {
    }

    protected void drawBackground() {
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        RenderHelper.bindTexture(this.texture);
        int n = this.posX();
        this.gui.func_73729_b(n, this.posY + 4, 0, 256 - this.currentHeight + 4, 4, this.currentHeight - 4);
        this.gui.func_73729_b(n + 4, this.posY, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
        this.gui.func_73729_b(n, this.posY, 0, 0, 4, 4);
        this.gui.func_73729_b(n + 4, this.posY + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        n -= this.posX();
        n2 -= this.posY;
        GL11.glPushMatrix();
        this.drawBackground();
        GL11.glTranslatef((float)this.posX(), (float)this.posY, (float)0.0f);
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase elementBase = this.elements.get(i);
            if (!elementBase.isVisible()) continue;
            elementBase.drawBackground(n, n2, f);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void drawForeground(int n, int n2) {
        n -= this.posX();
        n2 -= this.posY;
        GL11.glPushMatrix();
        this.drawForeground();
        GL11.glTranslatef((float)this.posX(), (float)this.posY, (float)0.0f);
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase elementBase = this.elements.get(i);
            if (!elementBase.isVisible()) continue;
            elementBase.drawForeground(n, n2);
        }
        GL11.glPopMatrix();
    }

    @Override
    public void update(int n, int n2) {
        super.update(n, n2);
        n -= this.posX();
        n2 -= this.posY;
        int n3 = this.elements.size();
        while (n3-- > 0) {
            ElementBase elementBase = this.elements.get(n3);
            if (!elementBase.isVisible() || !elementBase.isEnabled()) continue;
            elementBase.update(n, n2);
        }
    }

    @Override
    public void update() {
        if (this.open && this.currentWidth < this.maxWidth) {
            this.currentWidth += tabExpandSpeed;
        } else if (!this.open && this.currentWidth > this.minWidth) {
            this.currentWidth -= tabExpandSpeed;
        }
        if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        } else if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        }
        if (this.open && this.currentHeight < this.maxHeight) {
            this.currentHeight += tabExpandSpeed;
        } else if (!this.open && this.currentHeight > this.minHeight) {
            this.currentHeight -= tabExpandSpeed;
        }
        if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        } else if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        }
        if (!this.fullyOpen && this.open && this.currentWidth == this.maxWidth && this.currentHeight == this.maxHeight) {
            this.setFullyOpen();
        }
    }

    protected void drawTabIcon(String string) {
        this.gui.drawIcon(string, this.posXOffset(), this.posY + 3, 1);
    }

    protected int posX() {
        if (this.side == 0) {
            return this.posX - this.currentWidth;
        }
        return this.posX;
    }

    protected int posXOffset() {
        return this.posX() + this.sideOffset();
    }

    protected int sideOffset() {
        return this.side == 0 ? 4 : 2;
    }

    public boolean intersectsWith(int n, int n2, int n3, int n4) {
        return this.side == 0 ? n <= n3 && n >= n3 - this.currentWidth && n2 >= n4 && n2 <= n4 + this.currentHeight : n >= (n3 += this.offsetX) && n <= n3 + this.currentWidth && n2 >= (n4 += this.offsetY) && n2 <= n4 + this.currentHeight;
    }

    public boolean isFullyOpened() {
        return this.fullyOpen;
    }

    public void setCurrentShift(int n, int n2) {
        this.updateElements();
        this.currentShiftX = n + this.offsetX;
        this.currentShiftY = n2 + this.offsetY;
    }

    public void setFullyOpen() {
        this.open = true;
        this.currentWidth = this.maxWidth;
        this.currentHeight = this.maxHeight;
        this.fullyOpen = true;
        this.updateElements();
    }

    public void toggleOpen() {
        if (this.open) {
            this.open = false;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(null);
            } else {
                TabTracker.setOpenedRightTab(null);
            }
            this.fullyOpen = false;
        } else {
            this.open = true;
            if (this.side == 0) {
                TabTracker.setOpenedLeftTab(this.getClass());
            } else {
                TabTracker.setOpenedRightTab(this.getClass());
            }
        }
        this.updateElements();
    }

    public Rectangle4i getBounds() {
        if (this.isVisible()) {
            return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), this.currentWidth, this.currentHeight);
        }
        return new Rectangle4i(this.posX() + this.gui.getGuiLeft(), this.posY + this.gui.getGuiTop(), 0, 0);
    }

    public ElementBase addElement(ElementBase elementBase) {
        this.elements.add(elementBase);
        return elementBase;
    }

    protected ElementBase getElementAtPosition(int n, int n2) {
        int n3 = this.elements.size();
        while (n3-- > 0) {
            ElementBase elementBase = this.elements.get(n3);
            if (!elementBase.intersectsWith(n, n2)) continue;
            return elementBase;
        }
        return null;
    }

    @Override
    public boolean onMouseWheel(int n, int n2, int n3) {
        int n4 = Mouse.getEventDWheel();
        n -= this.posX();
        n2 -= this.posY;
        if (n4 != 0) {
            int n5 = this.elements.size();
            while (n5-- > 0) {
                ElementBase elementBase = this.elements.get(n5);
                if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(n, n2) || !elementBase.onMouseWheel(n, n2, n4)) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public void addTooltip(List<String> list) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase elementBase = this.elements.get(i);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(this.gui.getMouseX(), this.gui.getMouseY())) continue;
            elementBase.addTooltip(list);
        }
    }

    @Override
    public boolean onKeyTyped(char c, int n) {
        int n2 = this.elements.size();
        while (n2-- > 0) {
            ElementBase elementBase = this.elements.get(n2);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.onKeyTyped(c, n)) continue;
            return true;
        }
        return super.onKeyTyped(c, n);
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        n -= this.posX();
        n2 -= this.posY;
        boolean bl = false;
        for (int i = 0; i < this.elements.size(); ++i) {
            ElementBase elementBase = this.elements.get(i);
            if (!elementBase.isVisible() || !elementBase.isEnabled() || !elementBase.intersectsWith(n, n2)) continue;
            bl = true;
            if (!elementBase.onMousePressed(n, n2, n3)) continue;
            return true;
        }
        return bl;
    }

    @Override
    public void onMouseReleased(int n, int n2) {
        n -= this.posX();
        n2 -= this.posY;
        int n3 = this.elements.size();
        while (n3-- > 0) {
            ElementBase elementBase = this.elements.get(n3);
            if (!elementBase.isVisible() || !elementBase.isEnabled()) continue;
            elementBase.onMouseReleased(n, n2);
        }
    }

    private void updateElements() {
        for (ElementBase elementBase : this.elements) {
            elementBase.setVisible(this.isFullyOpened());
        }
    }
}

