/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.server;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.ExtendedModule;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.WorldUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.dto.McoServer;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.net.UnknownHostException;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenRealmsProxy;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.OldServerPinger;
import net.minecraft.entity.Entity;
import net.minecraft.server.integrated.IntegratedServer;

public class ServerUtils
implements ExtendedModule {
    private static final ThreadPoolExecutor PING_EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).build());
    private static final List<String> invalidMotds = StringUtils.newArrayList((Object[])new String[]{"multiplayer.status.cannot_connect", "multiplayer.status.cannot_resolve", "multiplayer.status.polling", "multiplayer.status.pinging"});
    private static final List<String> invalidNames = StringUtils.newArrayList((Object[])new String[]{"selectServer.defaultName"});
    private final OldServerPinger pinger = new OldServerPinger();
    public List<GuiPlayerInfo> currentPlayerList = StringUtils.newArrayList();
    public List<String> knownAddresses = StringUtils.newArrayList();
    public List<String> defaultAddresses = StringUtils.newArrayList();
    public Map<String, ServerData> knownServerData = StringUtils.newHashMap();
    private ScheduledExecutorService PING_SCHEDULER;
    private boolean enabled = false;
    private boolean isInUse = false;
    private boolean hasScannedConfig = false;
    private boolean hasScannedInternals = false;
    private boolean hasInitialized = false;
    private boolean hasInitializedServer = false;
    private boolean hasInitializedRealm = false;
    private boolean hasCheckedRealm = false;
    private String currentServer_IP;
    private String formattedServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private List<String> currentServer_MOTD_Lines = StringUtils.newArrayList();
    private int currentPlayers;
    private int maxPlayers;
    private ServerList serverList;
    private int serverIndex = 0;
    private IntegratedServer currentIntegratedData;
    private ServerData currentServerData;
    private McoServer currentRealmData;
    private NetHandlerPlayClient currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;
    private boolean isOnSinglePlayer = false;
    private boolean isOnRealm = false;

    @Override
    public void clearFieldData() {
        this.currentPlayerList.clear();
        this.defaultAddresses.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.serverList = null;
        this.serverIndex = 0;
    }

    @Override
    public void clearAttributes() {
        this.currentServer_IP = null;
        this.formattedServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_MOTD_Lines.clear();
        this.currentServer_Name = null;
        this.currentIntegratedData = null;
        this.currentServerData = null;
        this.currentRealmData = null;
        this.currentConnection = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.stopPingTask();
        this.queuedForUpdate = false;
        this.joinInProgress = false;
        this.isOnLAN = false;
        this.isOnSinglePlayer = false;
        this.isOnRealm = false;
        CraftPresence.CLIENT.removeArguments("server", "data.server", "world", "data.world", "player");
        CraftPresence.CLIENT.removeForcedData("server");
        CraftPresence.CLIENT.clearPartyData();
        this.hasInitialized = false;
        this.hasInitializedServer = false;
        this.hasInitializedRealm = false;
        this.hasCheckedRealm = false;
    }

    @Override
    public void preTick() {
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
    }

    private McoServer findRealmData(NetHandlerPlayClient connection) {
        try {
            GuiScreenRealmsProxy realmsProxy;
            GuiScreen guiScreen = connection.field_147307_j;
            if (guiScreen instanceof GuiScreenRealmsProxy && (guiScreen = (realmsProxy = (GuiScreenRealmsProxy)guiScreen).func_154321_a()) instanceof RealmsMainScreen) {
                RealmsMainScreen realmsMainScreen = (RealmsMainScreen)guiScreen;
                return (McoServer)StringUtils.executeMethod(RealmsMainScreen.class, (Object)realmsMainScreen, (Class[])new Class[]{Long.TYPE}, (Object[])new Object[]{(long)((Long)StringUtils.getField(RealmsMainScreen.class, (Object)realmsMainScreen, (String[])new String[]{"selectedServerId"}))}, (String[])new String[]{"findServer"});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void updateData() {
        IntegratedServer newIntegratedData = CraftPresence.instance.func_71401_C();
        ServerData newServerData = CraftPresence.instance.func_147104_D();
        NetHandlerPlayClient newConnection = CraftPresence.instance.func_147114_u();
        if (!this.joinInProgress) {
            if (!this.hasCheckedRealm) {
                boolean canCheckRealm;
                boolean bl = canCheckRealm = newServerData != null && newConnection != null;
                if (canCheckRealm) {
                    this.currentRealmData = this.findRealmData(newConnection);
                    this.isOnRealm = this.currentRealmData != null;
                }
                this.hasCheckedRealm = true;
            }
            if (this.isOnRealm) {
                this.processRealmData(newServerData, newConnection);
            } else {
                this.processServerData(newIntegratedData, newServerData, newConnection);
            }
        }
        if (this.queuedForUpdate) {
            if (!this.hasInitialized) {
                this.initPresence();
                this.hasInitialized = true;
            }
            this.updatePresence();
            this.queuedForUpdate = false;
        }
    }

    private void processData(boolean newLANStatus, boolean newSinglePlayerStatus, IntegratedServer newIntegratedData, ServerData newServerData, NetHandlerPlayClient newConnection, String newServer_IP, String newServer_MOTD, String newServer_Name, int newCurrentPlayers, int newMaxPlayers, List<GuiPlayerInfo> newPlayerList) {
        boolean hasLeftServer;
        boolean isNewServer = newServerData != null && !newServerData.equals(this.currentServerData);
        boolean bl = hasLeftServer = newServerData == null && this.currentServerData != null;
        if (newLANStatus != this.isOnLAN || newSinglePlayerStatus != this.isOnSinglePlayer || newIntegratedData != null && !newIntegratedData.equals(this.currentIntegratedData) || newIntegratedData == null && this.currentIntegratedData != null || isNewServer || hasLeftServer || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty((String)newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty((String)newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
            this.currentServer_IP = newServer_IP;
            if (!newServer_MOTD.equals(this.currentServer_MOTD)) {
                this.currentServer_MOTD = newServer_MOTD;
                this.currentServer_MOTD_Lines = StringUtils.splitTextByNewLine((String)newServer_MOTD);
            }
            this.currentServer_Name = newServer_Name;
            this.currentIntegratedData = newIntegratedData;
            this.currentServerData = newServerData;
            this.currentConnection = newConnection;
            this.isOnLAN = newLANStatus;
            this.isOnSinglePlayer = newSinglePlayerStatus;
            this.queuedForUpdate = true;
            if (isNewServer) {
                this.startPingTask(CraftPresence.CONFIG.serverSettings.pingRateInterval, CraftPresence.CONFIG.serverSettings.pingRateUnit);
            } else if (hasLeftServer) {
                this.stopPingTask();
            }
            if (!StringUtils.isNullOrEmpty((String)this.currentServer_IP)) {
                String string = this.formattedServer_IP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress((String)this.currentServer_IP, (boolean)false) : this.currentServer_IP;
                if (!(this.isOnRealm || this.isOnSinglePlayer || this.isOnLAN)) {
                    if (!this.defaultAddresses.contains(this.formattedServer_IP)) {
                        this.defaultAddresses.add(this.formattedServer_IP);
                    }
                    if (!this.knownAddresses.contains(this.formattedServer_IP)) {
                        this.knownAddresses.add(this.formattedServer_IP);
                    }
                }
            }
            if (this.serverList != null) {
                this.serverList.func_78853_a();
                if (this.serverList.func_78856_c() != this.serverIndex) {
                    this.queueInternalScan();
                }
            }
        }
        if (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers) {
            this.currentPlayers = newCurrentPlayers;
            this.maxPlayers = newMaxPlayers;
            this.queuedForUpdate = true;
        }
        if (!newPlayerList.equals(this.currentPlayerList)) {
            this.currentPlayerList = newPlayerList;
            if (CraftPresence.ENTITIES.isEnabled()) {
                CraftPresence.ENTITIES.ENTITY_NAMES.removeAll(CraftPresence.ENTITIES.PLAYER_BINDINGS.keySet());
                CraftPresence.ENTITIES.queueInternalScan();
            }
        }
    }

    private String getServerAddress(ServerData newServerData) {
        return newServerData != null && !StringUtils.isNullOrEmpty((String)newServerData.field_78845_b) ? newServerData.field_78845_b : "127.0.0.1";
    }

    private String getServerMotd(IntegratedServer newIntegratedData, ServerData newServerData) {
        String result = "";
        if (newServerData != null && newServerData.field_78843_d != null) {
            result = newServerData.field_78843_d;
        } else if (newIntegratedData != null && newIntegratedData.func_71273_Y() != null) {
            result = newIntegratedData.func_71273_Y();
        }
        return !this.isInvalidMotd(result) ? StringUtils.stripAllFormatting((String)result) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
    }

    private void processRealmData(ServerData newServerData, NetHandlerPlayClient newConnection) {
        List newPlayerList = newConnection != null ? StringUtils.newArrayList((Iterable)newConnection.field_147303_b) : StringUtils.newArrayList();
        int newMaxPlayers = 10;
        int newCurrentPlayers = newConnection != null ? newConnection.field_147303_b.size() : 1;
        if (newMaxPlayers < newCurrentPlayers) {
            newMaxPlayers = newCurrentPlayers + 1;
        }
        String newServer_IP = this.getServerAddress(newServerData);
        String newServer_Name = this.currentRealmData.getName();
        String newServer_MOTD = !this.isInvalidMotd(this.currentRealmData.getMotd()) ? StringUtils.stripAllFormatting((String)this.currentRealmData.getMotd()) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
        this.processData(false, false, null, newServerData, newConnection, newServer_IP, newServer_MOTD, newServer_Name, newCurrentPlayers, newMaxPlayers, newPlayerList);
    }

    private void processServerData(IntegratedServer newIntegratedData, ServerData newServerData, NetHandlerPlayClient newConnection) {
        List newPlayerList = newConnection != null ? StringUtils.newArrayList((Iterable)newConnection.field_147303_b) : StringUtils.newArrayList();
        int newCurrentPlayers = newConnection != null ? newConnection.field_147303_b.size() : 1;
        boolean newLANStatus = newIntegratedData != null && newIntegratedData.func_71344_c() || newServerData != null && newServerData.func_152585_d();
        boolean newSinglePlayerStatus = !newLANStatus && CraftPresence.instance.func_71356_B();
        int newMaxPlayers = 0;
        if (newLANStatus) {
            newMaxPlayers = 8;
        } else if (newConnection != null) {
            newMaxPlayers = newConnection.field_147304_c;
        }
        if (newMaxPlayers < newCurrentPlayers) {
            newMaxPlayers = newCurrentPlayers + 1;
        }
        String newServer_IP = this.getServerAddress(newServerData);
        String newServer_Name = newServerData != null && !this.isInvalidName(newServerData.field_78847_a) ? newServerData.field_78847_a : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String newServer_MOTD = this.getServerMotd(newIntegratedData, newServerData);
        this.processData(newLANStatus, newSinglePlayerStatus, newIntegratedData, newServerData, newConnection, newServer_IP, newServer_MOTD, newServer_Name, newCurrentPlayers, newMaxPlayers, newPlayerList);
    }

    private boolean isInvalidData(String input, List<String> invalidItems) {
        if (!StringUtils.isNullOrEmpty((String)input)) {
            for (String item : invalidItems) {
                if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item) || !input.equalsIgnoreCase(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isInvalidMotd(String serverMotd) {
        return this.isInvalidData(serverMotd, invalidMotds);
    }

    private boolean isInvalidName(String serverName) {
        return this.isInvalidData(serverName, invalidNames);
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID;
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty((String)this.currentServer_Name)) {
            formattedKey = ServerUtils.jvmdowngrader$concat$makeSecret$1(formattedKey, this.currentServer_Name);
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty((String)this.currentServer_IP)) {
            formattedKey = ServerUtils.jvmdowngrader$concat$makeSecret$1(formattedKey, this.currentServer_IP);
            containsServerIP = true;
        }
        formattedKey = ServerUtils.jvmdowngrader$concat$makeSecret$1(formattedKey, containsServerName, containsServerIP);
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        Object[] boolParts = secret.split(";");
        Object[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists((Object[])stringParts, (int)0) && ((String)stringParts[0]).length() >= 18 && (Boolean)StringUtils.getValidLong((String)stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists((Object[])boolParts, (int)1) && StringUtils.elementExists((Object[])stringParts, (int)1) && Boolean.parseBoolean((String)boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists((Object[])boolParts, (int)2) && StringUtils.elementExists((Object[])stringParts, (int)2) && Boolean.parseBoolean((String)boolParts[2]);
        Object serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            ModUtils.executeOnMainThread((Minecraft)CraftPresence.instance, () -> this.lambda$verifyAndJoin$0((String)serverName, serverIP));
        } else {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.join", new Object[]{secret}), new Object[0]);
        }
        CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
    }

    private void pingServer(ServerData serverData, Runnable saver, Runnable callback) {
        Runnable callbackEvent;
        if (serverData == null) {
            return;
        }
        Runnable saverEvent = saver != null ? saver : () -> {};
        Runnable runnable = callbackEvent = callback != null ? callback : () -> {};
        if (!serverData.field_78841_f) {
            serverData.field_78841_f = true;
            serverData.field_78844_e = -2L;
            serverData.field_78843_d = "";
            serverData.field_78846_c = "";
        }
        PING_EXECUTOR.submit(() -> {
            try {
                String iconData = serverData.func_147409_e();
                this.pinger.func_147224_a(serverData);
                if (!Objects.equals(iconData, serverData.func_147409_e())) {
                    saverEvent.run();
                }
                callbackEvent.run();
            }
            catch (Exception ex) {
                serverData.field_78844_e = -1L;
                serverData.field_78843_d = ex instanceof UnknownHostException ? "\u00a74Can't resolve hostname" : "\u00a74Can't connect to server.";
                callbackEvent.run();
            }
        });
    }

    private void pingServer(Runnable saver, Runnable callback) {
        this.pingServer(this.currentServerData, saver, callback);
    }

    private void pingServer(ServerData serverData, Runnable callback) {
        this.pingServer(serverData, null, callback);
    }

    private void pingServer(Runnable callback) {
        this.pingServer(this.currentServerData, callback);
    }

    private void pingServer(ServerData serverData) {
        this.pingServer(serverData, null);
    }

    private void pingServer() {
        this.pingServer(this.currentServerData);
    }

    private void startPingTask(int interval, String unit) {
        TimeUnit timeUnit;
        this.stopPingTask();
        if (interval <= 0) {
            return;
        }
        try {
            timeUnit = TimeUtils.getTimeUnitFrom((String)unit);
        }
        catch (Exception ex) {
            timeUnit = TimeUnit.MINUTES;
        }
        this.PING_SCHEDULER = Executors.newScheduledThreadPool(1);
        this.PING_SCHEDULER.scheduleAtFixedRate(this::pingServer, 0L, interval, timeUnit);
    }

    private void stopPingTask() {
        if (this.PING_SCHEDULER != null && !this.PING_SCHEDULER.isShutdown()) {
            this.PING_SCHEDULER.shutdown();
        }
    }

    private void joinServer(ServerData serverData) {
        try {
            GuiScreen currentScreen;
            this.pingServer(serverData);
            if (CraftPresence.player != null) {
                CraftPresence.world.func_72882_A();
                CraftPresence.instance.func_71403_a(null);
            }
            RenderUtils.openScreen((Minecraft)CraftPresence.instance, (GuiScreen)new GuiConnecting((GuiScreen)((currentScreen = GameUtils.getCurrentScreen((Minecraft)CraftPresence.instance)) != null ? currentScreen : new GuiMainMenu()), CraftPresence.instance, serverData));
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    @Override
    public void initPresence() {
        this.syncArgument("player.position.x", () -> MathUtils.roundDouble((double)CraftPresence.player.field_70165_t, (int)3));
        this.syncArgument("player.position.y", () -> MathUtils.roundDouble((double)CraftPresence.player.field_70163_u, (int)3));
        this.syncArgument("player.position.z", () -> MathUtils.roundDouble((double)CraftPresence.player.field_70161_v, (int)3));
        this.syncArgument("player.health.current", () -> MathUtils.roundDouble((double)CraftPresence.player.func_110143_aJ(), (int)0));
        this.syncArgument("player.health.max", () -> MathUtils.roundDouble((double)CraftPresence.player.func_110138_aP(), (int)0));
        this.syncArgument("world.difficulty", () -> {
            String newDifficulty = CraftPresence.world.func_72912_H().func_76093_s() && ModUtils.RAW_TRANSLATOR != null ? ModUtils.RAW_TRANSLATOR.translate("selectWorld.gameMode.hardcore", new Object[0]) : StringUtils.formatWord((String)CraftPresence.world.field_73013_u.name().toLowerCase());
            return StringUtils.getOrDefault((String)newDifficulty);
        });
        this.syncArgument("world.weather.name", () -> {
            String newWeatherData = WorldUtils.getWeather((Entity)CraftPresence.player);
            String newWeatherName = Constants.TRANSLATOR.translate(ServerUtils.jvmdowngrader$concat$lambda$initPresence$10$1(newWeatherData), new Object[0]);
            return StringUtils.getOrDefault((String)newWeatherName);
        });
        this.syncArgument("world.name", () -> {
            String primaryWorldName = CraftPresence.instance.func_71401_C() != null ? CraftPresence.instance.func_71401_C().func_71221_J() : "";
            String secondaryWorldName = StringUtils.getOrDefault((String)CraftPresence.world.func_72912_H().func_76065_j(), (String)Constants.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0]));
            String newWorldName = StringUtils.getOrDefault((String)primaryWorldName, (String)secondaryWorldName);
            return StringUtils.getOrDefault((String)newWorldName);
        });
        this.syncArgument("world.time.day", () -> TimeUtils.fromWorldTime((long)CraftPresence.world.func_72820_D()).getFirst());
        this.syncArgument("world.time.format_24", () -> TimeUtils.toString((TemporalAccessor)((TemporalAccessor)TimeUtils.fromWorldTime((long)CraftPresence.world.func_72820_D()).getSecond()), (String)"HH:mm"), true);
        this.syncArgument("world.time.format_12", () -> TimeUtils.toString((TemporalAccessor)((TemporalAccessor)TimeUtils.fromWorldTime((long)CraftPresence.world.func_72820_D()).getSecond()), (String)"HH:mm a"), true);
        this.syncArgument("data.world.time.instance", () -> TimeUtils.fromWorldTime((long)CraftPresence.world.func_72820_D()));
        this.syncArgument("server.default.icon", () -> CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        this.syncArgument("server.message", () -> {
            boolean inServer;
            boolean bl = inServer = !this.isOnRealm && !this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null);
            if (inServer) {
                if (this.isOnLAN) {
                    ModuleData primaryData = CraftPresence.CONFIG.statusMessages.lanData;
                    return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
                }
                ModuleData defaultData = this.getDefaultData();
                ModuleData alternateData = this.getData(this.currentServer_Name);
                ModuleData primaryData = this.getData(this.formattedServer_IP);
                String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                String alternateMessage = Config.isValidProperty(alternateData, "textOverride") ? alternateData.getTextOverride() : defaultMessage;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : alternateMessage, this.formattedServer_IP, this.currentServer_Name);
            }
            if (this.isOnSinglePlayer) {
                ModuleData primaryData = CraftPresence.CONFIG.statusMessages.singleplayerData;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
            }
            if (this.isOnRealm) {
                ModuleData primaryData = CraftPresence.CONFIG.statusMessages.realmData;
                return this.getResult(Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : "", primaryData);
            }
            return null;
        });
        this.syncArgument("server.icon", () -> {
            boolean inServer = !this.isOnRealm && !this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null);
            String currentServerIcon = "";
            ModuleData resultData = null;
            if (inServer) {
                if (this.isOnLAN) {
                    resultData = CraftPresence.CONFIG.statusMessages.lanData;
                    currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
                } else {
                    ModuleData defaultData = this.getDefaultData();
                    ModuleData alternateData = this.getData(this.currentServer_Name);
                    ModuleData primaryData = this.getData(this.formattedServer_IP);
                    resultData = this.getOrDefault(primaryData, alternateData);
                    String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : "";
                    String alternateIcon = Config.isValidProperty(alternateData, "iconOverride") ? alternateData.getIconOverride() : defaultIcon;
                    String string = currentServerIcon = Config.isValidProperty(primaryData, "iconOverride") ? primaryData.getIconOverride() : alternateIcon;
                    if (StringUtils.isNullOrEmpty((String)currentServerIcon)) {
                        currentServerIcon = CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, this.formattedServer_IP, true) ? this.formattedServer_IP : this.currentServer_Name;
                    }
                }
            } else if (this.isOnSinglePlayer) {
                resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
                currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            } else if (this.isOnRealm) {
                resultData = CraftPresence.CONFIG.statusMessages.realmData;
                String string = currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
                if (StringUtils.isNullOrEmpty((String)currentServerIcon)) {
                    String originalName = this.currentRealmData.owner;
                    boolean isValidUuid = StringUtils.isValidUuid((String)originalName);
                    if (!CraftPresence.CONFIG.hasChanged() && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty((String)CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                        return CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair((Object)"player.name", () -> originalName), new Pair((Object)"player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid((String)originalName, (boolean)false) : ""), new Pair((Object)"player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid((String)originalName, (boolean)true) : "")).get().toString();
                    }
                }
            }
            return this.getResult(CraftPresence.CLIENT.imageOf(true, currentServerIcon, CraftPresence.CONFIG.serverSettings.fallbackServerIcon), resultData);
        });
        CraftPresence.CLIENT.addForcedData("server", () -> {
            if (!this.isInUse()) {
                return null;
            }
            ModuleData resultData = null;
            if (!(this.isOnRealm || this.isOnSinglePlayer || !this.isOnLAN && this.currentServerData == null)) {
                resultData = this.isOnLAN ? CraftPresence.CONFIG.statusMessages.lanData : this.getOrDefault(this.formattedServer_IP, this.currentServer_Name);
            } else if (this.isOnSinglePlayer) {
                resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            } else if (this.isOnRealm) {
                resultData = CraftPresence.CONFIG.statusMessages.realmData;
            }
            return this.getPresenceData(resultData);
        });
        CraftPresence.CLIENT.syncTimestamp("data.server.time");
    }

    private void initServerArgs() {
        this.syncArgument("server.players.current", () -> this.currentPlayers);
        this.syncArgument("server.players.max", () -> this.maxPlayers);
        this.syncArgument("server.address.full", () -> this.currentServer_IP);
        this.syncArgument("server.address.short", () -> this.formattedServer_IP);
        this.syncArgument("server.name", () -> this.currentServer_Name);
        this.syncArgument("server.motd.raw", () -> this.currentServer_MOTD);
        if (!this.currentServer_MOTD_Lines.isEmpty()) {
            for (int i = 0; i < this.currentServer_MOTD_Lines.size(); ++i) {
                int index = i + 1;
                this.syncArgument(ServerUtils.jvmdowngrader$concat$initServerArgs$1(index), () -> this.currentServer_MOTD_Lines.get(index));
            }
        }
    }

    private void initRealmArgs() {
        this.syncArgument("server.minigame", () -> "");
    }

    @Override
    public void updatePresence() {
        if (!this.isOnSinglePlayer && (this.isOnLAN || this.currentServerData != null)) {
            if (!this.hasInitializedServer) {
                this.initServerArgs();
                this.hasInitializedServer = true;
            }
            if (this.isOnRealm && !this.hasInitializedRealm) {
                this.initRealmArgs();
                this.hasInitializedRealm = true;
            }
            if (!this.isOnRealm && !this.isOnLAN && CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty((String)this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.serverSettings.fallbackServerName) ? ServerUtils.jvmdowngrader$concat$updatePresence$1(this.currentServer_Name) : ServerUtils.jvmdowngrader$concat$updatePresence$1(this.currentServer_IP);
                CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
            }
        }
    }

    @Override
    public void getInternalData() {
        try {
            if (this.serverList == null) {
                this.serverList = new ServerList(CraftPresence.instance);
                this.serverList.func_78853_a();
            }
            this.serverIndex = this.serverList.func_78856_c();
            for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                String formattedIP;
                ServerData data = this.serverList.func_78850_a(currentIndex);
                if (StringUtils.isNullOrEmpty((String)data.field_78845_b)) continue;
                String string = formattedIP = data.field_78845_b.contains(":") ? StringUtils.formatAddress((String)data.field_78845_b, (boolean)false) : data.field_78845_b;
                if (!this.defaultAddresses.contains(formattedIP)) {
                    this.defaultAddresses.add(formattedIP);
                }
                if (!this.knownAddresses.contains(formattedIP)) {
                    this.knownAddresses.add(formattedIP);
                }
                if (this.knownServerData.containsKey(data.field_78845_b)) continue;
                this.knownServerData.put(data.field_78845_b, data);
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    @Override
    public void getConfigData() {
        for (String serverEntry : CraftPresence.CONFIG.serverSettings.serverData.keySet()) {
            if (StringUtils.isNullOrEmpty((String)serverEntry) || this.knownAddresses.contains(serverEntry)) continue;
            this.knownAddresses.add(serverEntry);
        }
    }

    @Override
    public void syncArgument(String argumentName, Supplier<Boolean> condition, Supplier<Object> event, boolean plain) {
        CraftPresence.CLIENT.syncArgument(argumentName, this.getModuleFunction(condition, event), plain);
    }

    @Override
    public ModuleData getData(String key) {
        return CraftPresence.CONFIG.serverSettings.serverData.get(key);
    }

    @Override
    public String getOverrideText(ModuleData data) {
        return CraftPresence.CLIENT.getOverrideText(this.getPresenceData(data));
    }

    @Override
    public boolean hasScannedInternals() {
        return this.hasScannedInternals;
    }

    @Override
    public void setScannedInternals(boolean state) {
        this.hasScannedInternals = state;
    }

    @Override
    public boolean canFetchConfig() {
        return CraftPresence.CONFIG != null;
    }

    @Override
    public boolean hasScannedConfig() {
        return this.hasScannedConfig;
    }

    @Override
    public void setScannedConfig(boolean state) {
        this.hasScannedConfig = state;
    }

    @Override
    public boolean canBeEnabled() {
        return !CraftPresence.CONFIG.hasChanged() ? CraftPresence.CONFIG.generalSettings.detectWorldData : this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean canBeUsed() {
        return CraftPresence.player != null && !this.joinInProgress;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    public ServerData getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }

    private /* synthetic */ void lambda$verifyAndJoin$0(String serverName, String serverIP) {
        this.joinServer(new ServerData(serverName, serverIP, false));
    }

    private static String jvmdowngrader$concat$makeSecret$1(String string, String string2) {
        return string + "-" + string2;
    }

    private static String jvmdowngrader$concat$makeSecret$1(String string, boolean bl, boolean bl2) {
        return string + ";" + bl + ";" + bl2;
    }

    private static String jvmdowngrader$concat$initServerArgs$1(int n) {
        return "data.server.motd.line_" + n;
    }

    private static String jvmdowngrader$concat$updatePresence$1(String string) {
        return "Join Server: " + string;
    }

    private static String jvmdowngrader$concat$lambda$initPresence$10$1(String string) {
        return "craftpresence.defaults.weather." + string;
    }
}

