/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.external.net.lenni0451.reflect.proxy.internal;

import craftpresence.external.net.lenni0451.reflect.Methods;
import craftpresence.external.net.lenni0451.reflect.bytecode.BytecodeUtils;
import craftpresence.external.net.lenni0451.reflect.proxy.impl.Proxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ProxyUtils {
    public static void verifySuperClass(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("The super class must be public");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("The super class must be a class");
        }
        if (Modifier.isFinal(clazz.getModifiers())) {
            throw new IllegalArgumentException("The super class must not be final");
        }
    }

    public static void verifyInterface(Class<?> clazz) {
        if (clazz == Proxy.class) {
            throw new IllegalArgumentException("The 'Proxy' interface is not allowed as interface");
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("The interface must be public");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("The interface must be an interface");
        }
    }

    public static Constructor<?>[] getPublicConstructors(Class<?> clazz) {
        ArrayList constructors = new ArrayList();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (Modifier.isPrivate(constructor.getModifiers())) continue;
            constructors.add(constructor);
        }
        return constructors.toArray(new Constructor[0]);
    }

    public static Method[] getOverridableMethod(Class<?> superClass, Class<?>[] interfaces, Predicate<Method> filter) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        if (superClass != null) {
            ProxyUtils.getOverridableMethod(superClass, methods);
        }
        if (interfaces != null) {
            for (Class<?> inter : interfaces) {
                ProxyUtils.getOverridableMethod(inter, methods);
            }
        }
        return (Method[])methods.values().stream().filter(filter).toArray(Method[]::new);
    }

    public static void getOverridableMethod(Class<?> clazz, Map<String, Method> methods) {
        if (clazz == Proxy.class) {
            return;
        }
        for (Method method : Methods.getDeclaredMethods(clazz)) {
            if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || Modifier.isNative(method.getModifiers())) continue;
            methods.putIfAbsent(method.getName() + BytecodeUtils.desc(method), method);
        }
        if (clazz.getSuperclass() != null) {
            ProxyUtils.getOverridableMethod(clazz.getSuperclass(), methods);
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            ProxyUtils.getOverridableMethod(genericDeclaration, methods);
        }
    }

    public static Method[] mapMethods(Method[] methods, Function<Method, Method> methodMapper) {
        Method[] originalMethods = new Method[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Method mappedMethod = methodMapper.apply(method);
            if (mappedMethod == null || method.equals(mappedMethod)) continue;
            if (!method.getName().equals(mappedMethod.getName())) {
                throw new IllegalArgumentException(String.format("Method '%s' has mismatching name (%1$s != %s)", method.getName(), mappedMethod.getName()));
            }
            if (!Arrays.equals(method.getParameterTypes(), mappedMethod.getParameterTypes())) {
                String originalParameters = Arrays.stream(method.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", "));
                String mappedParameters = Arrays.stream(mappedMethod.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(", "));
                throw new IllegalArgumentException(String.format("Method '%s' has mismatching parameter types (%s != %s)", mappedMethod.getName(), originalParameters, mappedParameters));
            }
            if (method.getReturnType() != mappedMethod.getReturnType()) {
                throw new IllegalArgumentException(String.format("Method '%s' has mismatching return type (%s != %s)", mappedMethod.getName(), method.getReturnType().getSimpleName(), mappedMethod.getReturnType().getSimpleName()));
            }
            if (!mappedMethod.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
                throw new IllegalArgumentException(String.format("Declaring class of method '%s' is not assignable from original declaring class (%s != %s)", mappedMethod.getName(), mappedMethod.getDeclaringClass().getName(), method.getDeclaringClass().getName()));
            }
            methods[i] = mappedMethod;
            originalMethods[i] = method;
        }
        return originalMethods;
    }
}

