/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.bartworksHandler;

import bartworks.system.material.Werkstoff;
import bwcrossmod.galacticgreg.VoidMinerUtility;
import com.dreammaster.bartworksHandler.BartWorksMaterials;
import com.dreammaster.main.MainRegistry;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.ISubTagContainer;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT_Ore_Layer;
import gtPlusPlus.everglades.gen.gt.WorldGen_Ores;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VoidMinerLoader {
    protected static final Logger log = LogManager.getLogger(VoidMinerLoader.class);
    private static final int DEEPDARK_ID = 100;

    private VoidMinerLoader() {
    }

    private static boolean hasOres(Materials materials) {
        return (materials.mTypes & 8) != 0 && materials.mMetaItemSubID > 0 && materials.mHasParentMod;
    }

    private static boolean hasOres(Werkstoff werkstoff) {
        return werkstoff.hasItemType(OrePrefixes.ore) && werkstoff.getmID() > 0;
    }

    private static void addVoidDimerDrops(ISubTagContainer materials, float weight) {
        if (weight <= 0.0f) {
            return;
        }
        BartWorksMaterials.addVoidMinerDropsToDimension(100, materials, weight);
    }

    private static void addVoidDimerDrops(Material material, float weight) {
        if (weight <= 0.0f) {
            return;
        }
        VoidMinerUtility.addBlockToDimensionList((int)100, (Block)material.getOreBlock(1), (int)0, (float)weight);
    }

    public static void initDeepDark() {
        Map materials = Arrays.stream(Materials.values()).filter(VoidMinerLoader::hasOres).collect(Collectors.toMap(Materials::toString, Function.identity(), VoidMinerLoader::keyConflict, HashMap::new));
        Map werkstoff = Werkstoff.werkstoffHashSet.stream().filter(VoidMinerLoader::hasOres).collect(Collectors.toMap(Werkstoff::getDefaultName, Function.identity(), VoidMinerLoader::keyConflict, HashMap::new));
        HashMap<String, Material> GTPPMaterials = new HashMap<String, Material>();
        for (WorldGen_GT_Ore_Layer t : WorldGen_Ores.validOreveins.values()) {
            GTPPMaterials.put(t.mPrimary.getLocalizedName(), t.mPrimary);
            GTPPMaterials.put(t.mSecondary.getLocalizedName(), t.mSecondary);
            GTPPMaterials.put(t.mBetween.getLocalizedName(), t.mBetween);
            GTPPMaterials.put(t.mSporadic.getLocalizedName(), t.mSporadic);
        }
        if (MainRegistry.CoreConfig.DebugPrintAllOres) {
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAllOres]: Begin all materials list");
            log.info("==========");
            materials.keySet().stream().sorted().forEach(name -> log.info("  " + name));
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAllOres]: End all materials list");
            log.info("==========");
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAllOres]: Begin all werkstoff list");
            log.info("==========");
            werkstoff.keySet().stream().sorted().forEach(name -> log.info("  " + name));
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAllOres]: End all werkstoff list");
            log.info("==========");
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAllOres]: Begin all GT++ material list");
            log.info("==========");
            GTPPMaterials.keySet().stream().sorted().forEach(name -> log.info("  " + name));
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAllOres]: End all GT++ material list");
            log.info("==========");
        }
        Map materialWeights = materials.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> Float.valueOf(1.0f), VoidMinerLoader::keyConflict, HashMap::new));
        Map werkstoffWeights = werkstoff.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> Float.valueOf(1.0f), VoidMinerLoader::keyConflict, HashMap::new));
        Map GTPPMaterialWeights = GTPPMaterials.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> Float.valueOf(1.0f), VoidMinerLoader::keyConflict, HashMap::new));
        Arrays.stream(MainRegistry.CoreConfig.MaterialWeights).forEach(line -> VoidMinerLoader.parseWeight(line, materialWeights));
        Arrays.stream(MainRegistry.CoreConfig.WerkstoffWeights).forEach(line -> VoidMinerLoader.parseWeight(line, werkstoffWeights));
        Arrays.stream(MainRegistry.CoreConfig.GTPPMaterialWeights).forEach(line -> VoidMinerLoader.parseWeight(line, GTPPMaterialWeights));
        Map addedMaterials = Maps.filterKeys((Map)materials, name -> ((Float)materialWeights.get(name)).floatValue() > 0.0f);
        Map addedWerkstoff = Maps.filterKeys((Map)werkstoff, name -> ((Float)werkstoffWeights.get(name)).floatValue() > 0.0f);
        Map addedGTPPMaterial = Maps.filterKeys(GTPPMaterials, name -> ((Float)GTPPMaterialWeights.get(name)).floatValue() > 0.0f);
        if (MainRegistry.CoreConfig.DebugPrintAddedOres) {
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: Begin added materials list");
            log.info("==========");
            addedMaterials.keySet().stream().sorted().forEach(name -> log.info("  {} (weight: {} / metadata: {})", new Object[]{name, materialWeights.get(name), ((Materials)materials.get((Object)name)).mMetaItemSubID}));
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: End added materials list");
            log.info("==========");
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: Begin added werkstoff list");
            log.info("==========");
            addedWerkstoff.keySet().stream().sorted().forEach(name -> log.info("  {} (weight: {} / metadata: {})", new Object[]{name, werkstoffWeights.get(name), ((Werkstoff)werkstoff.get(name)).getmID()}));
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: End added werkstoff list");
            log.info("==========");
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: Begin added GT++ material list");
            log.info("==========");
            addedGTPPMaterial.keySet().stream().sorted().forEach(name -> log.info("  {} (weight: {} / block id: {})", new Object[]{name, GTPPMaterialWeights.get(name), GameRegistry.findUniqueIdentifierFor((Block)((Material)GTPPMaterials.get(name)).getOreBlock(1))}));
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: End added GT++ material list");
            log.info("==========");
            double totalWeight = Stream.concat(Stream.concat(materialWeights.values().stream(), werkstoffWeights.values().stream()), GTPPMaterialWeights.values().stream()).filter(f -> f.floatValue() > 0.0f).mapToDouble(f -> f.floatValue()).sum();
            log.info("==========");
            log.info("[DeepDarkVoidMiner/DebugPrintAddedOres]: Total weight: {}", new Object[]{totalWeight});
            log.info("==========");
        }
        addedMaterials.forEach((k, v) -> VoidMinerLoader.addVoidDimerDrops((ISubTagContainer)v, ((Float)materialWeights.get(k)).floatValue()));
        addedWerkstoff.forEach((k, v) -> VoidMinerLoader.addVoidDimerDrops((ISubTagContainer)v, ((Float)werkstoffWeights.get(k)).floatValue()));
        addedGTPPMaterial.forEach((k, v) -> VoidMinerLoader.addVoidDimerDrops(v, ((Float)GTPPMaterialWeights.get(k)).floatValue()));
    }

    private static void parseWeight(String line, Map<String, Float> weights) {
        float weight;
        String[] pieces = line.split(":");
        if (pieces.length != 2) {
            log.error("Malformed weight config: \"{}\"", new Object[]{line});
            return;
        }
        try {
            weight = Float.parseFloat(pieces[1]);
        }
        catch (NumberFormatException e) {
            log.error("Unable to parse weight: \"{}\"", new Object[]{line});
            return;
        }
        if (Float.isNaN(weight) || Float.isInfinite(weight)) {
            log.error("Invalid weight: \"{}\"", new Object[]{line});
            return;
        }
        weights.put(pieces[0].trim(), Float.valueOf(weight));
    }

    private static <T> T keyConflict(T a, T b) {
        throw new IllegalStateException(String.format("Got a name conflict: [%s], [%s]", a, b));
    }
}

