/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.nei.rocket;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import galaxyspace.core.nei.NEIGalaxySpaceConfig;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RocketT3RecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation rocketGuiTexture = new ResourceLocation("galaxyspace", "textures/gui/schematic_rocket_GS1_T3.png");
    public static final int x = -1;
    public static final int y = -8;
    public static final int tX = 3;
    public static final int tY = 4;
    public static final int w = 168;
    public static final int h = 140;

    public String getRecipeId() {
        return "galacticraft.rocketT3";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalaxySpaceConfig.getRocketBenchT3Recipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry entry : stack.getKey().entrySet()) {
                inputStacks.add((PositionedStack)entry.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)rocketGuiTexture);
        GuiDraw.drawTexturedModalRect((int)-1, (int)-8, (int)3, (int)4, (int)168, (int)140);
    }

    public void drawExtras(int i) {
    }

    public void onUpdate() {
        super.onUpdate();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(0, 0, 40, 40), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedRocketRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedRocketRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)pstack.item)) continue;
                this.arecipes.add(new CachedRocketRecipe(irecipe));
            }
        }
    }

    public String getRecipeName() {
        return EnumColor.INDIGO + "NASA Workbench";
    }

    public String getGuiTexture() {
        return "galaxyspacetextures/gui/schematic_rocket_GS1_T3.png";
    }

    public void drawForeground(int recipe) {
    }

    public class CachedRocketRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedRocketRecipe(ArrayList<PositionedStack> input, PositionedStack output) {
            super((TemplateRecipeHandler)RocketT3RecipeHandler.this);
            this.input = input;
            this.output = output;
        }

        public CachedRocketRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

