/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.CollapsibleItems;
import codechicken.nei.ItemHistoryPanel;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PanelWidget;
import codechicken.nei.guihook.GuiContainerManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class ItemPanel
extends PanelWidget {
    @Deprecated
    private int itemsPerPage = 0;
    @Deprecated
    public static ArrayList<ItemStack> items = new ArrayList();
    @Deprecated
    public ArrayList<ItemStack> realItems = new ArrayList();
    public Button more;
    public Button less;
    public ItemQuantityField quantity;
    public ItemHistoryPanel historyPanel;
    public Button toggleGroups;

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        return super.getStackMouseOver(mousex, mousey);
    }

    public ItemPanel() {
        this.grid = new ItemPanelGrid();
    }

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        ((ItemPanelGrid)ItemPanels.itemPanel.getGrid()).setItems(newItems);
        ItemPanels.itemPanel.realItems = newItems;
    }

    @Override
    public void init() {
        super.init();
        this.toggleGroups = new Button("G"){

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("itempanel.collapsed.button.tip", new Object[0]);
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                CollapsibleItems.toggleGroups(rightclick ? Boolean.valueOf(false) : null);
                ItemList.updateFilter.restart();
                return true;
            }
        };
        this.more = new Button("+"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? 64 : (NEIClientUtils.shiftKey() ? 10 : 1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                ItemPanels.itemPanel.quantity.setText(Integer.toString(quantity));
                return true;
            }
        };
        this.less = new Button("-"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                int modifier = NEIClientUtils.controlKey() ? -64 : (NEIClientUtils.shiftKey() ? -10 : -1);
                int quantity = NEIClientConfig.getItemQuantity() + modifier;
                if (quantity < 0) {
                    quantity = 0;
                }
                ItemPanels.itemPanel.quantity.setText(Integer.toString(quantity));
                return true;
            }
        };
        this.quantity = new ItemQuantityField("quantity");
        this.historyPanel = new ItemHistoryPanel();
    }

    @Deprecated
    public void scroll(int i) {
        this.grid.shiftPage(i);
    }

    @Override
    public String getLabelText() {
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.items";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return (gui.field_146294_l + gui.field_146999_f) / 2 + 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        int marginTop = super.resizeHeader(gui);
        this.toggleGroups.w = this.pageNext.w;
        this.toggleGroups.h = this.pageNext.h;
        this.toggleGroups.y = this.pageNext.y;
        this.toggleGroups.x = this.pageNext.x - this.toggleGroups.w - 2;
        return marginTop;
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        if (!NEIClientConfig.showItemQuantityWidget() && NEIClientConfig.isSearchWidgetCentered() && !NEIClientConfig.showHistoryPanelWidget()) {
            return 0;
        }
        int BUTTON_SIZE = 20;
        this.less.w = 20;
        this.more.w = 20;
        this.quantity.h = 20;
        if (NEIClientConfig.isSearchWidgetCentered()) {
            this.less.h = 20;
            this.more.h = 20;
            this.more.x = this.x + this.w - 20;
            this.less.y = this.quantity.y = this.y + this.h - 20;
            this.more.y = this.quantity.y;
            this.less.x = this.x;
            this.quantity.x = this.x + 20 + 2;
            this.quantity.w = this.more.x - this.quantity.x - 2;
        } else {
            this.quantity.x = (int)((double)this.x + (double)this.w * 0.7) + 3;
            this.quantity.y = this.y + this.h - 20;
            this.quantity.w = (int)((double)this.w * 0.3 - 20.0 - 1.0);
            this.less.h = 10;
            this.more.h = 10;
            this.more.y = this.y + this.h - this.more.h * 2;
            this.less.x = this.more.x = this.quantity.x + this.quantity.w;
            this.less.y = this.more.y + this.more.h;
        }
        if (NEIClientConfig.showHistoryPanelWidget()) {
            this.historyPanel.x = this.x;
            this.historyPanel.w = this.w;
            this.historyPanel.h = 18 * NEIClientConfig.getIntSetting("inventory.history.useRows");
            if (NEIClientConfig.showItemQuantityWidget() || !NEIClientConfig.isSearchWidgetCentered()) {
                this.historyPanel.y = this.quantity.y - this.historyPanel.h - 2;
                return this.quantity.h + this.historyPanel.h + 4;
            }
            this.historyPanel.y = this.y + this.h - this.historyPanel.h;
            return this.historyPanel.h + 2;
        }
        return this.quantity.h + 2;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (this.grid.getPerPage() > 0) {
            if (NEIClientConfig.showItemQuantityWidget()) {
                LayoutManager.addWidget(this.more);
                LayoutManager.addWidget(this.less);
                LayoutManager.addWidget(this.quantity);
            }
            if (!CollapsibleItems.isEmpty()) {
                LayoutManager.addWidget(this.toggleGroups);
            }
            if (NEIClientConfig.showHistoryPanelWidget()) {
                LayoutManager.addWidget(this.historyPanel);
            }
        }
    }

    @Override
    public void resize(GuiContainer gui) {
        super.resize(gui);
        this.historyPanel.resize(gui);
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack != null) {
            int amount;
            int n = amount = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
            return NEIServerUtils.copyStack(stack, amount);
        }
        return null;
    }

    @Override
    public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        MaskMetadata metadata;
        ItemPanelSlot hoverSlot;
        ItemPanelGrid panelGrid = (ItemPanelGrid)this.grid;
        if (!(panelGrid.forceExpand || NEIClientConfig.isHidden() || currenttip.isEmpty() || (hoverSlot = this.getSlotMouseOver(mousex, mousey)) == null || (metadata = panelGrid.maskMetadata.get(hoverSlot.slotIndex)) == null)) {
            List<ItemStack> items = panelGrid.groupItems.get(metadata.groupIndex);
            if (NEIClientConfig.getBooleanSetting("inventory.collapsibleItems.customName") && !metadata.extended && !"".equals(metadata.displayName)) {
                currenttip.clear();
                currenttip.add(metadata.displayName + "\u00a7h");
            }
            if (items != null && items.size() > 1) {
                String message = metadata.extended ? "itempanel.collapsed.hint.collapse" : "itempanel.collapsed.hint.expand";
                currenttip.add(1, EnumChatFormatting.GRAY + NEIClientUtils.translate(message, items.size()) + EnumChatFormatting.RESET);
            }
        }
        return super.handleItemTooltip(gui, itemstack, mousex, mousey, currenttip);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        MaskMetadata metadata;
        ItemPanelSlot hoverSlot;
        ItemPanelGrid panelGrid = (ItemPanelGrid)this.grid;
        if (NEIClientUtils.altKey() && button == 0 && !panelGrid.forceExpand && (hoverSlot = this.grid.getSlotMouseOver(mousex, mousey)) != null && (metadata = panelGrid.maskMetadata.get(hoverSlot.slotIndex)) != null) {
            CollapsibleItems.setExpanded(metadata.groupIndex, !metadata.extended);
            panelGrid.setItems(panelGrid.rawItems);
            return true;
        }
        return super.handleClick(mousex, mousey, button);
    }

    protected static class ItemPanelGrid
    extends ItemsGrid {
        public ArrayList<ItemStack> newItems;
        public ArrayList<ItemStack> rawItems;
        protected final HashMap<Integer, List<ItemStack>> groupItems = new HashMap();
        protected final HashMap<Integer, MaskMetadata> maskMetadata = new HashMap();
        protected boolean forceExpand = false;

        protected ItemPanelGrid() {
        }

        public void setItems(ArrayList<ItemStack> items) {
            this.newItems = items;
        }

        @Override
        public void refresh(GuiContainer gui) {
            if (this.newItems != null) {
                this.groupItems.clear();
                this.forceExpand = false;
                if (!CollapsibleItems.isEmpty() && !this.newItems.isEmpty()) {
                    HashSet<Integer> groups = new HashSet<Integer>();
                    boolean outsideGroup = false;
                    this.realItems = new ArrayList();
                    this.rawItems = new ArrayList<ItemStack>(this.newItems);
                    for (ItemStack stack : this.newItems) {
                        int groupIndex = CollapsibleItems.getGroupIndex(stack);
                        if (groupIndex == -1) {
                            this.realItems.add(stack);
                            outsideGroup = true;
                            continue;
                        }
                        if (!groups.contains(groupIndex) || CollapsibleItems.isExpanded(groupIndex)) {
                            this.realItems.add(stack);
                            groups.add(groupIndex);
                        }
                        if (!this.groupItems.containsKey(groupIndex)) {
                            this.groupItems.put(groupIndex, new ArrayList());
                        }
                        this.groupItems.get(groupIndex).add(stack);
                    }
                    if (!outsideGroup && groups.size() == 1) {
                        this.realItems = new ArrayList<ItemStack>(this.newItems);
                        this.forceExpand = true;
                    }
                } else {
                    this.realItems = new ArrayList<ItemStack>(this.newItems);
                }
                this.newItems = null;
                this.onItemsChanged();
            }
            super.refresh(gui);
        }

        @Override
        protected List<Integer> getMask() {
            boolean updateBorders = this.gridMask == null;
            List<Integer> mask = super.getMask();
            if (updateBorders) {
                this.calculateGroupBorders(mask);
            }
            return mask;
        }

        protected void calculateGroupBorders(List<Integer> mask) {
            int idx;
            int slotIndex;
            this.maskMetadata.clear();
            if (mask.isEmpty() || this.groupItems.isEmpty()) {
                return;
            }
            HashMap<Integer, Integer> maskGroup = new HashMap<Integer, Integer>();
            Color collapsedColor = new Color(NEIClientConfig.getSetting("inventory.collapsibleItems.collapsedColor").getHexValue(), true);
            Color expandedColor = new Color(NEIClientConfig.getSetting("inventory.collapsibleItems.expandedColor").getHexValue(), true);
            for (slotIndex = 0; slotIndex < mask.size(); ++slotIndex) {
                if (mask.get(slotIndex) == null) continue;
                idx = mask.get(slotIndex);
                maskGroup.put(idx, CollapsibleItems.getGroupIndex(this.getItem(idx)));
            }
            for (slotIndex = 0; slotIndex < mask.size(); ++slotIndex) {
                Integer nextidx;
                Integer previdx;
                int groupIndex;
                if (mask.get(slotIndex) == null || (groupIndex = ((Integer)maskGroup.get(idx = mask.get(slotIndex).intValue())).intValue()) == -1 || this.groupItems.get(groupIndex).size() == 1) continue;
                int column = slotIndex % this.columns;
                int row = slotIndex / this.columns;
                int prevSlotIndex = (row - 1) * this.columns + column;
                int nextSlotIndex = (row + 1) * this.columns + column;
                MaskMetadata metadata = new MaskMetadata();
                metadata.groupIndex = groupIndex;
                metadata.displayName = CollapsibleItems.getDisplayName(groupIndex);
                metadata.extended = this.forceExpand || CollapsibleItems.isExpanded(groupIndex);
                metadata.bgColor = metadata.extended ? expandedColor : collapsedColor;
                metadata.color = ItemPanelGrid.darkerColor(metadata.bgColor);
                metadata.left = column == 0 || idx == 0 || mask.get(slotIndex - 1) == null || maskGroup.getOrDefault(idx - 1, -1) != groupIndex;
                boolean bl = metadata.right = column == this.columns - 1 || maskGroup.getOrDefault(idx + 1, -1) != groupIndex;
                metadata.top = prevSlotIndex >= 0 ? (previdx = mask.get(prevSlotIndex)) == null || maskGroup.getOrDefault(previdx, -1) != groupIndex : true;
                metadata.bottom = nextSlotIndex < mask.size() ? (nextidx = mask.get(nextSlotIndex)) == null || maskGroup.getOrDefault(nextidx, -1) != groupIndex : true;
                this.maskMetadata.put(idx, metadata);
            }
        }

        @Override
        protected void beforeDrawItems(int mousex, int mousey, @Nullable ItemPanelSlot focused) {
            List<Integer> mask = this.getMask();
            super.beforeDrawItems(mousex, mousey, focused);
            for (int i = 0; i < mask.size(); ++i) {
                if (mask.get(i) == null) continue;
                this.drawBorder(mask.get(i), this.getSlotRect(i));
            }
        }

        protected void drawBorder(int slotIdx, Rectangle4i rect) {
            MaskMetadata metadata = this.maskMetadata.get(slotIdx);
            if (metadata != null) {
                float LINE_WIDTH = 0.75f;
                ItemPanelGrid.drawRect(rect.x, rect.y, rect.w, rect.h, metadata.bgColor);
                if (metadata.left) {
                    float leftBottom = metadata.bottom ? -0.75f : 0.0f;
                    ItemPanelGrid.drawRect(rect.x, rect.y, 0.75, (float)rect.h + leftBottom, metadata.color);
                }
                if (metadata.right) {
                    float rightTop = metadata.top ? 0.75f : 0.0f;
                    ItemPanelGrid.drawRect(rect.x + rect.w, (float)rect.y - rightTop, 0.75, (float)rect.h + rightTop, metadata.color);
                }
                if (metadata.top) {
                    ItemPanelGrid.drawRect(rect.x, (float)rect.y - 0.75f, rect.w, 0.75, metadata.color);
                }
                if (metadata.bottom) {
                    ItemPanelGrid.drawRect(rect.x, (float)(rect.y + rect.h) - 0.75f, rect.w, 0.75, metadata.color);
                }
            }
        }

        private static Color darkerColor(Color color) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min((int)((float)color.getAlpha() + 102.0f), 255));
        }

        private static void drawRect(double left, double top, double width, double height, Color color) {
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            tessellator.func_78382_b();
            tessellator.func_78377_a(left, top + height, 0.0);
            tessellator.func_78377_a(left + width, top + height, 0.0);
            tessellator.func_78377_a(left + width, top, 0.0);
            tessellator.func_78377_a(left, top, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }

        @Override
        protected void drawItem(Rectangle4i rect, int slotIdx) {
            MaskMetadata metadata = this.maskMetadata.get(slotIdx);
            if (metadata != null && !metadata.extended) {
                List<ItemStack> groupItems = this.groupItems.get(metadata.groupIndex);
                GuiContainerManager.drawItems.field_77023_b -= 10.0f;
                GuiContainerManager.drawItem(rect.x + 1, rect.y - 1, groupItems.get(groupItems.size() - 1), true, "");
                GuiContainerManager.drawItems.field_77023_b += 10.0f;
                GuiContainerManager.drawItem(rect.x - 1, rect.y + 1, this.getItem(slotIdx), true, "");
            } else {
                super.drawItem(rect, slotIdx);
            }
        }

        @Override
        public String getMessageOnEmpty() {
            return ItemList.loadFinished ? null : NEIClientUtils.translate("itempanel.loading", new Object[0]);
        }
    }

    public static class ItemPanelSlot {
        public ItemStack item;
        public int slotIndex;

        public ItemPanelSlot(int idx, ItemStack stack) {
            this.slotIndex = idx;
            this.item = stack;
        }

        @Deprecated
        public ItemPanelSlot(int idx) {
            this(idx, ItemPanels.itemPanel.getGrid().getItem(idx));
        }
    }

    protected static class MaskMetadata {
        public int groupIndex = -1;
        public String displayName = "";
        public boolean extended = false;
        public Color bgColor = null;
        public Color color = null;
        public boolean left = false;
        public boolean top = false;
        public boolean right = false;
        public boolean bottom = false;

        protected MaskMetadata() {
        }
    }
}

