/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.config.Option;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class OptionButton
extends Option {
    protected static final ResourceLocation guiTex = new ResourceLocation("textures/gui/widgets.png");
    public final String prefix;
    public final String text;
    public final String tooltip;
    private boolean isEnabled = true;

    public OptionButton(String name, String prefix, String text, String tooltip) {
        super(name);
        this.prefix = prefix;
        this.text = text;
        this.tooltip = tooltip;
    }

    public OptionButton(String prefix, String text, String tooltip) {
        this(text, prefix, text, tooltip);
    }

    public OptionButton(String name) {
        this(null, name, name + ".tip");
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    @Override
    public void draw(int mx, int my, float frame) {
        GuiDraw.changeTexture((ResourceLocation)guiTex);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawPrefix();
        this.drawButton(mx, my);
    }

    public Rectangle buttonSize() {
        if (this.getPrefix() == null) {
            return new Rectangle(0, 0, this.slot.slotWidth(), 20);
        }
        int width = Math.max(60, GuiDraw.getStringWidth((String)this.getButtonText()) + 8);
        return new Rectangle(this.slot.slotWidth() - width, 0, width, 20);
    }

    public String getPrefix() {
        if (this.prefix == null) {
            return null;
        }
        String s = this.translateN(this.prefix, new Object[0]);
        if (s.equals(this.namespaced(this.prefix))) {
            return null;
        }
        return s;
    }

    public String getButtonText() {
        return this.translateN(this.name, new Object[0]);
    }

    public String getTooltip() {
        String s;
        if (this.tooltip != null && !(s = this.translateN(this.tooltip, new Object[0])).equals(this.namespaced(this.tooltip))) {
            return s;
        }
        if (this.getPrefix() != null) {
            int width = GuiDraw.getStringWidth((String)this.getPrefix());
            Rectangle b = this.buttonSize();
            if (width >= b.x) {
                return this.translateN(this.name, new Object[0]);
            }
        }
        return null;
    }

    public void drawPrefix() {
        String prefix = this.getPrefix();
        if (prefix != null) {
            Rectangle b = this.buttonSize();
            GuiDraw.drawString((String)NEIClientUtils.cropText(Minecraft.func_71410_x().field_71466_p, prefix, b.x - 10), (int)10, (int)6, (int)-1);
        }
    }

    public void drawButton(int mx, int my) {
        Rectangle b = this.buttonSize();
        LayoutManager.drawButtonBackground(b.x, b.y, b.width, b.height, true, this.getButtonTex(mx, my));
        GuiDraw.drawStringC((String)this.getButtonText(), (int)b.x, (int)b.y, (int)b.width, (int)b.height, (int)this.getTextColour(mx, my));
    }

    public int getButtonTex(int mx, int my) {
        return !this.isEnabled() ? 0 : (this.pointInside(mx, my) ? 2 : 1);
    }

    public int getTextColour(int mx, int my) {
        return !this.isEnabled() ? -6250336 : (this.pointInside(mx, my) ? -96 : -2039584);
    }

    public boolean pointInside(int mx, int my) {
        return this.buttonSize().contains(mx, my);
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        if (this.pointInside(x, y) && this.onClick(button)) {
            OptionButton.playClickSound();
        }
    }

    public boolean onClick(int button) {
        return false;
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> currenttip) {
        if (this.getTooltip() != null) {
            currenttip.add(this.getTooltip());
        }
        return currenttip;
    }
}

