/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.ISyncableValueProvider;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;

public class SyncableNBT
extends SyncableObjectBase
implements ISyncableValueProvider<NBTTagCompound> {
    private NBTTagCompound tag;

    public SyncableNBT() {
        this.tag = new NBTTagCompound();
    }

    public SyncableNBT(NBTTagCompound nbt) {
        this.tag = (NBTTagCompound)nbt.func_74737_b();
    }

    @Override
    public NBTTagCompound getValue() {
        return (NBTTagCompound)this.tag.func_74737_b();
    }

    public void setValue(NBTTagCompound tag) {
        this.tag = (NBTTagCompound)tag.func_74737_b();
    }

    @Override
    public void readFromStream(DataInputStream stream) throws IOException {
        int length = ByteUtils.readVLI(stream);
        this.tag = length > 0 ? CompressedStreamTools.func_74796_a((InputStream)ByteStreams.limit((InputStream)stream, (long)length)) : null;
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        if (this.tag != null) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.tag, (OutputStream)buffer);
            byte[] bytes = buffer.toByteArray();
            ByteUtils.writeVLI(stream, bytes.length);
            stream.write(bytes);
        } else {
            stream.writeByte(0);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74782_a(name, (NBTBase)nbt);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        nbt.func_74775_l(name);
    }
}

