/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.teams;

import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import serverutils.client.gui.teams.GuiManagePlayersBase;
import serverutils.lib.EnumTeamStatus;
import serverutils.lib.data.ServerUtilitiesTeamGuiActions;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.Panel;
import serverutils.lib.icon.Color4I;
import serverutils.lib.util.misc.MouseButton;
import serverutils.net.MessageMyTeamAction;
import serverutils.net.MessageMyTeamPlayerList;

public class GuiManageEnemies
extends GuiManagePlayersBase {
    public GuiManageEnemies(Collection<MessageMyTeamPlayerList.Entry> m) {
        super(I18n.func_135052_a((String)"team_action.serverutilities.enemies", (Object[])new Object[0]), m, (x$0, x$1) -> new ButtonPlayer((Panel)x$0, (MessageMyTeamPlayerList.Entry)x$1));
    }

    private static class ButtonPlayer
    extends GuiManagePlayersBase.ButtonPlayerBase {
        private ButtonPlayer(Panel panel, MessageMyTeamPlayerList.Entry m) {
            super(panel, m);
        }

        @Override
        Color4I getPlayerColor() {
            return this.entry.status == EnumTeamStatus.ENEMY ? Color4I.getChatFormattingColor(EnumChatFormatting.RED) : this.getDefaultPlayerColor();
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.add(I18n.func_135052_a((String)(this.entry.status == EnumTeamStatus.ENEMY ? EnumTeamStatus.ENEMY : EnumTeamStatus.NONE).getLangKey(), (Object[])new Object[0]));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("player", this.entry.name);
            if (this.entry.status == EnumTeamStatus.ENEMY) {
                data.func_74757_a("add", false);
                this.entry.status = EnumTeamStatus.NONE;
            } else {
                data.func_74757_a("add", true);
                this.entry.status = EnumTeamStatus.ENEMY;
            }
            new MessageMyTeamAction(ServerUtilitiesTeamGuiActions.ENEMIES.getId(), data).sendToServer();
            this.updateIcon();
        }
    }
}

