/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.teams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import serverutils.client.gui.teams.GuiCreateTeam;
import serverutils.client.gui.teams.PublicTeamData;
import serverutils.lib.EnumTeamStatus;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.util.misc.MouseButton;

public class GuiSelectTeam
extends GuiButtonListBase {
    private final boolean canCreate;
    private final List<PublicTeamData> teams;

    public GuiSelectTeam(Collection<PublicTeamData> teams0, boolean c) {
        this.setTitle(I18n.func_135052_a((String)"team_action.serverutilities.select_team", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.teams = new ArrayList<PublicTeamData>(teams0);
        this.teams.sort(null);
        this.canCreate = c;
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new ButtonCreateTeam(panel, this.canCreate));
        for (PublicTeamData t : this.teams) {
            panel.add(new ButtonTeam(panel, t));
        }
    }

    private static class ButtonCreateTeam
    extends SimpleTextButton {
        private final boolean canCreate;

        private ButtonCreateTeam(Panel panel, boolean c) {
            super(panel, I18n.func_135052_a((String)"team_action.serverutilities.create_team", (Object[])new Object[0]), GuiIcons.ADD);
            this.canCreate = c;
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiCreateTeam().openGui();
        }

        @Override
        public WidgetType getWidgetType() {
            return this.canCreate ? WidgetType.mouseOver(this.isMouseOver()) : WidgetType.DISABLED;
        }
    }

    private static class ButtonTeam
    extends SimpleTextButton {
        private final PublicTeamData team;

        private ButtonTeam(Panel panel, PublicTeamData t) {
            super(panel, t.displayName.func_150260_c(), t.icon.withBorder(t.color.getColor(), false));
            this.team = t;
            if (this.team.type == PublicTeamData.Type.REQUESTING_INVITE) {
                this.setTitle(EnumChatFormatting.AQUA + this.getTitle());
            } else if (this.team.type == PublicTeamData.Type.ENEMY) {
                this.setTitle(EnumChatFormatting.RED + this.getTitle());
            } else if (this.team.type == PublicTeamData.Type.CAN_JOIN) {
                this.setTitle(EnumChatFormatting.GREEN + this.getTitle());
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.team.type == PublicTeamData.Type.CAN_JOIN) {
                ClientUtils.execClientCommand("/team join " + this.team.getId());
                this.getGui().closeGui();
            } else if (this.team.type != PublicTeamData.Type.ENEMY && this.team.type != PublicTeamData.Type.REQUESTING_INVITE) {
                ClientUtils.execClientCommand("/team request_invite " + this.team.getId());
                this.team.type = PublicTeamData.Type.REQUESTING_INVITE;
                this.setTitle(EnumChatFormatting.AQUA + this.getTitle());
                this.parent.alignWidgets();
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.team.description.isEmpty()) {
                list.add(EnumChatFormatting.ITALIC + this.team.description);
            }
            if (this.team.type == PublicTeamData.Type.REQUESTING_INVITE) {
                list.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"serverutilities.lang.team_status.requesting_invite", (Object[])new Object[0]));
            } else if (this.team.type == PublicTeamData.Type.ENEMY) {
                list.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)EnumTeamStatus.ENEMY.getLangKey(), (Object[])new Object[0]));
            } else {
                list.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)(this.team.type == PublicTeamData.Type.CAN_JOIN ? "serverutilities.lang.team.gui.join_team" : "serverutilities.lang.team.gui.request_invite"), (Object[])new Object[]{this.team.color.getEnumChatFormatting() + this.team.getId() + EnumChatFormatting.GRAY}));
            }
        }

        @Override
        public WidgetType getWidgetType() {
            return this.team.type == PublicTeamData.Type.ENEMY ? WidgetType.DISABLED : WidgetType.mouseOver(this.isMouseOver());
        }
    }
}

