/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.icon.Color4I;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.StringUtils;

public class ConfigLong
extends ConfigValue
implements LongSupplier {
    public static final String ID = "long";
    private long value;
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;

    public ConfigLong(long v) {
        this.value = v;
    }

    public ConfigLong(long v, long mn, long mx) {
        this(Math.min(Math.max(v, mn), mx));
        this.min = mn;
        this.max = mx;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    public void setLong(long v) {
        this.value = v;
    }

    public ConfigLong setMin(long v) {
        this.min = v;
        return this;
    }

    public ConfigLong setMax(long v) {
        this.max = v;
        return this;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    @Override
    public IChatComponent getStringForGUI() {
        return new ChatComponentText(StringUtils.formatDouble(this.getLong(), true));
    }

    @Override
    public String getString() {
        return Long.toString(this.getLong());
    }

    @Override
    public boolean getBoolean() {
        return (double)this.getLong() != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public ConfigLong copy() {
        return new ConfigLong(this.getLong());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getLong() == value.getLong();
    }

    @Override
    public Color4I getColor() {
        return ConfigInt.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        super.addInfo(inst, list);
        long m = this.getMin();
        if (m != Long.MIN_VALUE) {
            list.add(EnumChatFormatting.AQUA + "Min: " + EnumChatFormatting.RESET + StringUtils.formatDouble(m));
        }
        if ((m = this.getMax()) != Long.MAX_VALUE) {
            list.add(EnumChatFormatting.AQUA + "Max: " + EnumChatFormatting.RESET + StringUtils.formatDouble(m));
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.isEmpty()) {
            return false;
        }
        try {
            long l = Long.parseLong(string);
            if (!simulate) {
                this.setLong(l);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getLong();
        if (this.value != 0L) {
            nbt.func_74772_a(key, this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setLong(nbt.func_74763_f(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarLong(this.getLong());
        data.writeVarLong(this.getMin());
        data.writeVarLong(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setLong(data.readVarLong());
        this.setMin(data.readVarLong());
        this.setMax(data.readVarLong());
    }

    @Override
    public long getAsLong() {
        return this.getLong();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setLong(value.getLong());
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setLong(json.getAsLong());
        }
    }

    public static class SimpleLong
    extends ConfigLong {
        private final LongSupplier get;
        private final LongConsumer set;

        public SimpleLong(long min, long max, LongSupplier g, LongConsumer s) {
            super(0L, min, max);
            this.get = g;
            this.set = s;
        }

        @Override
        public long getLong() {
            return this.get.getAsLong();
        }

        @Override
        public void setLong(long v) {
            this.set.accept(v);
        }
    }
}

