/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import crazypants.enderio.machine.farm.FakeFarmPlayer;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import serverutils.handlers.ServerUtilitiesClientEventHandler;
import serverutils.lib.OtherMods;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageNotification;

public class ServerUtils {
    public static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(StringUtils.fromString("069be1413c1b45c3b3b160d3f9fcd236"), "FakeForgePlayer");

    public static double getMovementFactor(int dim) {
        double d;
        switch (dim) {
            case 0: 
            case 1: {
                d = 1.0;
                break;
            }
            case -1: {
                d = 8.0;
                break;
            }
            default: {
                WorldServer w = DimensionManager.getWorld((int)dim);
                if (w == null) {
                    d = 1.0;
                    break;
                }
                d = w.field_73011_w.getMovementFactor();
                break;
            }
        }
        return d;
    }

    public static IChatComponent getDimensionName(int dim) {
        ChatComponentTranslation chatComponentTranslation;
        switch (dim) {
            case 0: {
                chatComponentTranslation = new ChatComponentTranslation("serverutilities.world.dimension.overworld", new Object[0]);
                break;
            }
            case -1: {
                chatComponentTranslation = new ChatComponentTranslation("serverutilities.world.dimension.nether", new Object[0]);
                break;
            }
            case 1: {
                chatComponentTranslation = new ChatComponentTranslation("serverutilities.world.dimension.end", new Object[0]);
                break;
            }
            default: {
                chatComponentTranslation = new ChatComponentText("dim_" + dim);
            }
        }
        return chatComponentTranslation;
    }

    public static boolean isVanillaClient(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            NetHandlerPlayServer connection = ((EntityPlayerMP)sender).field_71135_a;
            return connection != null && connection.field_147371_a.channel().attr(NetworkRegistry.MOD_CONTAINER) == null;
        }
        return false;
    }

    public static boolean isFake(EntityPlayerMP player) {
        return player.field_71135_a == null || player instanceof FakePlayer || ServerUtils.isFakeFarmPlayer(player);
    }

    private static boolean isFakeFarmPlayer(EntityPlayerMP player) {
        if (!OtherMods.isEnderIOLoaded()) {
            return false;
        }
        return player instanceof FakeFarmPlayer;
    }

    public static boolean isOP(@Nullable MinecraftServer server, @Nullable GameProfile profile) {
        if (profile == null || profile.getId() == null || profile.getName() == null) {
            return false;
        }
        if (server == null && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) == null) {
            return false;
        }
        return server.func_71203_ab().func_152596_g(profile);
    }

    public static boolean isOP(EntityPlayerMP player) {
        return ServerUtils.isOP(player.field_71133_b, player.func_146103_bH());
    }

    public static Collection<ICommand> getAllCommands(MinecraftServer server, ICommandSender sender) {
        HashSet<ICommand> commands = new HashSet<ICommand>();
        for (ICommand c : server.func_71187_D().func_71555_a().values()) {
            if (!c.func_71519_b(sender)) continue;
            commands.add(c);
        }
        return commands;
    }

    public static SpawnType canMobSpawn(World world, int x, int y, int z) {
        boolean grounded_mob_spawn;
        if (y < 0 || y >= 256) {
            return SpawnType.CANT_SPAWN;
        }
        Chunk chunk = world.func_72938_d(x, z);
        boolean bl = grounded_mob_spawn = SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.ambient, (World)world, (int)x, (int)y, (int)z) || SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.creature, (World)world, (int)x, (int)y, (int)z) || SpawnerAnimals.func_77190_a((EnumCreatureType)EnumCreatureType.monster, (World)world, (int)x, (int)y, (int)z);
        if (!grounded_mob_spawn || chunk.func_76614_a(EnumSkyBlock.Block, x, y, z) >= 8) {
            return SpawnType.CANT_SPAWN;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)x + 0.2), (double)((double)y + 0.01), (double)((double)z + 0.2), (double)((double)x + 0.8), (double)((double)y + 1.8), (double)((double)z + 0.8));
        if (!world.func_72855_b(aabb) || world.func_72953_d(aabb)) {
            return SpawnType.CANT_SPAWN;
        }
        return chunk.func_76614_a(EnumSkyBlock.Sky, x, y, z) >= 8 ? SpawnType.ONLY_AT_NIGHT : SpawnType.ALWAYS_SPAWNS;
    }

    @Nullable
    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Entity e : world.field_72996_f) {
            if (!e.func_110124_au().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public static void notifyChat(MinecraftServer server, @Nullable EntityPlayer player, IChatComponent component) {
        if (player == null) {
            for (EntityPlayer player1 : server.func_71203_ab().field_72404_b) {
                player1.func_146105_b(component);
            }
        } else {
            player.func_146105_b(component);
        }
    }

    public static void notifyAllChat(MinecraftServer server, String message) {
        ServerUtils.notifyChat(server, null, (IChatComponent)new ChatComponentText(message));
    }

    public static void notify(MinecraftServer server, @Nullable EntityPlayer player, IChatComponent notification) {
        if (player == null) {
            new MessageNotification(notification).sendToAll();
        } else if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            new MessageNotification(notification).sendTo(playerMP);
        } else if (player instanceof EntityClientPlayerMP) {
            ServerUtilitiesClientEventHandler.INST.onNotify(notification);
        }
    }

    public static boolean isFirstLogin(EntityPlayer player, String key) {
        if (!NBTUtils.getPersistedData(player, false).func_74767_n(key)) {
            NBTUtils.getPersistedData(player, true).func_74757_a(key, true);
            return true;
        }
        return false;
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static WorldServer getServerWorld() {
        MinecraftServer ms = ServerUtils.getServer();
        return ms.field_71305_c[0];
    }

    public static enum SpawnType {
        CANT_SPAWN,
        ALWAYS_SPAWNS,
        ONLY_AT_NIGHT;

    }
}

