/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.IOUtils;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.compression.ICompress;

public class LegacyCompressor
implements ICompress {
    private ZipOutputStream output;

    @Override
    public void createOutputStream(File file) throws IOException {
        this.output = new ZipOutputStream(new FileOutputStream(file));
        if (ServerUtilitiesConfig.backups.compression_level == 0) {
            this.output.setMethod(0);
        } else {
            this.output.setLevel(ServerUtilitiesConfig.backups.compression_level);
        }
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        if (worldDir != null) {
            this.output.setComment(worldDir.getName());
        }
    }

    @Override
    public void addFileToArchive(File file, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        this.output.putNextEntry(entry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)this.output);
        }
        this.output.closeEntry();
    }

    @Override
    public void extractArchive(File archive, File dest) throws IOException {
        try (ZipFile zip = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream in = zip.getInputStream(entry);
                File file = FileUtils.newFile(new File(dest, entry.getName()));
                FileOutputStream out = new FileOutputStream(file);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    @Nullable
    public String getWorldName(File file) throws IOException {
        if (file.isDirectory() || !file.getName().endsWith(".zip")) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            String string = zipFile.getComment();
            return string;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.output != null) {
            this.output.close();
        }
    }
}

