/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer.common;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.client.renderer.ModularBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.client.renderer.PanelBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperState;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class CommonDrawerRenderer {
    private PanelBoxRenderer panelRenderer = new PanelBoxRenderer();
    private double depth;
    private double trimWidth;
    private double trimDepth;
    private static double unit7 = 0.4375;
    private static double unit9 = 0.5625;

    private RenderHelper start(IBlockAccess world, int x, int y, int z, BlockDrawersCustom block, int direction) {
        this.depth = block.halfDepth ? 0.5 : 0.0;
        this.trimWidth = block.getTrimWidth();
        this.trimDepth = block.getTrimDepth();
        unit7 = 0.4375;
        unit9 = 0.5625;
        this.panelRenderer.setTrimWidth(this.trimWidth);
        this.panelRenderer.setTrimDepth(0.0);
        this.panelRenderer.setTrimColor(ModularBoxRenderer.COLOR_WHITE);
        this.panelRenderer.setPanelColor(ModularBoxRenderer.COLOR_WHITE);
        RenderHelper renderHelper = RenderHelper.instances.get();
        if (world != null) {
            renderHelper.setColorAndBrightness(world, (Block)block, x, y, z);
        }
        renderHelper.state.setRotateTransform(2, direction);
        renderHelper.state.setUVRotation(1, RenderHelperState.ROTATION_BY_FACE_FACE[2][direction]);
        return renderHelper;
    }

    private void end() {
        RenderHelper renderHelper = RenderHelper.instances.get();
        renderHelper.state.clearRotateTransform();
        renderHelper.state.clearUVRotation(1);
    }

    public void renderBasePass(IBlockAccess world, int x, int y, int z, BlockDrawersCustom block, int direction, IIcon iconSide, IIcon iconTrim, IIcon iconFront) {
        RenderHelper renderHelper = this.start(world, x, y, z, block, direction);
        this.panelRenderer.setTrimIcon(iconTrim);
        this.panelRenderer.setPanelIcon(iconSide);
        for (int i = 0; i < 6; ++i) {
            if (i != 2) {
                this.panelRenderer.renderFacePanel(i, world, (Block)block, x, y, z, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
            }
            this.panelRenderer.renderFaceTrim(i, world, (Block)block, x, y, z, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
        }
        this.panelRenderer.setTrimDepth(this.trimDepth);
        this.panelRenderer.renderInteriorTrim(2, world, (Block)block, x, y, z, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
        if (block.drawerCount == 1) {
            renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
        } else if (block.drawerCount == 2) {
            renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
            renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
            renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconTrim);
        } else if (block.drawerCount == 4) {
            renderHelper.state.flipTexture = true;
            renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, unit7, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
            renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, unit7, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
            renderHelper.setRenderBounds(unit9, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
            renderHelper.setRenderBounds(unit9, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconFront);
            renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, unit7, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconTrim);
            renderHelper.setRenderBounds(unit9, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconTrim);
            renderHelper.setRenderBounds(unit7, this.trimWidth, this.depth + this.trimDepth, unit9, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconTrim);
            renderHelper.setRenderBounds(unit7, unit9, this.depth + this.trimDepth, unit9, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconTrim);
            renderHelper.setRenderBounds(unit7, unit7, this.depth + this.trimDepth, unit9, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, iconTrim);
            renderHelper.state.flipTexture = false;
        }
        this.end();
    }

    public void renderOverlayPass(IBlockAccess world, int x, int y, int z, BlockDrawersCustom block, int direction, IIcon iconTrim, IIcon iconFront) {
        RenderHelper renderHelper = this.start(world, x, y, z, block, direction);
        IIcon trimShadow = block.getTrimShadowOverlay(iconTrim == iconFront);
        this.panelRenderer.setTrimIcon(trimShadow);
        this.panelRenderer.renderFaceTrim(2, world, (Block)block, x, y, z, 0.0, 0.0, this.depth, 1.0, 1.0, 1.0);
        if (block.drawerCount == 1) {
            renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
        } else if (block.drawerCount == 2) {
            renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
            renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
            renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, trimShadow);
        } else if (block.drawerCount == 4) {
            renderHelper.setRenderBounds(this.trimWidth, this.trimWidth, this.depth + this.trimDepth, unit7, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
            renderHelper.setRenderBounds(this.trimWidth, unit9, this.depth + this.trimDepth, unit7, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
            renderHelper.setRenderBounds(unit9, this.trimWidth, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
            renderHelper.setRenderBounds(unit9, unit9, this.depth + this.trimDepth, 1.0 - this.trimWidth, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getHandleOverlay());
            renderHelper.renderFace(2, world, (Block)block, x, y, z, block.getFaceShadowOverlay());
            renderHelper.setRenderBounds(this.trimWidth, unit7, this.depth + this.trimDepth, unit7, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, trimShadow);
            renderHelper.setRenderBounds(unit9, unit7, this.depth + this.trimDepth, 1.0 - this.trimWidth, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, trimShadow);
            renderHelper.setRenderBounds(unit7, this.trimWidth, this.depth + this.trimDepth, unit9, unit7, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, trimShadow);
            renderHelper.setRenderBounds(unit7, unit9, this.depth + this.trimDepth, unit9, 1.0 - this.trimWidth, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, trimShadow);
            renderHelper.setRenderBounds(unit7, unit7, this.depth + this.trimDepth, unit9, unit9, 1.0);
            renderHelper.renderFace(2, world, (Block)block, x, y, z, trimShadow);
        } else {
            RenderHelper.instances.get().renderEmptyPlane(x, y, z);
        }
        this.end();
    }
}

