/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.storage.MapData;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.TFMapPacketHandler;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class ItemTFMagicMap
extends ItemMap {
    public static final String STR_ID = "magicmap";

    protected ItemTFMagicMap() {
    }

    @SideOnly(value=Side.CLIENT)
    public static TFMagicMapData getMPMapData(int par0, World world) {
        String mapName = "magicmap_" + par0;
        TFMagicMapData mapData = (TFMagicMapData)world.func_72943_a(TFMagicMapData.class, mapName);
        if (mapData == null) {
            mapData = new TFMagicMapData(mapName);
            world.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public TFMagicMapData getMapData(ItemStack itemStack, World world) {
        String mapName = "magicmap_" + itemStack.func_77960_j();
        TFMagicMapData mapData = (TFMagicMapData)world.func_72943_a(TFMagicMapData.class, mapName);
        if (mapData == null && !world.field_72995_K) {
            itemStack.func_77964_b(world.func_72841_b(STR_ID));
            mapName = "magicmap_" + itemStack.func_77960_j();
            mapData = new TFMagicMapData(mapName);
            mapData.field_76201_a = world.func_72912_H().func_76079_c();
            mapData.field_76199_b = world.func_72912_H().func_76074_e();
            mapData.field_76197_d = (byte)4;
            mapData.field_76200_c = world.field_73011_w.field_76574_g;
            mapData.func_76185_a();
            world.func_72823_a(mapName, (WorldSavedData)mapData);
        }
        return mapData;
    }

    public void updateMapData(World world, Entity entity, TFMagicMapData mapData) {
        if (world.field_73011_w.field_76574_g == mapData.field_76200_c && entity instanceof EntityPlayer) {
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)world.field_73011_w).getChunkProvider();
            int xSize = 128;
            int zSize = 128;
            int scaleFactor = 1 << mapData.field_76197_d;
            int xCenter = mapData.field_76201_a;
            int zCenter = mapData.field_76199_b;
            int xDraw = MathHelper.func_76128_c((double)(entity.field_70165_t - (double)xCenter)) / scaleFactor + xSize / 2;
            int zDraw = MathHelper.func_76128_c((double)(entity.field_70161_v - (double)zCenter)) / scaleFactor + zSize / 2;
            int drawSize = 512 / scaleFactor;
            MapData.MapInfo mapInfo = mapData.func_82568_a((EntityPlayer)entity);
            ++mapInfo.field_82569_d;
            for (int xStep = xDraw - drawSize + 1; xStep < xDraw + drawSize; ++xStep) {
                if ((xStep & 0xF) != (mapInfo.field_82569_d & 0xF)) continue;
                int highNumber = 255;
                int lowNumber = 0;
                for (int zStep = zDraw - drawSize - 1; zStep < zDraw + drawSize; ++zStep) {
                    byte existingColor;
                    if (xStep < 0 || zStep < -1 || xStep >= xSize || zStep >= zSize) continue;
                    int xOffset = xStep - xDraw;
                    int zOffset = zStep - zDraw;
                    boolean var20 = xOffset * xOffset + zOffset * zOffset > (drawSize - 2) * (drawSize - 2);
                    int xDraw2 = (xCenter / scaleFactor + xStep - xSize / 2) * scaleFactor;
                    int zDraw2 = (zCenter / scaleFactor + zStep - zSize / 2) * scaleFactor;
                    int[] biomeFrequencies = new int[256];
                    for (int xStep2 = 0; xStep2 < scaleFactor; ++xStep2) {
                        for (int zStep2 = 0; zStep2 < scaleFactor; ++zStep2) {
                            TFWorldChunkManager tfManager;
                            WorldChunkManager worldChunkManager;
                            int biomeID;
                            int n = biomeID = world.func_72807_a((int)(xDraw2 + xStep2), (int)(zDraw2 + zStep2)).field_76756_M;
                            biomeFrequencies[n] = biomeFrequencies[n] + 1;
                            if (biomeID == BiomeGenBase.field_76781_i.field_76756_M || biomeID == TFBiomeBase.stream.field_76756_M) {
                                int n2 = biomeID;
                                biomeFrequencies[n2] = biomeFrequencies[n2] + 2;
                            }
                            if (!((worldChunkManager = world.func_72959_q()) instanceof TFWorldChunkManager) || !(tfManager = (TFWorldChunkManager)worldChunkManager).isInFeatureChunk(world, xDraw2 + xStep2, zDraw2 + zStep2) || zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize) continue;
                            mapData.addFeatureToMap(TFFeature.getNearestFeature(xDraw2 + xStep2 >> 4, zDraw2 + zStep2 >> 4, world), xDraw2, zDraw2, chunkProvider.isStructureConquered(xDraw2 + xStep2, 0, zDraw2 + zStep2));
                        }
                    }
                    byte biomeIDToShow = 0;
                    int highestFrequency = 0;
                    for (int i = 0; i < 256; ++i) {
                        if (biomeFrequencies[i] <= highestFrequency) continue;
                        biomeIDToShow = (byte)i;
                        highestFrequency = biomeFrequencies[i];
                    }
                    biomeIDToShow = (byte)(biomeIDToShow + 1);
                    if (zStep < 0 || xOffset * xOffset + zOffset * zOffset >= drawSize * drawSize || var20 && (xStep + zStep & 1) == 0 || (existingColor = mapData.field_76198_e[xStep + zStep * xSize]) == biomeIDToShow) continue;
                    if (highNumber > zStep) {
                        highNumber = zStep;
                    }
                    if (lowNumber < zStep) {
                        lowNumber = zStep;
                    }
                    mapData.field_76198_e[xStep + zStep * xSize] = biomeIDToShow;
                }
                if (highNumber > lowNumber) continue;
                mapData.func_76194_a(xStep, highNumber, lowNumber);
            }
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K) {
            TFMagicMapData mapData = this.getMapData(itemStack, world);
            if (entity instanceof EntityPlayer) {
                EntityPlayer var7 = (EntityPlayer)entity;
                mapData.func_76191_a(var7, itemStack);
            }
            if (par5) {
                this.updateMapData(world, entity, mapData);
            }
        }
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return false;
    }

    public Packet func_150911_c(ItemStack itemStack, World world, EntityPlayer player) {
        byte[] mapBytes = this.getMapData(itemStack, world).func_76193_a(itemStack, world, player);
        if (mapBytes == null) {
            return null;
        }
        if (mapBytes[0] == 1 && world.field_73012_v.nextInt(4) == 0) {
            this.getMapData(itemStack, world).checkExistingFeatures(world);
            mapBytes = this.getMapData(itemStack, world).makeFeatureStorageArray();
        }
        short uniqueID = (short)itemStack.func_77960_j();
        return TFMapPacketHandler.makeMagicMapPacket(STR_ID, uniqueID, mapBytes);
    }

    public String func_77653_i(ItemStack itemStack) {
        return (StatCollector.func_74838_a((String)(this.func_77657_g(itemStack) + ".name")) + " #" + itemStack.func_77960_j()).trim();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("TwilightForest:" + this.func_77658_a().substring(5));
    }
}

