/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.block;

import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ICustomLadder;
import com.thecodewarrior.catwalks.IInOutRenderSettings;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import com.thecodewarrior.catwalks.util.Predicate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSupportColumn
extends Block
implements ICustomLadder,
IInOutRenderSettings {
    RayTracer raytracer = new RayTracer();
    IIcon inventory;
    public IIcon support;

    public BlockSupportColumn() {
        super(Material.field_151573_f);
        this.func_149647_a(CatwalkMod.catwalkTab);
        this.func_149672_a(CatwalkMod.catwalkSounds);
        this.func_149663_c("support_column");
        float d = (float)((1.0 - this.getWidth()) / 2.0);
        this.func_149676_a(d, 0.0f, d, 1.0f - d, 1.0f, 1.0f - d);
        this.func_149711_c(1.0f);
    }

    public double getWidth() {
        return 0.5625;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (CatwalkUtil.isHoldingWrench(player) && player.func_70093_af()) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            for (ItemStack s : drops) {
                CatwalkUtil.giveItemToPlayer(player, s);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int blockSide, float hitX, float hitY, float hitZ) {
        ForgeDirection side = ForgeDirection.getOrientation((int)blockSide);
        if (player.func_71045_bC() != null) {
            Item item = player.func_71045_bC().func_77973_b();
            boolean use = false;
            if (CatwalkUtil.isHoldingWrench(player)) {
                if (player.func_70093_af()) {
                    CatwalkUtil.retractBlock(world, x, y, z, side.getOpposite(), player, new Predicate<BlockCoord>(new Object[]{world}){

                        @Override
                        public boolean test(BlockCoord coord) {
                            World world = (World)this.args[0];
                            return world.func_147439_a(coord.x, coord.y, coord.z) instanceof BlockSupportColumn;
                        }
                    });
                } else {
                    int meta = world.func_72805_g(x, y, z);
                    if (meta < 3) {
                        world.func_72921_c(x, y, z, 3, 3);
                    } else {
                        int newMeta = 0;
                        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
                            newMeta = 0;
                        }
                        if (side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH) {
                            newMeta = 1;
                        }
                        if (side == ForgeDirection.EAST || side == ForgeDirection.WEST) {
                            newMeta = 2;
                        }
                        world.func_72921_c(x, y, z, newMeta, 3);
                    }
                }
            }
        }
        return false;
    }

    public void func_149651_a(IIconRegister reg) {
        this.inventory = reg.func_94245_a("catwalks:inventory/support");
        this.support = reg.func_94245_a("catwalks:support");
    }

    public IIcon func_149691_a(int _side, int meta) {
        if (_side >= 100) {
            ForgeDirection side = ForgeDirection.getOrientation((int)(_side - 100));
            return this.inventory;
        }
        return this.support;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean isSideEnd(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 && (side == ForgeDirection.UP || side == ForgeDirection.DOWN)) {
            return true;
        }
        if (meta == 1 && (side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH)) {
            return true;
        }
        return meta == 2 && (side == ForgeDirection.WEST || side == ForgeDirection.EAST);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public int func_149645_b() {
        return CatwalkMod.supportRenderType;
    }

    public int func_149660_a(World world, int x, int y, int z, int _side, float hitX, float hitY, float hitZ, int itemMeta) {
        ForgeDirection side = ForgeDirection.getOrientation((int)_side);
        switch (side) {
            case UP: 
            case DOWN: {
                return 0;
            }
            case NORTH: 
            case SOUTH: {
                return 1;
            }
            case EAST: 
            case WEST: {
                return 2;
            }
        }
        return 0;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, startVec, endVec);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB intersect, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, intersect, list, entity);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float d = (float)((1.0 - this.getWidth()) / 2.0);
        float D = 1.0f - d;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        if (meta == 0) {
            minX = d;
            minY = 0.0f;
            minZ = d;
            maxX = D;
            maxY = 1.0f;
            maxZ = D;
        }
        if (meta == 1) {
            minX = d;
            minY = d;
            minZ = 0.0f;
            maxX = D;
            maxY = D;
            maxZ = 1.0f;
        }
        if (meta == 2) {
            minX = 0.0f;
            minY = d;
            minZ = d;
            maxX = 1.0f;
            maxY = D;
            maxZ = D;
        }
        if (meta == 3) {
            minX = d;
            minY = d;
            minZ = d;
            maxX = D;
            maxY = D;
            maxZ = D;
        }
        if (world.func_147439_a(x - 1, y, z) instanceof BlockSupportColumn) {
            minX = 0.0f;
        }
        if (world.func_147439_a(x, y - 1, z) instanceof BlockSupportColumn) {
            minY = 0.0f;
        }
        if (world.func_147439_a(x, y, z - 1) instanceof BlockSupportColumn) {
            minZ = 0.0f;
        }
        if (world.func_147439_a(x + 1, y, z) instanceof BlockSupportColumn) {
            maxX = 1.0f;
        }
        if (world.func_147439_a(x, y + 1, z) instanceof BlockSupportColumn) {
            maxY = 1.0f;
        }
        if (world.func_147439_a(x, y, z + 1) instanceof BlockSupportColumn) {
            maxZ = 1.0f;
        }
        this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        boolean shouldBeSoft;
        int metadata = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        if (player.func_70694_bm() != null && (shouldBeSoft = CatwalkUtil.isHoldingWrench(player))) {
            hardness = this.field_149782_v / 10.0f;
        }
        return player.getBreakSpeed((Block)this, false, metadata, x, y, z) / hardness / 30.0f;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(Item.func_150898_a((Block)CatwalkMod.supportColumn), 1));
        return ret;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public double getLadderVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.05;
    }

    @Override
    public double getLadderFallVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return -1.0;
    }

    @Override
    public boolean isOnLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean shouldPlayStepSound(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, boolean isMovingDown) {
        return !isMovingDown;
    }

    @Override
    public boolean shouldHoldOn(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() || CatwalkUtil.isHoldingWrench(entity, false) || CatwalkUtil.getHeldBlock(entity) instanceof BlockSupportColumn;
    }

    @Override
    public boolean shouldClimbDown(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return entity.func_70093_af() && (CatwalkUtil.isHoldingWrench(entity, false) || CatwalkUtil.getHeldBlock(entity) instanceof BlockSupportColumn);
    }

    @Override
    public double getClimbDownVelocity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return 0.03;
    }

    @Override
    public boolean shouldForceBackFaceRender() {
        return false;
    }
}

