/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjExceptionInternal;
import java.util.Random;

class PngDeinterlacer {
    private final ImageInfo imi;
    private int pass;
    private int rows;
    private int cols;
    private int dY;
    private int dX;
    private int oY;
    private int oX;
    private int oXsamples;
    private int dXsamples;
    private int currRowSubimg = -1;
    private int currRowReal = -1;
    private final int packedValsPerPixel;
    private final int packedMask;
    private final int packedShift;
    private int[][] imageInt;
    private short[][] imageShort;
    private byte[][] imageByte;

    PngDeinterlacer(ImageInfo iminfo) {
        this.imi = iminfo;
        this.pass = 0;
        if (this.imi.packed) {
            this.packedValsPerPixel = 8 / this.imi.bitDepth;
            this.packedShift = this.imi.bitDepth;
            this.packedMask = this.imi.bitDepth == 1 ? 128 : (this.imi.bitDepth == 2 ? 192 : 240);
        } else {
            this.packedValsPerPixel = 1;
            this.packedShift = 1;
            this.packedMask = 1;
        }
        this.setPass(1);
        this.setRow(0);
    }

    void setRow(int n) {
        this.currRowSubimg = n;
        this.currRowReal = n * this.dY + this.oY;
        if (this.currRowReal < 0 || this.currRowReal >= this.imi.rows) {
            throw new PngjExceptionInternal("bad row - this should not happen");
        }
    }

    void setPass(int p) {
        if (this.pass == p) {
            return;
        }
        this.pass = p;
        switch (this.pass) {
            case 1: {
                this.dX = 8;
                this.dY = 8;
                this.oY = 0;
                this.oX = 0;
                break;
            }
            case 2: {
                this.dX = 8;
                this.dY = 8;
                this.oX = 4;
                this.oY = 0;
                break;
            }
            case 3: {
                this.dX = 4;
                this.dY = 8;
                this.oX = 0;
                this.oY = 4;
                break;
            }
            case 4: {
                this.dY = 4;
                this.dX = 4;
                this.oX = 2;
                this.oY = 0;
                break;
            }
            case 5: {
                this.dX = 2;
                this.dY = 4;
                this.oX = 0;
                this.oY = 2;
                break;
            }
            case 6: {
                this.dY = 2;
                this.dX = 2;
                this.oX = 1;
                this.oY = 0;
                break;
            }
            case 7: {
                this.dX = 1;
                this.dY = 2;
                this.oX = 0;
                this.oY = 1;
                break;
            }
            default: {
                throw new PngjExceptionInternal("bad interlace pass" + this.pass);
            }
        }
        this.rows = (this.imi.rows - this.oY) / this.dY + 1;
        if ((this.rows - 1) * this.dY + this.oY >= this.imi.rows) {
            --this.rows;
        }
        this.cols = (this.imi.cols - this.oX) / this.dX + 1;
        if ((this.cols - 1) * this.dX + this.oX >= this.imi.cols) {
            --this.cols;
        }
        if (this.cols == 0) {
            this.rows = 0;
        }
        this.dXsamples = this.dX * this.imi.channels;
        this.oXsamples = this.oX * this.imi.channels;
    }

    void deinterlaceInt(int[] src, int[] dst, boolean readInPackedFormat) {
        if (!this.imi.packed || !readInPackedFormat) {
            int i = 0;
            int j = this.oXsamples;
            while (i < this.cols * this.imi.channels) {
                for (int k = 0; k < this.imi.channels; ++k) {
                    dst[j + k] = src[i + k];
                }
                i += this.imi.channels;
                j += this.dXsamples;
            }
        } else {
            this.deinterlaceIntPacked(src, dst);
        }
    }

    private void deinterlaceIntPacked(int[] src, int[] dst) {
        int spos = 0;
        int smask = this.packedMask;
        int smod = -1;
        int i = 0;
        int j = this.oX;
        while (i < this.cols) {
            spos = i / this.packedValsPerPixel;
            if (++smod >= this.packedValsPerPixel) {
                smod = 0;
            }
            smask >>= this.packedShift;
            if (smod == 0) {
                smask = this.packedMask;
            }
            int tpos = j / this.packedValsPerPixel;
            int tmod = j % this.packedValsPerPixel;
            int p = src[spos] & smask;
            int d = tmod - smod;
            if (d > 0) {
                p >>= d * this.packedShift;
            } else if (d < 0) {
                p <<= -d * this.packedShift;
            }
            int n = tpos;
            dst[n] = dst[n] | p;
            ++i;
            j += this.dX;
        }
    }

    void deinterlaceByte(byte[] src, byte[] dst, boolean readInPackedFormat) {
        if (!this.imi.packed || !readInPackedFormat) {
            int i = 0;
            int j = this.oXsamples;
            while (i < this.cols * this.imi.channels) {
                for (int k = 0; k < this.imi.channels; ++k) {
                    dst[j + k] = src[i + k];
                }
                i += this.imi.channels;
                j += this.dXsamples;
            }
        } else {
            this.deinterlacePackedByte(src, dst);
        }
    }

    private void deinterlacePackedByte(byte[] src, byte[] dst) {
        int spos = 0;
        int smask = this.packedMask;
        int smod = -1;
        int i = 0;
        int j = this.oX;
        while (i < this.cols) {
            spos = i / this.packedValsPerPixel;
            if (++smod >= this.packedValsPerPixel) {
                smod = 0;
            }
            smask >>= this.packedShift;
            if (smod == 0) {
                smask = this.packedMask;
            }
            int tpos = j / this.packedValsPerPixel;
            int tmod = j % this.packedValsPerPixel;
            int p = src[spos] & smask;
            int d = tmod - smod;
            if (d > 0) {
                p >>= d * this.packedShift;
            } else if (d < 0) {
                p <<= -d * this.packedShift;
            }
            int n = tpos;
            dst[n] = (byte)(dst[n] | p);
            ++i;
            j += this.dX;
        }
    }

    boolean isAtLastRow() {
        return this.pass == 7 && this.currRowSubimg == this.rows - 1;
    }

    int getCurrRowSubimg() {
        return this.currRowSubimg;
    }

    int getCurrRowReal() {
        return this.currRowReal;
    }

    int getPass() {
        return this.pass;
    }

    int getRows() {
        return this.rows;
    }

    int getCols() {
        return this.cols;
    }

    public int getPixelsToRead() {
        return this.getCols();
    }

    int[][] getImageInt() {
        return this.imageInt;
    }

    void setImageInt(int[][] imageInt) {
        this.imageInt = imageInt;
    }

    short[][] getImageShort() {
        return this.imageShort;
    }

    void setImageShort(short[][] imageShort) {
        this.imageShort = imageShort;
    }

    byte[][] getImageByte() {
        return this.imageByte;
    }

    void setImageByte(byte[][] imageByte) {
        this.imageByte = imageByte;
    }

    static void test() {
        Random rand = new Random();
        PngDeinterlacer ih = new PngDeinterlacer(new ImageInfo(rand.nextInt(35) + 1, rand.nextInt(52) + 1, 8, true));
        int np = ih.imi.cols * ih.imi.rows;
        System.out.println(ih.imi);
        for (int p = 1; p <= 7; ++p) {
            ih.setPass(p);
            for (int row = 0; row < ih.getRows(); ++row) {
                ih.setRow(row);
                int b = ih.getCols();
                np -= b;
                System.out.printf("Read %d pixels. Pass:%d Realline:%d cols=%d dX=%d oX=%d last:%b\n", b, ih.pass, ih.currRowReal, ih.cols, ih.dX, ih.oX, ih.isAtLastRow());
            }
        }
        if (np != 0) {
            throw new PngjExceptionInternal("wtf??" + ih.imi);
        }
    }

    public static void main(String[] args2) {
        PngDeinterlacer.test();
    }
}

