/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fluid;

import com.google.common.primitives.Ints;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public interface IFluidTankLong
extends IFluidTank {
    public long drainLong(long var1, boolean var3);

    public long fillLong(@Nullable Fluid var1, long var2, boolean var4);

    public long getCapacityLong();

    public long getFluidAmountLong();

    public Fluid getRealFluid();

    default public void setFluid(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            this.setFluid(null, 0L);
        } else {
            this.setFluid(fluidStack.getFluid(), fluidStack.amount);
        }
    }

    public void setFluid(@Nullable Fluid var1, long var2);

    default public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fluid = new FluidStack(this.getRealFluid(), 0);
        fluid.amount = Ints.saturatedCast((long)this.drainLong(maxDrain, doDrain));
        return fluid;
    }

    default public int fill(FluidStack resource, boolean doFill) {
        return Ints.saturatedCast((long)this.fillLong(resource.getFluid(), resource.amount, doFill));
    }

    default public int getCapacity() {
        return Ints.saturatedCast((long)this.getCapacityLong());
    }

    default public FluidStack getFluid() {
        if (this.getRealFluid() == null) {
            return null;
        }
        return new FluidStack(this.getRealFluid(), this.getFluidAmount());
    }

    default public int getFluidAmount() {
        return Ints.saturatedCast((long)this.getFluidAmountLong());
    }

    default public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    public IFluidTankLong copy();

    public IFluidTankLong readFromNBT(NBTTagCompound var1);

    public NBTTagCompound writeToNBT(NBTTagCompound var1);
}

