/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fluid;

import com.cleanroommc.modularui.utils.fluid.IFluidTankLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;

public interface IFluidTanksHandler {
    public int getTanks();

    @Nonnull
    public IFluidTankLong getTank(int var1);

    @Nullable
    default public Fluid getFluidInTank(int tankSlot) {
        return this.getTank(tankSlot).getRealFluid();
    }

    default public long fill(int tankSlot, @Nonnull Fluid fluid, long amount, boolean doFill) {
        return this.getTank(tankSlot).fillLong(fluid, amount, doFill);
    }

    default public long drain(int tankSlot, long amount, boolean doDrain) {
        return this.getTank(tankSlot).drainLong(amount, doDrain);
    }

    default public long getTankCapacity(int tankSlot) {
        return this.getTank(tankSlot).getCapacityLong();
    }

    default public long getTankAmount(int tankSlot) {
        return this.getTank(tankSlot).getFluidAmountLong();
    }

    default public boolean isFluidValid(int tankSlot, Fluid fluid) {
        return true;
    }

    public void setFluidInTank(int var1, @Nullable Fluid var2, long var3);

    default public void setFluidInTank(int tankSlot, @Nullable Fluid fluid) {
        this.setFluidInTank(tankSlot, fluid, 0L);
    }

    default public void setFluidInTank(int tankSlot, @Nonnull IFluidTankLong tank) {
        this.setFluidInTank(tankSlot, tank.getRealFluid(), tank.getFluidAmountLong());
    }
}

