/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.api.value.sync.IServerKeyboardAction;
import com.cleanroommc.modularui.api.value.sync.IServerMouseAction;
import com.cleanroommc.modularui.utils.KeyboardData;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;

public class InteractionSyncHandler
extends SyncHandler {
    private IServerMouseAction mousePressed;
    private IServerMouseAction mouseReleased;
    private IServerMouseAction mouseTapped;
    private IServerMouseAction mouseScroll;
    private IServerKeyboardAction keyPressed;
    private IServerKeyboardAction keyReleased;
    private IServerKeyboardAction keyTapped;

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
        if (id < 10) {
            MouseData mouseData = MouseData.readPacket(buf);
            switch (id) {
                case 1: {
                    if (this.mousePressed == null) break;
                    this.mousePressed.onServerMouseAction(mouseData);
                    break;
                }
                case 2: {
                    if (this.mouseReleased == null) break;
                    this.mouseReleased.onServerMouseAction(mouseData);
                    break;
                }
                case 3: {
                    if (this.mouseTapped == null) break;
                    this.mouseTapped.onServerMouseAction(mouseData);
                    break;
                }
                case 4: {
                    if (this.mouseScroll == null) break;
                    this.mouseScroll.onServerMouseAction(mouseData);
                }
            }
        } else if (id > 10) {
            KeyboardData keyboardData = KeyboardData.readPacket(buf);
            switch (id) {
                case 11: {
                    if (this.keyPressed == null) break;
                    this.keyPressed.onServerKeyboardAction(keyboardData);
                    break;
                }
                case 12: {
                    if (this.keyReleased == null) break;
                    this.keyReleased.onServerKeyboardAction(keyboardData);
                    break;
                }
                case 13: {
                    if (this.keyTapped == null) break;
                    this.keyTapped.onServerKeyboardAction(keyboardData);
                }
            }
        }
    }

    public boolean onMousePressed(int button) {
        if (this.mousePressed == null) {
            return false;
        }
        MouseData mouseData = MouseData.create(button);
        this.mousePressed.onServerMouseAction(mouseData);
        this.syncToServer(1, mouseData::writeToPacket);
        return true;
    }

    public boolean onMouseReleased(int button) {
        if (this.mouseReleased == null) {
            return false;
        }
        MouseData mouseData = MouseData.create(button);
        this.mouseReleased.onServerMouseAction(mouseData);
        this.syncToServer(2, mouseData::writeToPacket);
        return true;
    }

    public boolean onMouseTapped(int button) {
        if (this.mouseTapped == null) {
            return false;
        }
        MouseData mouseData = MouseData.create(button);
        this.mouseTapped.onServerMouseAction(mouseData);
        this.syncToServer(3, mouseData::writeToPacket);
        return true;
    }

    public boolean onMouseScroll(int scroll) {
        if (this.mouseScroll == null) {
            return false;
        }
        MouseData mouseData = MouseData.create(scroll);
        this.mouseScroll.onServerMouseAction(mouseData);
        this.syncToServer(4, mouseData::writeToPacket);
        return true;
    }

    public boolean onKeyPressed(char character, int keycode) {
        if (this.keyPressed == null) {
            return false;
        }
        KeyboardData keyboardData = KeyboardData.create(character, keycode);
        this.keyPressed.onServerKeyboardAction(keyboardData);
        this.syncToServer(11, keyboardData::writeToPacket);
        return true;
    }

    public boolean onKeyReleased(char character, int keycode) {
        if (this.keyReleased == null) {
            return false;
        }
        KeyboardData keyboardData = KeyboardData.create(character, keycode);
        this.keyReleased.onServerKeyboardAction(keyboardData);
        this.syncToServer(12, keyboardData::writeToPacket);
        return true;
    }

    public boolean onKeyTapped(char character, int keycode) {
        if (this.keyTapped == null) {
            return false;
        }
        KeyboardData keyboardData = KeyboardData.create(character, keycode);
        this.keyTapped.onServerKeyboardAction(keyboardData);
        this.syncToServer(13, keyboardData::writeToPacket);
        return true;
    }

    public InteractionSyncHandler setOnMousePressed(IServerMouseAction mouseAction) {
        this.mousePressed = mouseAction;
        return this;
    }

    public InteractionSyncHandler setOnMouseReleased(IServerMouseAction mouseAction) {
        this.mouseReleased = mouseAction;
        return this;
    }

    public InteractionSyncHandler setOnMouseTapped(IServerMouseAction mouseAction) {
        this.mouseTapped = mouseAction;
        return this;
    }

    public InteractionSyncHandler setOnMouseScroll(IServerMouseAction mouseAction) {
        this.mouseScroll = mouseAction;
        return this;
    }

    public InteractionSyncHandler setOnKeyPressed(IServerKeyboardAction keyboardAction) {
        this.keyPressed = keyboardAction;
        return this;
    }

    public InteractionSyncHandler setOnKeyReleased(IServerKeyboardAction keyboardAction) {
        this.keyReleased = keyboardAction;
        return this;
    }

    public InteractionSyncHandler setOnKeyTapped(IServerKeyboardAction keyboardAction) {
        this.keyTapped = keyboardAction;
        return this;
    }
}

