/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.utils.Animator;
import com.cleanroommc.modularui.utils.Interpolation;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.MathHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ScrollData {
    private final GuiAxis axis;
    private final boolean axisStart;
    private final int thickness;
    private int scrollSpeed = 30;
    private int scrollSize;
    private int scroll;
    protected boolean dragging;
    private int animatingTo = 0;
    private final Animator scrollAnimator = new Animator(30, Interpolation.QUAD_OUT);

    protected ScrollData(GuiAxis axis, boolean axisStart, int thickness) {
        this.axis = axis;
        this.axisStart = axisStart;
        this.thickness = thickness <= 0 ? 4 : thickness;
    }

    public GuiAxis getAxis() {
        return this.axis;
    }

    public boolean isOnAxisStart() {
        return this.axisStart;
    }

    public int getThickness() {
        return this.thickness;
    }

    public int getScrollSpeed() {
        return this.scrollSpeed;
    }

    public void setScrollSpeed(int scrollSpeed) {
        this.scrollSpeed = scrollSpeed;
    }

    public int getScrollSize() {
        return this.scrollSize;
    }

    public void setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
    }

    public int getScroll() {
        return this.scroll;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isVertical() {
        return this.axis.isVertical();
    }

    public boolean isHorizontal() {
        return this.axis.isHorizontal();
    }

    protected final int getRawVisibleSize(ScrollArea area) {
        return Math.max(0, this.getRawFullVisibleSize(area) - area.getPadding().getTotal(this.axis));
    }

    protected final int getRawFullVisibleSize(ScrollArea area) {
        return area.getSize(this.axis);
    }

    public final int getFullVisibleSize(ScrollArea area) {
        return this.getFullVisibleSize(area, false);
    }

    public final int getFullVisibleSize(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawVisibleSize(area);
        ScrollData data = this.getOtherScrollData(area);
        if (data != null && (isOtherActive || data.isScrollBarActive(area, true))) {
            s -= data.getThickness();
        }
        return s;
    }

    public final int getVisibleSize(ScrollArea area) {
        return this.getVisibleSize(area, false);
    }

    public final int getVisibleSize(ScrollArea area, boolean isOtherActive) {
        return Math.max(0, this.getFullVisibleSize(area, isOtherActive) - area.getPadding().getTotal(this.axis));
    }

    public abstract float getProgress(ScrollArea var1, int var2, int var3);

    @Nullable
    public abstract ScrollData getOtherScrollData(ScrollArea var1);

    public void clamp(ScrollArea area) {
        int size = this.getVisibleSize(area);
        this.scroll = this.scrollSize <= size ? 0 : MathHelper.func_76125_a((int)this.scroll, (int)0, (int)(this.scrollSize - size));
    }

    public void scrollBy(ScrollArea area, int x) {
        this.scroll += x;
        this.clamp(area);
    }

    public void scrollTo(ScrollArea area, int x) {
        this.scroll = x;
        this.clamp(area);
    }

    public void animateTo(ScrollArea area, int x) {
        this.scrollAnimator.setCallback(value -> this.scrollTo(area, (int)value));
        this.scrollAnimator.setValueBounds(this.scroll, x);
        this.scrollAnimator.forward();
        this.animatingTo = x;
    }

    public final boolean isScrollBarActive(ScrollArea area) {
        return this.isScrollBarActive(area, false);
    }

    public final boolean isScrollBarActive(ScrollArea area, boolean isOtherActive) {
        int s = this.getRawVisibleSize(area);
        if (s < this.scrollSize) {
            return true;
        }
        ScrollData data = this.getOtherScrollData(area);
        if (data == null || s - data.getThickness() >= this.scrollSize) {
            return false;
        }
        if (isOtherActive || data.isScrollBarActive(area, true)) {
            s -= data.getThickness();
        }
        return s < this.scrollSize;
    }

    public final boolean isOtherScrollBarActive(ScrollArea area, boolean isSelfActive) {
        ScrollData data = this.getOtherScrollData(area);
        return data != null && data.isScrollBarActive(area, isSelfActive);
    }

    public int getScrollBarLength(ScrollArea area) {
        boolean isOtherActive = this.isOtherScrollBarActive(area, false);
        return (int)((float)(this.getVisibleSize(area, isOtherActive) * this.getFullVisibleSize(area, isOtherActive)) / (float)this.scrollSize);
    }

    public abstract boolean isInsideScrollbarArea(ScrollArea var1, int var2, int var3);

    public boolean isAnimating() {
        return this.scrollAnimator.isRunning();
    }

    public int getAnimatingTo() {
        return this.animatingTo;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void drawScrollbar(ScrollArea var1);

    @SideOnly(value=Side.CLIENT)
    protected void drawScrollBar(int x, int y, int w, int h) {
        GuiDraw.drawRect(x, y, w, h, -1118482);
        GuiDraw.drawRect(x + 1, y + 1, w - 1, h - 1, -10066330);
        GuiDraw.drawRect(x + 1, y + 1, w - 2, h - 2, -5592406);
    }

    public abstract boolean onMouseClicked(ScrollArea var1, int var2, int var3, int var4);
}

