/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth;

import com.sintinium.oauth.EncryptionUtil;
import cpw.mods.fml.common.FMLLog;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class OAuthConfig {
    private static Property lastUsername;
    private static Property lastPassword;
    private static Configuration cfg;

    public static void load(Configuration cfg) {
        OAuthConfig.cfg = cfg;
        try {
            cfg.load();
            lastUsername = cfg.get("oauth", "Last Username", "");
            OAuthConfig.lastUsername.comment = "THIS SHOULDN'T BE EDITED BY HAND! \nLast username used to login to Mojang if saved.";
            lastPassword = cfg.get("oauth", "Last Password", "");
            OAuthConfig.lastPassword.comment = "THIS SHOULDN'T BE EDITED BY HAND! \nLast password used to login to Mojang if saved. (Encrypted)";
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Error Message", (Object[])new Object[0]);
        }
        finally {
            cfg.save();
        }
    }

    public static String getUsername() {
        return lastUsername.getString();
    }

    public static void setUsername(String username) {
        lastUsername.set(username);
        cfg.save();
    }

    public static String getPassword() {
        return EncryptionUtil.decryptString(lastPassword.getString(), Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replaceAll("\\\\", "/"));
    }

    public static void setPassword(String password) {
        lastPassword.set(EncryptionUtil.encryptString(password, Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replaceAll("\\\\", "/")));
        cfg.save();
    }

    public static void removeUsernamePassword() {
        lastUsername.set("");
        lastPassword.set("");
        cfg.save();
    }

    public static boolean isSavedPassword() {
        return !lastUsername.getString().isEmpty() && !lastPassword.getString().isEmpty();
    }
}

