/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter.mixin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinProcessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.transformer.Proxy;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.service.mojang.MixinServiceLaunchWrapper;
import zone.rong.mixinbooter.ILateMixinLoader;
import zone.rong.mixinbooter.MixinBooterPlugin;
import zone.rong.mixinbooter.MixinLoader;
import zone.rong.mixinbooter.fix.MixinFixer;

@Mixin(value={LoadController.class}, remap=false)
public class LoadControllerMixin {
    @Shadow
    private Loader loader;

    @Inject(method={"distributeStateMessage(Lnet/minecraftforge/fml/common/LoaderState;[Ljava/lang/Object;)V"}, at={@At(value="HEAD")})
    private void beforeConstructing(LoaderState state, Object[] eventData, CallbackInfo ci) throws Throwable {
        if (state == LoaderState.CONSTRUCTING) {
            Set<String> unconventionalConfigs;
            Object clazz;
            ModClassLoader modClassLoader = (ModClassLoader)eventData[0];
            ASMDataTable asmDataTable = (ASMDataTable)eventData[1];
            for (ModContainer container : this.loader.getActiveModList()) {
                modClassLoader.addFile(container.getSource());
            }
            Set interfaceData = asmDataTable.getAll(ILateMixinLoader.class.getName().replace('.', '/'));
            HashSet<ILateMixinLoader> lateLoaders = new HashSet<ILateMixinLoader>();
            Set annotatedData = asmDataTable.getAll(MixinLoader.class.getName());
            if (!annotatedData.isEmpty()) {
                for (ASMDataTable.ASMData aSMData : annotatedData) {
                    clazz = Class.forName(aSMData.getClassName());
                    MixinBooterPlugin.LOGGER.info("Instantiating @MixinLoader annotated class: " + clazz);
                    Object instance = ((Class)clazz).newInstance();
                    if (!(instance instanceof ILateMixinLoader)) continue;
                    lateLoaders.add((ILateMixinLoader)instance);
                }
            }
            if (!interfaceData.isEmpty()) {
                for (ASMDataTable.ASMData aSMData : interfaceData) {
                    clazz = Class.forName(aSMData.getClassName().replace('/', '.'));
                    MixinBooterPlugin.LOGGER.info("Instantiating ILateMixinLoader class: " + clazz);
                    lateLoaders.add((ILateMixinLoader)((Class)clazz).newInstance());
                }
                for (ILateMixinLoader iLateMixinLoader : lateLoaders) {
                    for (String mixinConfig : iLateMixinLoader.getMixinConfigs()) {
                        if (!iLateMixinLoader.shouldMixinConfigQueue(mixinConfig)) continue;
                        MixinBooterPlugin.LOGGER.info("Adding " + mixinConfig + " mixin configuration.");
                        Mixins.addConfiguration(mixinConfig);
                        iLateMixinLoader.onMixinConfigQueued(mixinConfig);
                    }
                }
            }
            if (!(unconventionalConfigs = MixinFixer.retrieveLateMixinConfigs()).isEmpty()) {
                MixinBooterPlugin.LOGGER.info("Appending unconventional mixin configurations...");
                for (String unconventionalConfig : unconventionalConfigs) {
                    MixinBooterPlugin.LOGGER.info("Adding " + unconventionalConfig + " mixin configuration.");
                    Mixins.addConfiguration(unconventionalConfig);
                }
            }
            Field field = MixinServiceLaunchWrapper.class.getDeclaredField("delegatedTransformers");
            field.setAccessible(true);
            field.set(MixinService.getService(), null);
            IMixinProcessor processor = Proxy.transformer.getProcessor();
            Method selectMethod = processor.getClass().getDeclaredMethod("select", MixinEnvironment.class);
            selectMethod.setAccessible(true);
            selectMethod.invoke((Object)processor, MixinEnvironment.getCurrentEnvironment());
        }
    }
}

