/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.mekanism.gas;

import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.integration.mekanism.gas.AEGasStack;
import com.the9grounds.aeadditions.integration.mekanism.gas.GasList;
import com.the9grounds.aeadditions.item.ItemGas;
import com.the9grounds.aeadditions.util.GasUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GasStorageChannel
implements IGasStorageChannel {
    public int getUnitsPerByte() {
        return 8000;
    }

    @Nonnull
    public IItemList<IAEGasStack> createList() {
        return new GasList();
    }

    @Nullable
    public IAEGasStack readFromPacket(@Nonnull ByteBuf byteBuf) throws IOException {
        return new AEGasStack(byteBuf);
    }

    @Nullable
    public IAEGasStack createFromNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        return new AEGasStack(nbtTagCompound);
    }

    @Nullable
    public IAEGasStack createStack(@Nonnull Object o) {
        if (o instanceof Gas) {
            return new AEGasStack(new GasStack((Gas)o, 1000));
        }
        if (o instanceof GasStack) {
            return new AEGasStack((GasStack)o);
        }
        if (o instanceof AEGasStack) {
            return new AEGasStack((AEGasStack)o);
        }
        if (o instanceof ItemStack && ((ItemStack)o).func_77973_b() instanceof ItemGas) {
            String gasName = ItemGas.getGasName((ItemStack)o);
            return new AEGasStack(new GasStack(GasRegistry.getGas((String)gasName), 1000));
        }
        if (o instanceof Fluid) {
            Fluid fluid = (Fluid)o;
            if (GasUtil.isGas(fluid)) {
                return new AEGasStack(GasUtil.getGasStack(new FluidStack(fluid, 1000)));
            }
            Gas gas = GasRegistry.getGas((Fluid)fluid);
            if (gas != null) {
                return new AEGasStack(new GasStack(gas, 1000));
            }
        } else if (o instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)o;
            if (fluidStack.getFluid() == null) {
                return null;
            }
            if (GasUtil.isGas(fluidStack)) {
                return new AEGasStack(GasUtil.getGasStack(fluidStack));
            }
            return this.createStack(fluidStack.getFluid());
        }
        return null;
    }
}

