/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.opencomputers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.integration.opencomputers.DriverBase;
import com.the9grounds.aeadditions.integration.opencomputers.OCUtils;
import com.the9grounds.aeadditions.part.gas.PartGasImport;
import com.the9grounds.aeadditions.registries.PartEnum;
import com.the9grounds.aeadditions.util.GasUtil;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DriverGasImportBus
extends DriverBase<PartGasImport> {
    public DriverGasImportBus() {
        super(PartEnum.GASIMPORT, Enviroment.class);
    }

    @Override
    protected ManagedEnvironment createEnvironment(IPartHost host) {
        return new Enviroment(host);
    }

    private static PartGasImport getImportBus(World world, BlockPos pos, AEPartLocation dir) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IPartHost)) {
            return null;
        }
        IPartHost host = (IPartHost)tile;
        if (dir == null || dir == AEPartLocation.INTERNAL) {
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                IPart part = host.getPart(side);
                if (part == null || !(part instanceof PartGasImport)) continue;
                return (PartGasImport)part;
            }
            return null;
        }
        IPart part = host.getPart(dir);
        return part == null ? null : (part instanceof PartGasImport ? (PartGasImport)part : null);
    }

    public class Enviroment
    extends AbstractManagedEnvironment
    implements NamedBlock {
        protected final TileEntity tile;
        protected final IPartHost host;

        public Enviroment(IPartHost host) {
            this.tile = (TileEntity)host;
            this.host = host;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("me_importbus").create());
        }

        @Callback(doc="function(side:number, [ slot:number]):table -- Get the configuration of the gas import bus pointing in the specified direction.")
        public Object[] getGasImportConfiguration(Context context, Arguments args) {
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{null, "unknown side"};
            }
            PartGasImport part = (PartGasImport)OCUtils.getPart(this.tile.func_145831_w(), this.tile.func_174877_v(), dir, PartGasImport.class);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            int slot = args.optInteger(1, 4);
            try {
                Fluid fluid = part.filterFluids[slot];
                if (fluid == null) {
                    return new Object[]{null};
                }
                return new Object[]{GasUtil.getGasStack(new FluidStack(fluid, 1000))};
            }
            catch (Throwable e) {
                return new Object[]{null, "Invalid slot"};
            }
        }

        @Callback(doc="function(side:number[, slot:number][, database:address, entry:number]):boolean -- Configure the gas import bus pointing in the specified direction to export gas stacks matching the specified descriptor.")
        public Object[] setGasImportConfiguration(Context context, Arguments args) {
            int slot;
            int entry;
            String address;
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{null, "unknown side"};
            }
            PartGasImport part = (PartGasImport)OCUtils.getPart(this.tile.func_145831_w(), this.tile.func_174877_v(), dir, PartGasImport.class);
            if (part == null) {
                return new Object[]{null, "no export bus"};
            }
            if (args.count() == 3) {
                address = args.checkString(1);
                entry = args.checkInteger(2);
                slot = 4;
            } else {
                if (args.count() < 3) {
                    int slot2 = args.optInteger(1, 4);
                    try {
                        part.filterFluids[slot2] = null;
                        part.onInventoryChanged();
                        context.pause(0.5);
                        return new Object[]{true};
                    }
                    catch (Throwable e) {
                        return new Object[]{false, "invalid slot"};
                    }
                }
                slot = args.optInteger(1, 4);
                address = args.checkString(2);
                entry = args.checkInteger(3);
            }
            Node node = this.node().network().node(address);
            if (node == null) {
                throw new IllegalArgumentException("no such component");
            }
            if (!(node instanceof Component)) {
                throw new IllegalArgumentException("no such component");
            }
            Component component = (Component)node;
            Environment env = node.host();
            if (!(env instanceof Database)) {
                throw new IllegalArgumentException("not a database");
            }
            Database database = (Database)env;
            try {
                ItemStack data = database.getStackInSlot(entry - 1);
                if (data == null) {
                    part.filterFluids[slot] = null;
                } else {
                    GasStack fluid = GasUtil.getGasFromContainer(data);
                    if (fluid == null || fluid.getGas() == null) {
                        return new Object[]{false, "not a fluid container"};
                    }
                    part.filterFluids[slot] = GasUtil.getFluidStack(fluid).getFluid();
                }
                part.onInventoryChanged();
                context.pause(0.5);
                return new Object[]{true};
            }
            catch (Throwable e) {
                return new Object[]{false, "invalid slot"};
            }
        }

        @Callback(doc="function(side:number, amount:number):boolean -- Make the gas import bus facing the specified direction perform a single import operation.")
        public Object[] importGas(Context context, Arguments args) {
            AEPartLocation dir = AEPartLocation.fromOrdinal((int)args.checkInteger(0));
            if (dir == null || dir == AEPartLocation.INTERNAL) {
                return new Object[]{false, "unknown side"};
            }
            PartGasImport part = DriverGasImportBus.getImportBus(this.tile.func_145831_w(), this.tile.func_174877_v(), dir);
            if (part == null) {
                return new Object[]{false, "no export bus"};
            }
            if (part.getFacingTank() == null) {
                return new Object[]{false, "no tank"};
            }
            int amount = Math.min(args.optInteger(1, 625), 125 + part.getSpeedState() * 125);
            boolean didSomething = part.doWork(amount, 1);
            if (didSomething) {
                context.pause(0.25);
            }
            return new Object[]{didSomething};
        }

        public String preferredName() {
            return "me_importbus";
        }

        public int priority() {
            return 1;
        }
    }
}

