/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.inventory;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class ECCellInventory
implements IInventory {
    private ItemStack storage;
    private String tagId;
    private NBTTagCompound tagCompound;
    private int size;
    private int stackLimit;
    private ItemStack[] slots;
    private boolean dirty = false;

    public ECCellInventory(ItemStack storage, String tagId, int size, int stackLimit) {
        this.storage = storage;
        this.tagId = tagId;
        this.size = size;
        this.stackLimit = stackLimit;
        this.slots = new ItemStack[size];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = ItemStack.field_190927_a;
        }
        if (!this.storage.func_77942_o()) {
            this.storage.func_77982_d(new NBTTagCompound());
        }
        this.storage.func_77978_p().func_74782_a(this.tagId, (NBTBase)this.storage.func_77978_p().func_74775_l(this.tagId));
        this.tagCompound = this.storage.func_77978_p().func_74775_l(this.tagId);
        this.openInventory();
    }

    public void func_174886_c(EntityPlayer player) {
        this.closeInventory();
    }

    private void closeInventory() {
        if (this.dirty) {
            for (int i = 0; i < this.slots.length; ++i) {
                this.tagCompound.func_82580_o("ItemStack#" + i);
                ItemStack content = this.slots[i];
                if (content == null) continue;
                this.tagCompound.func_74782_a("ItemStack#" + i, (NBTBase)new NBTTagCompound());
                content.func_77955_b(this.tagCompound.func_74775_l("ItemStack#" + i));
            }
        }
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(Arrays.asList(this.slots), (int)slotId, (int)amount);
        if (itemStack != null && !itemStack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public String func_70005_c_() {
        return "";
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public int func_70302_i_() {
        return this.size;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null || this.slots[i].func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_70301_a(int slotId) {
        return this.slots[slotId];
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(Arrays.asList(this.slots), (int)index);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slotId, ItemStack itemStack) {
        return true;
    }

    public void func_70296_d() {
        this.dirty = true;
        this.closeInventory();
        this.dirty = false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
        this.slots = new ItemStack[this.size];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new ItemStack(this.tagCompound.func_74775_l("ItemStack#" + i));
        }
    }

    private void openInventory() {
        this.slots = new ItemStack[this.size];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new ItemStack(this.tagCompound.func_74775_l("ItemStack#" + i));
        }
    }

    public void func_70299_a(int slotId, ItemStack content) {
        ItemStack slotContent = this.slots[slotId];
        if (slotContent != content) {
            this.slots[slotId] = content;
            this.func_70296_d();
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = ItemStack.field_190927_a;
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isSlotEmpty(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.slots[slot].func_77946_l();
        if (amount >= stack.func_190916_E()) {
            if (!simulate) {
                this.slots[slot] = null;
            }
            return stack;
        }
        stack.func_190920_e(amount);
        if (!simulate) {
            this.slots[slot].func_190920_e(this.slots[slot].func_190916_E() - amount);
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return this.slots[slot] == null || this.slots[slot].func_190926_b() ? 64 : this.slots[slot].func_77976_d();
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        if (!this.func_94041_b(slot, stack)) {
            return ItemStack.field_190927_a;
        }
        if (this.isSlotEmpty(slot)) {
            if (!simulate) {
                this.slots[slot] = stack;
            }
            return stack;
        }
        ItemStack oldStack = this.slots[slot];
        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)oldStack) && oldStack.func_77976_d() > oldStack.func_190916_E()) {
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(Math.min(newStack.func_190916_E(), oldStack.func_77976_d() - oldStack.func_190916_E()));
            if (!simulate) {
                oldStack.func_190920_e(oldStack.func_190916_E() + newStack.func_190916_E());
            }
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isSlotEmpty(int slot) {
        return this.slots[slot] == null || this.slots[slot].func_190926_b();
    }

    public int getSlots() {
        return this.slots.length;
    }
}

