/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.inventory;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import com.the9grounds.aeadditions.part.fluid.PartFluidInterface;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class FluidInterfaceInventory
implements IInventory {
    private PartFluidInterface part;
    private ItemStack[] inv = new ItemStack[9];

    public FluidInterfaceInventory(PartFluidInterface part) {
        this.part = part;
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = ItemStack.field_190927_a;
        }
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && !stack.func_190926_b()) {
            if (stack.func_190916_E() <= amt) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((stack = stack.func_77979_a(amt)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        this.onContentsChanged();
        this.part.markForUpdate();
        return stack;
    }

    public ItemStack[] getInv() {
        return this.inv;
    }

    public String func_70005_c_() {
        return I18n.func_74838_a((String)"inventory.fluidInterface");
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 1;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null || this.inv[i].func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof ICraftingPatternItem) {
            World world = this.part.getWorld();
            if (world == null) {
                return false;
            }
            ICraftingPatternDetails details = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, world);
            return details != null;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = new ItemStack(tag);
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && !stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
            this.onContentsChanged();
        }
        this.part.markForUpdate();
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    protected void onContentsChanged() {
    }
}

