/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item;

import com.the9grounds.aeadditions.item.ItemFluid;
import com.the9grounds.aeadditions.models.IItemModelRegister;
import com.the9grounds.aeadditions.models.ModelManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0017J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0017\u00a8\u0006\u0018"}, d2={"Lcom/the9grounds/aeadditions/item/ItemFluid;", "Lnet/minecraft/item/Item;", "Lcom/the9grounds/aeadditions/models/IItemModelRegister;", "()V", "getItemStackDisplayName", "", "stack", "Lnet/minecraft/item/ItemStack;", "getSubItems", "", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "subItems", "Lnet/minecraft/util/NonNullList;", "initCapabilities", "Lnet/minecraftforge/common/capabilities/ICapabilityProvider;", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "registerModel", "item", "manager", "Lcom/the9grounds/aeadditions/models/ModelManager;", "Companion", "ItemFluidHandlerItemStack", "AEAdditions-1.12.2"})
public final class ItemFluid
extends Item
implements IItemModelRegister {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return (ICapabilityProvider)new ItemFluidHandlerItemStack(stack, 1000);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(@NotNull Item item, @NotNull ModelManager manager) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        manager.registerItemModel(item, registerModel.1.INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        Intrinsics.checkParameterIsNotNull((Object)tab, (String)"tab");
        Intrinsics.checkParameterIsNotNull(subItems, (String)"subItems");
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack itemStack = new ItemStack((Item)this);
            Companion.setFluid(itemStack, new FluidStack(fluid, 1));
            subItems.add((Object)itemStack);
        }
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        FluidStack fluidStack = Companion.getFluid(stack);
        if (fluidStack == null) {
            return "null";
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid != null) {
            String string2 = fluid.getLocalizedName(new FluidStack(fluid, 1000));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fluid.getLocalizedName(F\u2026id, Fluid.BUCKET_VOLUME))");
        } else {
            string = "null";
        }
        return string;
    }

    @JvmStatic
    public static final void setFluid(@NotNull ItemStack itemStack, @NotNull FluidStack fluidStack) {
        Companion.setFluid(itemStack, fluidStack);
    }

    @JvmStatic
    @Nullable
    public static final FluidStack getFluid(@NotNull ItemStack itemStack) {
        return Companion.getFluid(itemStack);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/the9grounds/aeadditions/item/ItemFluid$ItemFluidHandlerItemStack;", "Lnet/minecraftforge/fluids/capability/templates/FluidHandlerItemStack;", "stack", "Lnet/minecraft/item/ItemStack;", "capacity", "", "(Lnet/minecraft/item/ItemStack;I)V", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "doDrain", "", "AEAdditions-1.12.2"})
    public static final class ItemFluidHandlerItemStack
    extends FluidHandlerItemStack {
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain <= 0) {
                return null;
            }
            FluidStack contained = this.getFluid();
            if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
                return null;
            }
            int drainAmount = Math.min(contained.amount, maxDrain);
            FluidStack drained = contained.copy();
            drained.amount = drainAmount;
            if (doDrain) {
                contained.amount -= drainAmount;
                if (contained.amount == 0) {
                    this.setContainerToEmpty();
                } else {
                    this.setFluid(contained);
                }
            }
            return drained;
        }

        public ItemFluidHandlerItemStack(@NotNull ItemStack stack, int capacity) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            super(stack, capacity);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lcom/the9grounds/aeadditions/item/ItemFluid$Companion;", "", "()V", "getFluid", "Lnet/minecraftforge/fluids/FluidStack;", "itemStack", "Lnet/minecraft/item/ItemStack;", "setFluid", "", "fluidStack", "AEAdditions-1.12.2"})
    public static final class Companion {
        @JvmStatic
        public final void setFluid(@NotNull ItemStack itemStack, @NotNull FluidStack fluidStack) {
            Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
            Intrinsics.checkParameterIsNotNull((Object)fluidStack, (String)"fluidStack");
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            fluidStack.writeToNBT(nbtTagCompound);
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_74782_a("Fluid", (NBTBase)nbtTagCompound);
        }

        @JvmStatic
        @Nullable
        public final FluidStack getFluid(@NotNull ItemStack itemStack) {
            NBTTagCompound tagCompound;
            Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
            if (!itemStack.func_77942_o()) {
                return null;
            }
            NBTTagCompound nBTTagCompound = tagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("Fluid"));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

