/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.util.AEColor;
import com.the9grounds.aeadditions.item.IColoredItem;
import com.the9grounds.aeadditions.item.ItemECBase;
import com.the9grounds.aeadditions.models.ModelManager;
import com.the9grounds.aeadditions.registries.PartEnum;
import com.the9grounds.aeadditions.util.Log;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPartECBase
extends ItemECBase
implements IPartItem,
IItemGroup,
IColoredItem {
    public ItemPartECBase() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        for (PartEnum part : PartEnum.values()) {
            Map<Upgrades, Integer> possibleUpgradesList = part.getUpgrades();
            for (Upgrades upgrade : possibleUpgradesList.keySet()) {
                upgrade.registerItem(new ItemStack((Item)this, 1, part.ordinal()), possibleUpgradesList.get(upgrade).intValue());
            }
        }
    }

    public IPart createPartFromItemStack(ItemStack itemStack) {
        try {
            return PartEnum.values()[MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(PartEnum.values().length - 1))].newInstance(itemStack);
        }
        catch (Throwable ex) {
            Log.fatalError(itemStack.toString(), ex);
            return null;
        }
    }

    public String func_77653_i(ItemStack stack) {
        if (stack == null) {
            return super.func_77653_i(null);
        }
        return super.func_77653_i(stack);
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77952_i() == PartEnum.OREDICTEXPORTBUS.ordinal()) {
            return super.func_77613_e(itemStack);
        }
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList itemList) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < PartEnum.values().length; ++i) {
            PartEnum part = PartEnum.values()[i];
            if (part.getMod() != null && !part.getMod().isEnabled()) continue;
            itemList.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    public String getUnlocalizedGroupName(Set<ItemStack> otherItems, ItemStack itemStack) {
        return PartEnum.values()[MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(PartEnum.values().length - 1))].getGroupName();
    }

    public String func_77667_c(ItemStack itemStack) {
        return PartEnum.values()[MathHelper.func_76125_a((int)itemStack.func_77952_i(), (int)0, (int)(PartEnum.values().length - 1))].getTranslationKey();
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return AEApi.instance().partHelper().placeBus(playerIn.func_184586_b(hand), pos, facing, playerIn, hand, worldIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        for (PartEnum type : PartEnum.values()) {
            Optional<ModelResourceLocation> location = type.getItemModel();
            if (!location.isPresent()) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)type.ordinal(), (ModelResourceLocation)location.get());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        int colorIndex = tintIndex / 10;
        int index = tintIndex % 10;
        AEColor color = AEColor.values()[colorIndex];
        return color.getVariantByTintIndex(index);
    }
}

