/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.models;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import org.lwjgl.util.vector.Vector3f;

public class ModelFactory {
    private static final FaceBakery bakery = new FaceBakery();

    public static ImmutableList<BakedQuad> createCube(Vector3f from, Vector3f to, TextureAtlasSprite sprite) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            builder.add((Object)ModelFactory.createQuad(facing, from, to, sprite));
        }
        return builder.build();
    }

    public static ImmutableList<BakedQuad> createCubeOpen(Vector3f from, Vector3f to, TextureAtlasSprite sprite, List<EnumFacing> openSides) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (openSides.contains(facing)) continue;
            builder.add((Object)ModelFactory.createQuad(facing, from, to, sprite));
        }
        return builder.build();
    }

    public static BakedQuad createQuad(EnumFacing facing, Vector3f from, Vector3f to, TextureAtlasSprite sprite) {
        float[] uvs = ModelFactory.getFaceUvs(facing, to, from);
        BlockFaceUV uv = new BlockFaceUV(uvs, 0);
        BlockPartFace bpf = new BlockPartFace(facing, 0, "", uv);
        return bakery.func_178414_a(from, to, bpf, sprite, facing, ModelRotation.X0_Y0, null, true, true);
    }

    protected static float[] getFaceUvs(EnumFacing face, Vector3f to, Vector3f from) {
        float maxV;
        float maxU;
        float minV;
        float minU;
        switch (face) {
            case SOUTH: {
                minU = from.x;
                minV = from.y;
                maxU = to.x;
                maxV = to.y;
                break;
            }
            case NORTH: {
                minU = from.x;
                minV = from.y;
                maxU = to.x;
                maxV = to.y;
                break;
            }
            case WEST: {
                minU = from.z;
                minV = from.y;
                maxU = to.z;
                maxV = to.y;
                break;
            }
            case EAST: {
                minU = from.z;
                minV = from.y;
                maxU = to.z;
                maxV = to.y;
                break;
            }
            case UP: {
                minU = from.x;
                minV = from.z;
                maxU = to.x;
                maxV = to.z;
                break;
            }
            case DOWN: {
                minU = from.x;
                minV = from.z;
                maxU = to.x;
                maxV = to.z;
                break;
            }
            default: {
                minU = 0.0f;
                minV = 0.0f;
                maxU = 16.0f;
                maxV = 16.0f;
            }
        }
        if (minU < 0.0f || maxU > 16.0f) {
            minU = 0.0f;
            maxU = 16.0f;
        }
        if (minV < 0.0f || maxV > 16.0f) {
            minV = 0.0f;
            maxV = 16.0f;
        }
        minU = 16.0f - minU;
        minV = 16.0f - minV;
        maxU = 16.0f - maxU;
        maxV = 16.0f - maxV;
        return new float[]{minU, minV, maxU, maxV};
    }
}

