/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.AEAdditions;
import com.the9grounds.aeadditions.api.IPortableFluidStorageCell;
import com.the9grounds.aeadditions.api.IPortableGasStorageCell;
import com.the9grounds.aeadditions.api.IWirelessFluidTermHandler;
import com.the9grounds.aeadditions.api.IWirelessGasTermHandler;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.block.IGuiBlock;
import com.the9grounds.aeadditions.container.ContainerStorage;
import com.the9grounds.aeadditions.container.fluid.ContainerFluidStorage;
import com.the9grounds.aeadditions.container.gas.ContainerGasStorage;
import com.the9grounds.aeadditions.gui.GuiStorage;
import com.the9grounds.aeadditions.integration.mekanism.gas.MEMonitorFluidGasWrapper;
import com.the9grounds.aeadditions.network.IGuiProvider;
import com.the9grounds.aeadditions.part.PartECBase;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J+\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u001dJ4\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J4\u0010 \u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0007J8\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0007J8\u0010(\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0007J>\u0010)\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J3\u0010/\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\u00101J8\u0010/\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0007J\u0018\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u00064"}, d2={"Lcom/the9grounds/aeadditions/network/GuiHandler;", "Lnet/minecraftforge/fml/common/network/IGuiHandler;", "()V", "hand", "Lnet/minecraft/util/EnumHand;", "getHand", "()Lnet/minecraft/util/EnumHand;", "setHand", "(Lnet/minecraft/util/EnumHand;)V", "temp", "", "", "getTemp", "()[Ljava/lang/Object;", "setTemp", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "getClientGuiElement", "id", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "x", "y", "z", "getContainer", "args", "(ILnet/minecraft/entity/player/EntityPlayer;[Ljava/lang/Object;)Ljava/lang/Object;", "getContainerBlockElement", "getGui", "getGuiBlockElement", "getGuiId", "part", "Lcom/the9grounds/aeadditions/part/PartECBase;", "guiId", "getPartContainer", "side", "Lnet/minecraft/util/EnumFacing;", "getPartGui", "getServerGuiElement", "hasPermissions", "", "pos", "Lnet/minecraft/util/math/BlockPos;", "Lappeng/api/util/AEPartLocation;", "launchGui", "", "(ILnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/EnumHand;[Ljava/lang/Object;)V", "securityCheck", "tileEntity", "AEAdditions-1.12.2"})
public final class GuiHandler
implements IGuiHandler {
    @Nullable
    private static EnumHand hand;
    @NotNull
    private static Object[] temp;
    public static final GuiHandler INSTANCE;

    @Nullable
    public final EnumHand getHand() {
        return hand;
    }

    public final void setHand(@Nullable EnumHand enumHand) {
        hand = enumHand;
    }

    @NotNull
    public final Object[] getTemp() {
        return temp;
    }

    public final void setTemp(@NotNull Object[] objectArray) {
        Intrinsics.checkParameterIsNotNull((Object)objectArray, (String)"<set-?>");
        temp = objectArray;
    }

    @Nullable
    public final Object getContainer(int id, @NotNull EntityPlayer player, @NotNull Object[] args) {
        ContainerStorage containerStorage;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        switch (id) {
            case 0: {
                Object object = args[0];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type appeng.api.storage.IMEMonitor<appeng.api.storage.data.IAEFluidStack>");
                }
                IMEMonitor fluidInventory = (IMEMonitor)object;
                containerStorage = new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory, player, hand);
                break;
            }
            case 1: {
                Object object = args[0];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type appeng.api.storage.IMEMonitor<appeng.api.storage.data.IAEFluidStack>");
                }
                IMEMonitor fluidInventory = (IMEMonitor)object;
                Object object2 = args[1];
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.api.IWirelessFluidTermHandler");
                }
                IWirelessFluidTermHandler handler = (IWirelessFluidTermHandler)object2;
                containerStorage = new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory, player, handler, hand);
                break;
            }
            case 3: {
                Object object = args[0];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type appeng.api.storage.IMEMonitor<appeng.api.storage.data.IAEFluidStack>");
                }
                IMEMonitor fluidInventory = (IMEMonitor)object;
                Object object3 = args[1];
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.api.IPortableFluidStorageCell");
                }
                IPortableFluidStorageCell storageCell = (IPortableFluidStorageCell)object3;
                containerStorage = new ContainerFluidStorage((IMEMonitor<IAEFluidStack>)fluidInventory, player, storageCell, hand);
                break;
            }
            case 4: {
                Object object = args[0];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type appeng.api.storage.IMEMonitor<com.the9grounds.aeadditions.api.gas.IAEGasStack>");
                }
                MEMonitorFluidGasWrapper gasInventory = new MEMonitorFluidGasWrapper((IMEMonitor<IAEGasStack>)((IMEMonitor)object));
                containerStorage = new ContainerGasStorage((IMEMonitor<IAEFluidStack>)((IMEMonitor)gasInventory), player, hand);
                break;
            }
            case 5: {
                Object object = args[0];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type appeng.api.storage.IMEMonitor<com.the9grounds.aeadditions.api.gas.IAEGasStack>");
                }
                MEMonitorFluidGasWrapper gasInventory = new MEMonitorFluidGasWrapper((IMEMonitor<IAEGasStack>)((IMEMonitor)object));
                Object object4 = args[1];
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.api.IWirelessGasTermHandler");
                }
                IWirelessGasTermHandler handler = (IWirelessGasTermHandler)object4;
                containerStorage = new ContainerGasStorage((IMEMonitor<IAEFluidStack>)((IMEMonitor)gasInventory), player, handler, hand);
                break;
            }
            case 6: {
                Object object = args[0];
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type appeng.api.storage.IMEMonitor<com.the9grounds.aeadditions.api.gas.IAEGasStack>");
                }
                MEMonitorFluidGasWrapper gasInventory = new MEMonitorFluidGasWrapper((IMEMonitor<IAEGasStack>)((IMEMonitor)object));
                Object object5 = args[1];
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.api.IPortableGasStorageCell");
                }
                IPortableGasStorageCell storageCell = (IPortableGasStorageCell)object5;
                containerStorage = new ContainerGasStorage((IMEMonitor<IAEFluidStack>)((IMEMonitor)gasInventory), player, storageCell, hand);
                break;
            }
            default: {
                containerStorage = null;
            }
        }
        return containerStorage;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public final Object getGui(int id, @NotNull EntityPlayer player) {
        GuiStorage guiStorage;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        switch (id) {
            case 0: {
                guiStorage = new GuiStorage(new ContainerFluidStorage(player, hand), "com.the9grounds.aeadditions.part.fluid.terminal.name");
                break;
            }
            case 1: {
                guiStorage = new GuiStorage(new ContainerFluidStorage(player, hand), "com.the9grounds.aeadditions.part.fluid.terminal.name");
                break;
            }
            case 3: {
                guiStorage = new GuiStorage(new ContainerFluidStorage(player, hand), "com.the9grounds.aeadditions.item.storage.fluid.portable.name");
                break;
            }
            case 4: {
                guiStorage = new GuiStorage(new ContainerGasStorage(player, hand), "com.the9grounds.aeadditions.part.gas.terminal.name");
                break;
            }
            case 5: {
                guiStorage = new GuiStorage(new ContainerGasStorage(player, hand), "com.the9grounds.aeadditions.part.gas.terminal.name");
                break;
            }
            case 6: {
                guiStorage = new GuiStorage(new ContainerGasStorage(player, hand), "com.the9grounds.aeadditions.item.storage.gas.portable.name");
                break;
            }
            default: {
                guiStorage = null;
            }
        }
        return guiStorage;
    }

    @JvmStatic
    public static final int getGuiId(int guiId) {
        return guiId + 6;
    }

    @JvmStatic
    public static final int getGuiId(@NotNull PartECBase part) {
        Intrinsics.checkParameterIsNotNull((Object)part, (String)"part");
        return part.getFacing().ordinal();
    }

    @JvmStatic
    @NotNull
    public static final Object getPartContainer(@NotNull EnumFacing side, @NotNull EntityPlayer player, @NotNull World world, int x, int y, int z) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.parts.IPartHost");
        }
        IPart iPart = ((IPartHost)tileEntity).getPart(side);
        if (iPart == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.part.PartECBase");
        }
        Object object = ((PartECBase)iPart).getServerGuiElement(player);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"((world.getTileEntity(Bl\u2026tServerGuiElement(player)");
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Object getPartGui(@NotNull EnumFacing side, @NotNull EntityPlayer player, @NotNull World world, int x, int y, int z) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.parts.IPartHost");
        }
        IPart iPart = ((IPartHost)tileEntity).getPart(side);
        if (iPart == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.part.PartECBase");
        }
        Object object = ((PartECBase)iPart).getClientGuiElement(player);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"((world.getTileEntity(Bl\u2026tClientGuiElement(player)");
        return object;
    }

    @JvmStatic
    public static final void launchGui(int id, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull Object[] args) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        temp = args;
        GuiHandler.hand = hand;
        player.openGui((Object)AEAdditions.INSTANCE, id, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    @JvmStatic
    @NotNull
    public static final Object launchGui(int id, @NotNull EntityPlayer player, @NotNull World world, int x, int y, int z) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        player.openGui((Object)AEAdditions.INSTANCE, id, world, x, y, z);
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final boolean hasPermissions(@NotNull BlockPos pos, @NotNull AEPartLocation side, @NotNull EntityPlayer player) {
        IPart part;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        World world = player.func_130014_f_();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return true;
        }
        if (tileEntity instanceof IGuiProvider) {
            return INSTANCE.securityCheck(tileEntity, player);
        }
        if (tileEntity instanceof IPartHost && (part = ((IPartHost)tileEntity).getPart(side)) != null) {
            return INSTANCE.securityCheck(part, player);
        }
        return false;
    }

    private final boolean securityCheck(Object tileEntity, EntityPlayer player) {
        if (tileEntity instanceof IActionHost) {
            IGridNode iGridNode = ((IActionHost)tileEntity).getActionableNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)iGridNode, (String)"tileEntity.actionableNode");
            IGridNode actionableNode = iGridNode;
            if (actionableNode != null) {
                IGrid iGrid = actionableNode.getGrid();
                Intrinsics.checkExpressionValueIsNotNull((Object)iGrid, (String)"actionableNode.grid");
                IGrid grid = iGrid;
                boolean requirePower = false;
                IGridCache iGridCache = grid.getCache(ISecurityGrid.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)iGridCache, (String)"grid.getCache<ISecurityG\u2026SecurityGrid::class.java)");
                ISecurityGrid securityGrid = (ISecurityGrid)iGridCache;
                if (securityGrid.hasPermission(player, SecurityPermissions.BUILD)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Nullable
    public Object getServerGuiElement(int id, @Nullable EntityPlayer player, @Nullable World world, int x, int y, int z) {
        TileEntity tileEntity;
        if (player == null) {
            return null;
        }
        Object container = this.getContainerBlockElement(player, world, x, y, z);
        if (container != null) {
            return container;
        }
        EnumFacing side = null;
        if (id <= 5) {
            side = EnumFacing.field_82609_l[id];
        }
        BlockPos pos = new BlockPos(x, y, z);
        World world2 = world;
        Object object = tileEntity = world2 != null ? world2.func_175625_s(pos) : null;
        if (tileEntity == null) {
            if (id >= 6) {
                return this.getContainer(id - 6, player, temp);
            }
            return null;
        }
        if (tileEntity instanceof IGuiProvider) {
            return ((IGuiProvider)tileEntity).getServerGuiElement(player, new Object[0]);
        }
        if (tileEntity instanceof IPartHost) {
            if (world != null && side != null) {
                return GuiHandler.getPartContainer(side, player, world, x, y, z);
            }
            if (id >= 6) {
                return this.getContainer(id - 6, player, temp);
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int id, @Nullable EntityPlayer player, @Nullable World world, int x, int y, int z) {
        TileEntity tileEntity;
        if (player == null) {
            return null;
        }
        Object gui = this.getGuiBlockElement(player, world, x, y, z);
        if (gui != null) {
            return gui;
        }
        EnumFacing side = null;
        if (id <= 5) {
            side = EnumFacing.field_82609_l[id];
        }
        BlockPos pos = new BlockPos(x, y, z);
        World world2 = world;
        Object object = tileEntity = world2 != null ? world2.func_175625_s(pos) : null;
        if (tileEntity == null) {
            if (id >= 6) {
                return this.getGui(id - 6, player);
            }
            return null;
        }
        if (tileEntity instanceof IGuiProvider) {
            return ((IGuiProvider)tileEntity).getClientGuiElement(player, new Object[0]);
        }
        if (tileEntity instanceof IPartHost) {
            if (world != null && side != null) {
                return GuiHandler.getPartGui(side, player, world, x, y, z);
            }
            if (id >= 6) {
                return this.getGui(id - 6, player);
            }
        }
        return null;
    }

    @Nullable
    public final Object getGuiBlockElement(@Nullable EntityPlayer player, @Nullable World world, int x, int y, int z) {
        Block block;
        if (world == null || player == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState iBlockState = world.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
        Block block2 = iBlockState.func_177230_c();
        if (block2 == null) {
            return null;
        }
        Block block3 = block = block2;
        return block3 instanceof IGuiBlock ? ((IGuiBlock)block).getClientGuiElement(player, world, pos) : null;
    }

    @Nullable
    public final Object getContainerBlockElement(@Nullable EntityPlayer player, @Nullable World world, int x, int y, int z) {
        Block block;
        if (world == null || player == null) {
            return null;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState iBlockState = world.func_180495_p(pos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
        Block block2 = iBlockState.func_177230_c();
        if (block2 == null) {
            return null;
        }
        Block block3 = block = block2;
        return block3 instanceof IGuiBlock ? ((IGuiBlock)block).getServerGuiElement(player, world, pos) : null;
    }

    private GuiHandler() {
    }

    static {
        GuiHandler guiHandler;
        INSTANCE = guiHandler = new GuiHandler();
        temp = new Object[0];
    }
}

